/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.survey.service;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.upload.FormFile;
import org.lamsfoundation.lams.contentrepository.AccessDeniedException;
import org.lamsfoundation.lams.contentrepository.ICredentials;
import org.lamsfoundation.lams.contentrepository.ITicket;
import org.lamsfoundation.lams.contentrepository.InvalidParameterException;
import org.lamsfoundation.lams.contentrepository.LoginException;
import org.lamsfoundation.lams.contentrepository.NodeKey;
import org.lamsfoundation.lams.contentrepository.RepositoryCheckedException;
import org.lamsfoundation.lams.contentrepository.WorkspaceNotFoundException;
import org.lamsfoundation.lams.contentrepository.client.IToolContentHandler;
import org.lamsfoundation.lams.contentrepository.service.IRepositoryService;
import org.lamsfoundation.lams.contentrepository.service.SimpleCredentials;
import org.lamsfoundation.lams.learning.service.ILearnerService;
import org.lamsfoundation.lams.learningdesign.service.ExportToolContentException;
import org.lamsfoundation.lams.learningdesign.service.IExportToolContentService;
import org.lamsfoundation.lams.learningdesign.service.ImportToolContentException;
import org.lamsfoundation.lams.notebook.model.NotebookEntry;
import org.lamsfoundation.lams.notebook.service.CoreNotebookConstants;
import org.lamsfoundation.lams.notebook.service.ICoreNotebookService;
import org.lamsfoundation.lams.tool.ToolContentImport102Manager;
import org.lamsfoundation.lams.tool.ToolContentManager;
import org.lamsfoundation.lams.tool.ToolOutput;
import org.lamsfoundation.lams.tool.ToolOutputDefinition;
import org.lamsfoundation.lams.tool.ToolSessionExportOutputData;
import org.lamsfoundation.lams.tool.ToolSessionManager;
import org.lamsfoundation.lams.tool.exception.DataMissingException;
import org.lamsfoundation.lams.tool.exception.SessionDataExistsException;
import org.lamsfoundation.lams.tool.exception.ToolException;
import org.lamsfoundation.lams.tool.service.ILamsToolService;
import org.lamsfoundation.lams.tool.survey.dao.SurveyAnswerDAO;
import org.lamsfoundation.lams.tool.survey.dao.SurveyAttachmentDAO;
import org.lamsfoundation.lams.tool.survey.dao.SurveyDAO;
import org.lamsfoundation.lams.tool.survey.dao.SurveyQuestionDAO;
import org.lamsfoundation.lams.tool.survey.dao.SurveySessionDAO;
import org.lamsfoundation.lams.tool.survey.dao.SurveyUserDAO;
import org.lamsfoundation.lams.tool.survey.dto.AnswerDTO;
import org.lamsfoundation.lams.tool.survey.dto.ReflectDTO;
import org.lamsfoundation.lams.tool.survey.model.Survey;
import org.lamsfoundation.lams.tool.survey.model.SurveyAnswer;
import org.lamsfoundation.lams.tool.survey.model.SurveyAttachment;
import org.lamsfoundation.lams.tool.survey.model.SurveyOption;
import org.lamsfoundation.lams.tool.survey.model.SurveyQuestion;
import org.lamsfoundation.lams.tool.survey.model.SurveySession;
import org.lamsfoundation.lams.tool.survey.model.SurveyUser;
import org.lamsfoundation.lams.tool.survey.service.ISurveyService;
import org.lamsfoundation.lams.tool.survey.service.SurveyApplicationException;
import org.lamsfoundation.lams.tool.survey.service.UploadSurveyFileException;
import org.lamsfoundation.lams.tool.survey.util.QuestionsComparator;
import org.lamsfoundation.lams.tool.survey.util.ReflectDTOComparator;
import org.lamsfoundation.lams.tool.survey.util.SurveySessionComparator;
import org.lamsfoundation.lams.tool.survey.util.SurveyToolContentHandler;
import org.lamsfoundation.lams.tool.survey.util.SurveyWebUtils;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.MessageService;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.util.audit.IAuditService;
import org.lamsfoundation.lams.util.wddx.WDDXProcessor;
import org.lamsfoundation.lams.util.wddx.WDDXProcessorConversionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SurveyServiceImpl
implements ISurveyService,
ToolContentManager,
ToolSessionManager,
ToolContentImport102Manager {
    static Logger log = Logger.getLogger((String)SurveyServiceImpl.class.getName());
    private SurveyDAO surveyDao;
    private SurveyQuestionDAO surveyQuestionDao;
    private SurveyAnswerDAO surveyAnswerDao;
    private SurveyAttachmentDAO surveyAttachmentDao;
    private SurveyUserDAO surveyUserDao;
    private SurveySessionDAO surveySessionDao;
    private SurveyToolContentHandler surveyToolContentHandler;
    private MessageService messageService;
    private IRepositoryService repositoryService;
    private ILamsToolService toolService;
    private ILearnerService learnerService;
    private IAuditService auditService;
    private IUserManagementService userManagementService;
    private IExportToolContentService exportContentService;
    private ICoreNotebookService coreNotebookService;

    @Override
    public Survey getSurveyByContentId(Long contentId) {
        Survey rs = this.surveyDao.getByContentId(contentId);
        if (rs == null) {
            log.error((Object)("Could not find the content by given ID:" + contentId));
        }
        return rs;
    }

    @Override
    public Survey getDefaultContent(Long contentId) throws SurveyApplicationException {
        if (contentId == null) {
            String error = this.messageService.getMessage("error.msg.default.content.not.find");
            log.error((Object)error);
            throw new SurveyApplicationException(error);
        }
        Survey defaultContent = this.getDefaultSurvey();
        Survey content = new Survey();
        content = Survey.newInstance(defaultContent, contentId, this.surveyToolContentHandler);
        return content;
    }

    @Override
    public SurveyAttachment uploadInstructionFile(FormFile uploadFile, String fileType) throws UploadSurveyFileException {
        if (uploadFile == null || StringUtils.isEmpty((String)uploadFile.getFileName())) {
            throw new UploadSurveyFileException(this.messageService.getMessage("error.msg.upload.file.not.found", new Object[]{uploadFile}));
        }
        NodeKey nodeKey = this.processFile(uploadFile, fileType);
        SurveyAttachment file = new SurveyAttachment();
        file.setFileType(fileType);
        file.setFileUuid(nodeKey.getUuid());
        file.setFileVersionId(nodeKey.getVersion());
        file.setFileName(uploadFile.getFileName());
        file.setCreated(new Date());
        return file;
    }

    @Override
    public void createUser(SurveyUser surveyUser) {
        this.surveyUserDao.saveObject(surveyUser);
    }

    @Override
    public SurveyUser getUserByIDAndContent(Long userId, Long contentId) {
        return this.surveyUserDao.getUserByUserIDAndContentID(userId, contentId);
    }

    @Override
    public SurveyUser getUserByIDAndSession(Long userId, Long sessionId) {
        return this.surveyUserDao.getUserByUserIDAndSessionID(userId, sessionId);
    }

    @Override
    public void deleteFromRepository(Long fileUuid, Long fileVersionId) throws SurveyApplicationException {
        ITicket ticket = this.getRepositoryLoginTicket();
        try {
            this.repositoryService.deleteVersion(ticket, fileUuid, fileVersionId);
        }
        catch (Exception e) {
            throw new SurveyApplicationException("Exception occured while deleting files from the repository " + e.getMessage());
        }
    }

    @Override
    public void saveOrUpdateSurvey(Survey survey) {
        this.surveyDao.saveObject(survey);
    }

    @Override
    public void deleteSurveyAttachment(Long attachmentUid) {
        this.surveyAttachmentDao.removeObject(SurveyAttachment.class, attachmentUid);
    }

    @Override
    public Survey getSurveyBySessionId(Long sessionId) {
        SurveySession session = this.surveySessionDao.getSessionBySessionId(sessionId);
        Long contentId = session.getSurvey().getContentId();
        Survey res = this.surveyDao.getByContentId(contentId);
        return res;
    }

    @Override
    public SurveySession getSurveySessionBySessionId(Long sessionId) {
        return this.surveySessionDao.getSessionBySessionId(sessionId);
    }

    @Override
    public void saveOrUpdateSurveySession(SurveySession resSession) {
        this.surveySessionDao.saveObject(resSession);
    }

    @Override
    public String finishToolSession(Long toolSessionId, Long userId) throws SurveyApplicationException {
        SurveyUser user = this.surveyUserDao.getUserByUserIDAndSessionID(userId, toolSessionId);
        user.setSessionFinished(true);
        this.surveyUserDao.saveObject(user);
        String nextUrl = null;
        try {
            nextUrl = this.leaveToolSession(toolSessionId, userId);
        }
        catch (DataMissingException e) {
            throw new SurveyApplicationException(e);
        }
        catch (ToolException e) {
            throw new SurveyApplicationException(e);
        }
        return nextUrl;
    }

    @Override
    public Map<Long, Set<ReflectDTO>> getReflectList(Long contentId, boolean setEntry) {
        HashMap<Long, Set<ReflectDTO>> map = new HashMap<Long, Set<ReflectDTO>>();
        List<SurveySession> sessionList = this.surveySessionDao.getByContentId(contentId);
        for (SurveySession session : sessionList) {
            Long sessionId = session.getSessionId();
            boolean hasRefection = session.getSurvey().isReflectOnActivity();
            TreeSet<ReflectDTO> list = new TreeSet<ReflectDTO>(new ReflectDTOComparator());
            List<SurveyUser> users = this.surveyUserDao.getBySessionID(sessionId);
            for (SurveyUser user : users) {
                NotebookEntry entry;
                ReflectDTO ref = new ReflectDTO(user);
                if (setEntry && (entry = this.getEntry(sessionId, CoreNotebookConstants.NOTEBOOK_TOOL, "lasurv11", user.getUserId().intValue())) != null) {
                    ref.setReflect(entry.getEntry());
                }
                ref.setHasRefection(hasRefection);
                list.add(ref);
            }
            map.put(sessionId, list);
        }
        return map;
    }

    @Override
    public Long createNotebookEntry(Long sessionId, Integer notebookToolType, String toolSignature, Integer userId, String entryText) {
        return this.coreNotebookService.createNotebookEntry(sessionId, notebookToolType, toolSignature, userId, "", entryText);
    }

    @Override
    public NotebookEntry getEntry(Long sessionId, Integer idType, String signature, Integer userID) {
        List list = this.coreNotebookService.getEntry(sessionId, idType, signature, userID);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return (NotebookEntry)list.get(0);
    }

    @Override
    public void updateEntry(NotebookEntry notebookEntry) {
        this.coreNotebookService.updateEntry(notebookEntry);
    }

    @Override
    public SurveyUser getUser(Long uid) {
        return (SurveyUser)this.surveyUserDao.getObject(SurveyUser.class, uid);
    }

    @Override
    public List<SurveyUser> getSessionUsers(Long sessionId) {
        return this.surveyUserDao.getBySessionID(sessionId);
    }

    @Override
    public void deleteQuestion(Long uid) {
        this.surveyQuestionDao.removeObject(SurveyQuestion.class, uid);
    }

    @Override
    public List<AnswerDTO> getQuestionAnswers(Long sessionId, Long userUid) {
        Survey survey;
        ArrayList<Object> questions = new ArrayList();
        SurveySession session = this.surveySessionDao.getSessionBySessionId(sessionId);
        if (session != null && (survey = session.getSurvey()) != null) {
            questions = new ArrayList<SurveyQuestion>(survey.getQuestions());
        }
        ArrayList<AnswerDTO> answers = new ArrayList<AnswerDTO>();
        for (SurveyQuestion question : questions) {
            AnswerDTO answerDTO = new AnswerDTO(question);
            SurveyAnswer answer = this.surveyAnswerDao.getAnswer(question.getUid(), userUid);
            if (answer != null) {
                answer.setChoices(SurveyWebUtils.getChoiceList(answer.getAnswerChoices()));
            }
            answerDTO.setAnswer(answer);
            answerDTO.setReplier((SurveyUser)this.surveyUserDao.getObject(SurveyUser.class, userUid));
            answers.add(answerDTO);
        }
        return answers;
    }

    @Override
    public void updateAnswerList(List<SurveyAnswer> answerList) {
        for (SurveyAnswer ans : answerList) {
            this.surveyAnswerDao.saveObject(ans);
        }
    }

    @Override
    public AnswerDTO getQuestionResponse(Long sessionId, Long questionUid) {
        SurveyQuestion question = this.surveyQuestionDao.getByUid(questionUid);
        AnswerDTO answerDto = new AnswerDTO(question);
        List<SurveyAnswer> answsers = this.surveyAnswerDao.getSessionAnswer(sessionId, questionUid);
        HashMap<String, Integer> optMap = new HashMap<String, Integer>();
        Set<SurveyOption> options = answerDto.getOptions();
        int idx = 0;
        for (SurveyOption option : options) {
            optMap.put(option.getUid().toString(), idx);
            ++idx;
        }
        int optSize = options.size();
        if (answerDto.isAppendText() || answerDto.getType() == 3) {
            ++optSize;
        }
        int[] choose = new int[optSize];
        Arrays.fill(choose, 0);
        int answerSum = 0;
        if (answsers != null) {
            for (SurveyAnswer answer : answsers) {
                String[] choseOpt;
                for (String optUid : choseOpt = SurveyWebUtils.getChoiceList(answer.getAnswerChoices())) {
                    if (!optMap.containsKey(optUid)) continue;
                    int n = (Integer)optMap.get(optUid);
                    choose[n] = choose[n] + 1;
                    ++answerSum;
                }
                if (!answerDto.isAppendText() && answerDto.getType() != 3 || StringUtils.isBlank((String)answer.getAnswerText())) continue;
                int n = optSize - 1;
                choose[n] = choose[n] + 1;
                ++answerSum;
            }
        }
        idx = 0;
        if (answerSum == 0) {
            answerSum = 1;
        }
        for (SurveyOption option : options) {
            option.setResponse((double)choose[idx] / (double)answerSum * 100.0);
            option.setResponseFormatStr(new Long(Math.round(option.getResponse())).toString());
            option.setResponseCount(choose[idx]);
            ++idx;
        }
        if (answerDto.isAppendText() || answerDto.getType() == 3) {
            answerDto.setOpenResponse((double)choose[idx] / (double)answerSum * 100.0);
            answerDto.setOpenResponseFormatStr(new Long(Math.round(answerDto.getOpenResponse())).toString());
            answerDto.setOpenResponseCount(choose[idx]);
        }
        return answerDto;
    }

    @Override
    public SortedMap<SurveySession, List<AnswerDTO>> getSummary(Long toolContentId) {
        TreeMap<SurveySession, List<AnswerDTO>> summary = new TreeMap<SurveySession, List<AnswerDTO>>(new SurveySessionComparator());
        Survey survey = this.surveyDao.getByContentId(toolContentId);
        Set<SurveyQuestion> questionList = survey.getQuestions();
        List<SurveySession> sessionList = this.surveySessionDao.getByContentId(toolContentId);
        for (SurveySession session : sessionList) {
            ArrayList<AnswerDTO> responseList = new ArrayList<AnswerDTO>();
            for (SurveyQuestion question : questionList) {
                AnswerDTO response = this.getQuestionResponse(session.getSessionId(), question.getUid());
                responseList.add(response);
            }
            summary.put(session, responseList);
        }
        return summary;
    }

    @Override
    public SortedMap<SurveySession, Integer> getStatistic(Long contentId) {
        TreeMap<SurveySession, Integer> result = new TreeMap<SurveySession, Integer>(new SurveySessionComparator());
        List<SurveySession> sessionList = this.surveySessionDao.getByContentId(contentId);
        if (sessionList == null) {
            return result;
        }
        Iterator<SurveySession> i$ = sessionList.iterator();
        while (i$.hasNext()) {
            SurveySession session;
            List<SurveyUser> users = this.getSessionUsers((session = i$.next()).getSessionId());
            result.put(session, users != null ? users.size() : 0);
        }
        return result;
    }

    @Override
    public SurveyQuestion getQuestion(Long questionUid) {
        return this.surveyQuestionDao.getByUid(questionUid);
    }

    @Override
    public SortedMap<SurveySession, SortedMap<SurveyQuestion, List<AnswerDTO>>> exportByContentId(Long toolContentID) {
        TreeMap<SurveySession, SortedMap<SurveyQuestion, List<AnswerDTO>>> summary = new TreeMap<SurveySession, SortedMap<SurveyQuestion, List<AnswerDTO>>>(new SurveySessionComparator());
        List<SurveySession> sessions = this.surveySessionDao.getByContentId(toolContentID);
        if (sessions != null) {
            for (SurveySession session : sessions) {
                List<SurveyUser> users = this.surveyUserDao.getBySessionID(session.getSessionId());
                ArrayList<List<AnswerDTO>> learnerAnswers = new ArrayList<List<AnswerDTO>>();
                if (users != null) {
                    for (SurveyUser user : users) {
                        List<AnswerDTO> answers = this.getQuestionAnswers(user.getSession().getSessionId(), user.getUid());
                        learnerAnswers.add(answers);
                    }
                }
                this.toQuestionMap(summary, session, learnerAnswers);
            }
        }
        return summary;
    }

    @Override
    public SortedMap<SurveySession, SortedMap<SurveyQuestion, List<AnswerDTO>>> exportBySessionId(Long toolSessionID) {
        TreeMap<SurveySession, SortedMap<SurveyQuestion, List<AnswerDTO>>> summary = new TreeMap<SurveySession, SortedMap<SurveyQuestion, List<AnswerDTO>>>(new SurveySessionComparator());
        SurveySession session = this.surveySessionDao.getSessionBySessionId(toolSessionID);
        List<SurveyUser> users = this.surveyUserDao.getBySessionID(session.getSessionId());
        ArrayList<List<AnswerDTO>> learnerAnswers = new ArrayList<List<AnswerDTO>>();
        if (users != null) {
            for (SurveyUser user : users) {
                List<AnswerDTO> answers = this.getQuestionAnswers(user.getSession().getSessionId(), user.getUid());
                learnerAnswers.add(answers);
            }
        }
        this.toQuestionMap(summary, session, learnerAnswers);
        return summary;
    }

    @Override
    public SortedMap<SurveySession, SortedMap<SurveyQuestion, List<AnswerDTO>>> exportByLearner(SurveyUser learner) {
        TreeMap<SurveySession, SortedMap<SurveyQuestion, List<AnswerDTO>>> summary = new TreeMap<SurveySession, SortedMap<SurveyQuestion, List<AnswerDTO>>>(new SurveySessionComparator());
        SurveySession session = learner.getSession();
        List<AnswerDTO> answers = this.getQuestionAnswers(session.getSessionId(), learner.getUid());
        ArrayList<List<AnswerDTO>> learnerAnswers = new ArrayList<List<AnswerDTO>>();
        learnerAnswers.add(answers);
        this.toQuestionMap(summary, session, learnerAnswers);
        return summary;
    }

    private void toQuestionMap(SortedMap<SurveySession, SortedMap<SurveyQuestion, List<AnswerDTO>>> summary, SurveySession session, List<List<AnswerDTO>> learnerAnswers) {
        TreeMap questionMap = new TreeMap(new QuestionsComparator());
        Survey survey = this.getSurveyBySessionId(session.getSessionId());
        Set<SurveyQuestion> questionList = survey.getQuestions();
        if (questionList != null) {
            for (SurveyQuestion question : questionList) {
                ArrayList<AnswerDTO> queAnsList = new ArrayList<AnswerDTO>();
                questionMap.put(question, queAnsList);
                block1: for (List<AnswerDTO> listAns : learnerAnswers) {
                    for (AnswerDTO answerDTO : listAns) {
                        if (!answerDTO.getUid().equals(question.getUid())) continue;
                        queAnsList.add(answerDTO);
                        continue block1;
                    }
                }
            }
        }
        summary.put(session, questionMap);
    }

    private Survey getDefaultSurvey() throws SurveyApplicationException {
        Long defaultSurveyId = this.getToolDefaultContentIdBySignature("lasurv11");
        Survey defaultSurvey = this.getSurveyByContentId(defaultSurveyId);
        if (defaultSurvey == null) {
            String error = this.messageService.getMessage("error.msg.default.content.not.find");
            log.error((Object)error);
            throw new SurveyApplicationException(error);
        }
        return defaultSurvey;
    }

    private Long getToolDefaultContentIdBySignature(String toolSignature) throws SurveyApplicationException {
        Long contentId = null;
        contentId = new Long(this.toolService.getToolDefaultContentIdBySignature(toolSignature));
        if (contentId == null) {
            String error = this.messageService.getMessage("error.msg.default.content.not.find");
            log.error((Object)error);
            throw new SurveyApplicationException(error);
        }
        return contentId;
    }

    private NodeKey processFile(FormFile file, String fileType) throws UploadSurveyFileException {
        NodeKey node = null;
        if (file != null && !StringUtils.isEmpty((String)file.getFileName())) {
            String fileName = file.getFileName();
            try {
                node = this.surveyToolContentHandler.uploadFile(file.getInputStream(), fileName, file.getContentType(), fileType);
            }
            catch (InvalidParameterException e) {
                throw new UploadSurveyFileException(this.messageService.getMessage("error.msg.invaid.param.upload"));
            }
            catch (FileNotFoundException e) {
                throw new UploadSurveyFileException(this.messageService.getMessage("error.msg.file.not.found"));
            }
            catch (RepositoryCheckedException e) {
                throw new UploadSurveyFileException(this.messageService.getMessage("error.msg.repository"));
            }
            catch (IOException e) {
                throw new UploadSurveyFileException(this.messageService.getMessage("error.msg.io.exception"));
            }
        }
        return node;
    }

    private ITicket getRepositoryLoginTicket() throws SurveyApplicationException {
        SimpleCredentials credentials = new SimpleCredentials(this.surveyToolContentHandler.getRepositoryUser(), this.surveyToolContentHandler.getRepositoryId());
        try {
            ITicket ticket = this.repositoryService.login((ICredentials)credentials, this.surveyToolContentHandler.getRepositoryWorkspaceName());
            return ticket;
        }
        catch (AccessDeniedException ae) {
            throw new SurveyApplicationException("Access Denied to repository." + ae.getMessage());
        }
        catch (WorkspaceNotFoundException we) {
            throw new SurveyApplicationException("Workspace not found." + we.getMessage());
        }
        catch (LoginException e) {
            throw new SurveyApplicationException("Login failed." + e.getMessage());
        }
    }

    public void exportToolContent(Long toolContentId, String rootPath) throws DataMissingException, ToolException {
        Survey toolContentObj = this.surveyDao.getByContentId(toolContentId);
        if (toolContentObj == null) {
            try {
                toolContentObj = this.getDefaultSurvey();
            }
            catch (SurveyApplicationException e) {
                throw new DataMissingException(e.getMessage());
            }
        }
        if (toolContentObj == null) {
            throw new DataMissingException("Unable to find default content for the survey tool");
        }
        toolContentObj = Survey.newInstance(toolContentObj, toolContentId, null);
        toolContentObj.setToolContentHandler(null);
        toolContentObj.setOfflineFileList(null);
        toolContentObj.setOnlineFileList(null);
        try {
            this.exportContentService.registerFileClassForExport(SurveyAttachment.class.getName(), "fileUuid", "fileVersionId");
            this.exportContentService.exportToolContent(toolContentId, (Object)toolContentObj, (IToolContentHandler)this.surveyToolContentHandler, rootPath);
        }
        catch (ExportToolContentException e) {
            throw new ToolException((Throwable)e);
        }
    }

    public void importToolContent(Long toolContentId, Integer newUserUid, String toolContentPath, String fromVersion, String toVersion) throws ToolException {
        try {
            this.exportContentService.registerFileClassForImport(SurveyAttachment.class.getName(), "fileUuid", "fileVersionId", "fileName", "fileType", null, null);
            Object toolPOJO = this.exportContentService.importToolContent(toolContentPath, (IToolContentHandler)this.surveyToolContentHandler, fromVersion, toVersion);
            if (!(toolPOJO instanceof Survey)) {
                throw new ImportToolContentException("Import survey tool content failed. Deserialized object is " + toolPOJO);
            }
            Survey toolContentObj = (Survey)toolPOJO;
            toolContentObj.setContentId(toolContentId);
            SurveyUser user = this.surveyUserDao.getUserByUserIDAndContentID(new Long(newUserUid.longValue()), toolContentId);
            if (user == null) {
                user = new SurveyUser();
                UserDTO sysUser = ((User)this.userManagementService.findById(User.class, (Serializable)newUserUid)).getUserDTO();
                user.setFirstName(sysUser.getFirstName());
                user.setLastName(sysUser.getLastName());
                user.setLoginName(sysUser.getLogin());
                user.setUserId(new Long(newUserUid.longValue()));
                user.setSurvey(toolContentObj);
            }
            toolContentObj.setCreatedBy(user);
            Set<SurveyQuestion> items = toolContentObj.getQuestions();
            for (SurveyQuestion item : items) {
                item.setCreateBy(user);
            }
            this.surveyDao.saveObject(toolContentObj);
        }
        catch (ImportToolContentException e) {
            throw new ToolException((Throwable)e);
        }
    }

    public SortedMap<String, ToolOutputDefinition> getToolOutputDefinitions(Long toolContentId) throws ToolException {
        return new TreeMap<String, ToolOutputDefinition>();
    }

    public void copyToolContent(Long fromContentId, Long toContentId) throws ToolException {
        if (toContentId == null) {
            throw new ToolException("Failed to create the SharedSurveyFiles tool seession");
        }
        Survey survey = null;
        if (fromContentId != null) {
            survey = this.surveyDao.getByContentId(fromContentId);
        }
        if (survey == null) {
            try {
                survey = this.getDefaultSurvey();
            }
            catch (SurveyApplicationException e) {
                throw new ToolException((Throwable)e);
            }
        }
        Survey toContent = Survey.newInstance(survey, toContentId, this.surveyToolContentHandler);
        this.surveyDao.saveObject(toContent);
        Set<SurveyQuestion> items = toContent.getQuestions();
        if (items != null) {
            for (SurveyQuestion item : items) {
            }
        }
    }

    public void setAsDefineLater(Long toolContentId, boolean value) throws DataMissingException, ToolException {
        Survey survey = this.surveyDao.getByContentId(toolContentId);
        if (survey == null) {
            throw new ToolException("No found tool content by given content ID:" + toolContentId);
        }
        survey.setDefineLater(value);
    }

    public void setAsRunOffline(Long toolContentId, boolean value) throws DataMissingException, ToolException {
        Survey survey = this.surveyDao.getByContentId(toolContentId);
        if (survey == null) {
            throw new ToolException("No found tool content by given content ID:" + toolContentId);
        }
        survey.setRunOffline(value);
    }

    public void removeToolContent(Long toolContentId, boolean removeSessionData) throws SessionDataExistsException, ToolException {
        Survey survey = this.surveyDao.getByContentId(toolContentId);
        if (removeSessionData) {
            List<SurveySession> list = this.surveySessionDao.getByContentId(toolContentId);
            for (SurveySession session : list) {
                this.surveySessionDao.delete(session);
            }
        }
        this.surveyDao.delete(survey);
    }

    public void createToolSession(Long toolSessionId, String toolSessionName, Long toolContentId) throws ToolException {
        SurveySession session = new SurveySession();
        session.setSessionId(toolSessionId);
        session.setSessionName(toolSessionName);
        Survey survey = this.surveyDao.getByContentId(toolContentId);
        session.setSurvey(survey);
        this.surveySessionDao.saveObject(session);
    }

    public String leaveToolSession(Long toolSessionId, Long learnerId) throws DataMissingException, ToolException {
        if (toolSessionId == null) {
            log.error((Object)"Fail to leave tool Session based on null tool session id.");
            throw new ToolException("Fail to remove tool Session based on null tool session id.");
        }
        if (learnerId == null) {
            log.error((Object)"Fail to leave tool Session based on null learner.");
            throw new ToolException("Fail to remove tool Session based on null learner.");
        }
        return this.learnerService.completeToolSession(toolSessionId, learnerId);
    }

    public ToolSessionExportOutputData exportToolSession(Long toolSessionId) throws DataMissingException, ToolException {
        return null;
    }

    public ToolSessionExportOutputData exportToolSession(List toolSessionIds) throws DataMissingException, ToolException {
        return null;
    }

    public void removeToolSession(Long toolSessionId) throws DataMissingException, ToolException {
        this.surveySessionDao.deleteBySessionId(toolSessionId);
    }

    public SortedMap<String, ToolOutput> getToolOutput(List<String> names, Long toolSessionId, Long learnerId) {
        return new TreeMap<String, ToolOutput>();
    }

    public ToolOutput getToolOutput(String name, Long toolSessionId, Long learnerId) {
        return null;
    }

    public void import102ToolContent(Long toolContentId, UserDTO user, Hashtable importValues) {
        Date now = new Date();
        Survey toolContentObj = new Survey();
        try {
            toolContentObj.setTitle((String)importValues.get("title"));
            toolContentObj.setContentId(toolContentId);
            toolContentObj.setContentInUse(Boolean.FALSE);
            toolContentObj.setCreated(now);
            toolContentObj.setDefineLater(Boolean.FALSE);
            toolContentObj.setInstructions(WebUtil.convertNewlines((String)((String)importValues.get("body"))));
            toolContentObj.setOfflineInstructions(null);
            toolContentObj.setOnlineInstructions(null);
            toolContentObj.setRunOffline(Boolean.FALSE);
            toolContentObj.setUpdated(now);
            Boolean isReusable = WDDXProcessor.convertToBoolean((Hashtable)importValues, (String)"isReusable");
            toolContentObj.setLockWhenFinished(isReusable != null ? !isReusable.booleanValue() : true);
            SurveyUser ruser = new SurveyUser();
            ruser.setUserId(new Long(user.getUserID().longValue()));
            ruser.setFirstName(user.getFirstName());
            ruser.setLastName(user.getLastName());
            ruser.setLoginName(user.getLogin());
            this.createUser(ruser);
            toolContentObj.setCreatedBy(ruser);
            toolContentObj.setQuestions(new HashSet());
            Vector questions = (Vector)importValues.get("questions");
            if (questions != null) {
                int dummySequenceNumber = questions.size();
                for (Hashtable questionMap : questions) {
                    SurveyQuestion item = new SurveyQuestion();
                    item.setCreateDate(now);
                    item.setCreateBy(ruser);
                    String surveyType = (String)questionMap.get("questionType");
                    if ("simpleChoice".equals(surveyType)) {
                        item.setType((short)1);
                        item.setAllowMultipleAnswer(false);
                    } else if ("choiceMultiple".equals(surveyType)) {
                        item.setType((short)2);
                        item.setAllowMultipleAnswer(true);
                    } else {
                        item.setType((short)3);
                        item.setAllowMultipleAnswer(false);
                    }
                    Integer order = WDDXProcessor.convertToInteger((Hashtable)questionMap, (String)"order");
                    item.setSequenceId(order != null ? order : dummySequenceNumber++);
                    item.setDescription(WebUtil.convertNewlines((String)((String)questionMap.get("question"))));
                    Boolean appendText = WDDXProcessor.convertToBoolean((Hashtable)questionMap, (String)"isTextBoxEnabled");
                    item.setAppendText(appendText != null ? appendText : false);
                    Boolean isOptional = WDDXProcessor.convertToBoolean((Hashtable)questionMap, (String)"isOptional");
                    item.setOptional(isOptional != null ? isOptional : false);
                    Vector candidates = (Vector)questionMap.get("candidates");
                    if (candidates != null && candidates.size() > 0) {
                        item.setOptions(new HashSet<SurveyOption>());
                        int dummyCandidateOrder = candidates.size();
                        for (Hashtable candidateEntry : candidates) {
                            String candidateText = (String)candidateEntry.get("answer");
                            Integer candidateOrder = WDDXProcessor.convertToInteger((Hashtable)candidateEntry, (String)"order");
                            SurveyOption option = new SurveyOption();
                            option.setDescription(candidateText);
                            option.setSequenceId(candidateOrder != null ? candidateOrder : dummyCandidateOrder++);
                            item.getOptions().add(option);
                        }
                    }
                    toolContentObj.getQuestions().add(item);
                }
            }
        }
        catch (WDDXProcessorConversionException e) {
            log.error((Object)("Unable to content for activity " + toolContentObj.getTitle() + "properly due to a WDDXProcessorConversionException."), (Throwable)e);
            throw new ToolException("Invalid import data format for activity " + toolContentObj.getTitle() + "- WDDX caused an exception. Some data from the design will have been lost. See log for more details.");
        }
        this.surveyDao.saveObject(toolContentObj);
    }

    public void setReflectiveData(Long toolContentId, String title, String description) throws ToolException, DataMissingException {
        Survey toolContentObj = this.getSurveyByContentId(toolContentId);
        if (toolContentObj == null) {
            throw new DataMissingException("Unable to set reflective data titled " + title + " on activity toolContentId " + toolContentId + " as the tool content does not exist.");
        }
    }

    public void setAuditService(IAuditService auditService) {
        this.auditService = auditService;
    }

    public void setLearnerService(ILearnerService learnerService) {
        this.learnerService = learnerService;
    }

    public void setMessageService(MessageService messageService) {
        this.messageService = messageService;
    }

    public void setRepositoryService(IRepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    public void setSurveyAttachmentDao(SurveyAttachmentDAO surveyAttachmentDao) {
        this.surveyAttachmentDao = surveyAttachmentDao;
    }

    public void setSurveyDao(SurveyDAO surveyDao) {
        this.surveyDao = surveyDao;
    }

    public void setSurveyQuestionDao(SurveyQuestionDAO surveyItemDao) {
        this.surveyQuestionDao = surveyItemDao;
    }

    public void setSurveySessionDao(SurveySessionDAO surveySessionDao) {
        this.surveySessionDao = surveySessionDao;
    }

    public void setSurveyToolContentHandler(SurveyToolContentHandler surveyToolContentHandler) {
        this.surveyToolContentHandler = surveyToolContentHandler;
    }

    public void setSurveyUserDao(SurveyUserDAO surveyUserDao) {
        this.surveyUserDao = surveyUserDao;
    }

    public void setToolService(ILamsToolService toolService) {
        this.toolService = toolService;
    }

    public IExportToolContentService getExportContentService() {
        return this.exportContentService;
    }

    public void setExportContentService(IExportToolContentService exportContentService) {
        this.exportContentService = exportContentService;
    }

    public IUserManagementService getUserManagementService() {
        return this.userManagementService;
    }

    public void setUserManagementService(IUserManagementService userManagementService) {
        this.userManagementService = userManagementService;
    }

    public ICoreNotebookService getCoreNotebookService() {
        return this.coreNotebookService;
    }

    public void setCoreNotebookService(ICoreNotebookService coreNotebookService) {
        this.coreNotebookService = coreNotebookService;
    }

    public void setSurveyAnswerDao(SurveyAnswerDAO surveyAnswerDao) {
        this.surveyAnswerDao = surveyAnswerDao;
    }
}

