/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.survey.web.action;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.upload.FormFile;
import org.lamsfoundation.lams.tool.ToolAccessMode;
import org.lamsfoundation.lams.tool.survey.model.Survey;
import org.lamsfoundation.lams.tool.survey.model.SurveyAttachment;
import org.lamsfoundation.lams.tool.survey.model.SurveyOption;
import org.lamsfoundation.lams.tool.survey.model.SurveyQuestion;
import org.lamsfoundation.lams.tool.survey.model.SurveyUser;
import org.lamsfoundation.lams.tool.survey.service.ISurveyService;
import org.lamsfoundation.lams.tool.survey.service.UploadSurveyFileException;
import org.lamsfoundation.lams.tool.survey.util.QuestionsComparator;
import org.lamsfoundation.lams.tool.survey.util.SurveyWebUtils;
import org.lamsfoundation.lams.tool.survey.web.form.QuestionForm;
import org.lamsfoundation.lams.tool.survey.web.form.SurveyForm;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.util.FileValidatorUtil;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.lamsfoundation.lams.web.util.SessionMap;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthoringAction
extends Action {
    private static final int INIT_INSTRUCTION_COUNT = 2;
    private static final String INSTRUCTION_ITEM_DESC_PREFIX = "instructionItemDesc";
    private static final String INSTRUCTION_ITEM_COUNT = "instructionCount";
    private static final int SHORT_TITLE_LENGTH = 60;
    private static Logger log = Logger.getLogger(AuthoringAction.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String param = mapping.getParameter();
        if (param.equals("start")) {
            ToolAccessMode mode = this.getAccessMode(request);
            if (mode != null) {
                request.setAttribute("mode", (Object)mode.toString());
            } else {
                request.setAttribute("mode", (Object)ToolAccessMode.AUTHOR.toString());
            }
            return this.start(mapping, form, request, response);
        }
        if (param.equals("definelater")) {
            Long contentId = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"toolContentID"));
            ISurveyService service = this.getSurveyService();
            Survey survey = service.getSurveyByContentId(contentId);
            boolean isEditable = SurveyWebUtils.isSurveyEditable(survey);
            if (!isEditable) {
                request.setAttribute("isPageEditable", (Object)new Boolean(isEditable));
                return mapping.findForward("forbidden");
            }
            if (!survey.isContentInUse()) {
                survey.setDefineLater(true);
                service.saveOrUpdateSurvey(survey);
            }
            request.setAttribute("mode", (Object)ToolAccessMode.TEACHER.toString());
            return this.start(mapping, form, request, response);
        }
        if (param.equals("initPage")) {
            return this.initPage(mapping, form, request, response);
        }
        if (param.equals("updateContent")) {
            return this.updateContent(mapping, form, request, response);
        }
        if (param.equals("uploadOnlineFile")) {
            return this.uploadOnline(mapping, form, request, response);
        }
        if (param.equals("uploadOfflineFile")) {
            return this.uploadOffline(mapping, form, request, response);
        }
        if (param.equals("deleteOnlineFile")) {
            return this.deleteOnlineFile(mapping, form, request, response);
        }
        if (param.equals("deleteOfflineFile")) {
            return this.deleteOfflineFile(mapping, form, request, response);
        }
        if (param.equals("newItemInit")) {
            return this.newItemlInit(mapping, form, request, response);
        }
        if (param.equals("editItemInit")) {
            return this.editItemInit(mapping, form, request, response);
        }
        if (param.equals("saveOrUpdateItem")) {
            return this.saveOrUpdateItem(mapping, form, request, response);
        }
        if (param.equals("removeItem")) {
            return this.removeItem(mapping, form, request, response);
        }
        if (param.equals("upItem")) {
            return this.upItem(mapping, form, request, response);
        }
        if (param.equals("downItem")) {
            return this.downItem(mapping, form, request, response);
        }
        if (param.equals("newInstruction")) {
            return this.newInstruction(mapping, form, request, response);
        }
        if (param.equals("removeInstruction")) {
            return this.removeInstruction(mapping, form, request, response);
        }
        return mapping.findForward("error");
    }

    private ActionForward removeItem(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String sessionMapID = WebUtil.readStrParam((HttpServletRequest)request, (String)"sessionMapID");
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(sessionMapID);
        int itemIdx = NumberUtils.stringToInt((String)request.getParameter("itemIndex"), (int)-1);
        if (itemIdx != -1) {
            SortedSet<SurveyQuestion> surveyList = this.getSurveyItemList(sessionMap);
            ArrayList<SurveyQuestion> rList = new ArrayList<SurveyQuestion>(surveyList);
            SurveyQuestion item = (SurveyQuestion)rList.remove(itemIdx);
            surveyList.clear();
            surveyList.addAll(rList);
            List delList = this.getDeletedSurveyItemList(sessionMap);
            delList.add(item);
        }
        request.setAttribute("sessionMapID", (Object)sessionMapID);
        return mapping.findForward("success");
    }

    private ActionForward upItem(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return this.switchItem(mapping, request, true);
    }

    private ActionForward downItem(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return this.switchItem(mapping, request, false);
    }

    private ActionForward switchItem(ActionMapping mapping, HttpServletRequest request, boolean up) {
        String sessionMapID = WebUtil.readStrParam((HttpServletRequest)request, (String)"sessionMapID");
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(sessionMapID);
        int itemIdx = NumberUtils.stringToInt((String)request.getParameter("itemIndex"), (int)-1);
        if (itemIdx != -1) {
            SortedSet<SurveyQuestion> surveyList = this.getSurveyItemList(sessionMap);
            ArrayList<SurveyQuestion> rList = new ArrayList<SurveyQuestion>(surveyList);
            SurveyQuestion item = (SurveyQuestion)rList.get(itemIdx);
            SurveyQuestion repItem = up ? (SurveyQuestion)rList.get(--itemIdx) : (SurveyQuestion)rList.get(++itemIdx);
            int upSeqId = repItem.getSequenceId();
            repItem.setSequenceId(item.getSequenceId());
            item.setSequenceId(upSeqId);
            surveyList.clear();
            surveyList.addAll(rList);
        }
        request.setAttribute("sessionMapID", (Object)sessionMapID);
        return mapping.findForward("success");
    }

    private ActionForward editItemInit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        SortedSet<SurveyQuestion> surveyList;
        ArrayList<SurveyQuestion> rList;
        QuestionForm itemForm = (QuestionForm)form;
        String sessionMapID = WebUtil.readStrParam((HttpServletRequest)request, (String)"sessionMapID");
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(sessionMapID);
        int itemIdx = NumberUtils.stringToInt((String)request.getParameter("itemIndex"), (int)-1);
        SurveyQuestion item = null;
        if (itemIdx != -1 && (item = (SurveyQuestion)(rList = new ArrayList<SurveyQuestion>(surveyList = this.getSurveyItemList(sessionMap))).get(itemIdx)) != null) {
            this.populateItemToForm(itemIdx, item, itemForm, request);
        }
        if (itemForm.getItemType() == 3) {
            return mapping.findForward("opentext");
        }
        return mapping.findForward("question");
    }

    private ActionForward newItemlInit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        QuestionForm questionForm = (QuestionForm)form;
        ArrayList<String> instructionList = new ArrayList<String>(2);
        for (int idx = 0; idx < 2; ++idx) {
            instructionList.add("");
        }
        request.setAttribute("instructionList", instructionList);
        if (questionForm.getItemType() == 3) {
            return mapping.findForward("opentext");
        }
        return mapping.findForward("question");
    }

    private ActionForward saveOrUpdateItem(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        QuestionForm itemForm = (QuestionForm)form;
        List<String> instructionList = this.getInstructionsFromRequest(request);
        ActionErrors errors = this.validateSurveyItem(itemForm, instructionList);
        if (!errors.isEmpty()) {
            this.addErrors(request, (ActionMessages)errors);
            for (int idx = instructionList.size(); idx < 2; ++idx) {
                instructionList.add("");
            }
            request.setAttribute("instructionList", instructionList);
            if (itemForm.getItemType() == 3) {
                return mapping.findForward("opentext");
            }
            return mapping.findForward("question");
        }
        try {
            this.extractFormToSurveyItem(request, instructionList, itemForm);
        }
        catch (Exception e) {
            log.error((Object)("Uploading failed. The exception is " + e.toString()));
            throw e;
        }
        request.setAttribute("sessionMapID", (Object)itemForm.getSessionMapID());
        request.setAttribute("contentFolderID", (Object)itemForm.getContentFolderID());
        return mapping.findForward("success");
    }

    private ActionForward start(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Long contentId = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"toolContentID"));
        ISurveyService service = this.getSurveyService();
        ArrayList<SurveyQuestion> questions = null;
        Survey survey = null;
        SurveyForm surveyForm = (SurveyForm)form;
        String contentFolderID = WebUtil.readStrParam((HttpServletRequest)request, (String)"contentFolderID");
        surveyForm.setContentFolderID(contentFolderID);
        SessionMap sessionMap = new SessionMap();
        request.getSession().setAttribute(sessionMap.getSessionID(), (Object)sessionMap);
        surveyForm.setSessionMapID(sessionMap.getSessionID());
        survey = service.getSurveyByContentId(contentId);
        questions = survey == null ? ((survey = service.getDefaultContent(contentId)).getQuestions() != null ? new ArrayList<SurveyQuestion>(survey.getQuestions()) : null) : new ArrayList<SurveyQuestion>(survey.getQuestions());
        surveyForm.setSurvey(survey);
        List attachmentList = this.getAttachmentList(sessionMap);
        attachmentList.clear();
        attachmentList.addAll(survey.getAttachments());
        if (questions == null) {
            questions = new ArrayList();
        } else {
            SurveyUser surveyUser = null;
            for (SurveyQuestion question : questions) {
                if (question.getCreateBy() != null) continue;
                if (surveyUser == null) {
                    HttpSession ss = SessionManager.getSession();
                    UserDTO user = (UserDTO)ss.getAttribute("user");
                    surveyUser = new SurveyUser(user, survey);
                }
                question.setCreateBy(surveyUser);
            }
        }
        SortedSet<SurveyQuestion> surveyItemList = this.getSurveyItemList(sessionMap);
        surveyItemList.clear();
        this.retriveQuestionListForDisplay(questions);
        surveyItemList.addAll(questions);
        sessionMap.put((Object)"surveyForm", (Object)surveyForm);
        return mapping.findForward("success");
    }

    private ActionForward initPage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws ServletException {
        String sessionMapID = WebUtil.readStrParam((HttpServletRequest)request, (String)"sessionMapID");
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(sessionMapID);
        SurveyForm existForm = (SurveyForm)((Object)sessionMap.get((Object)"surveyForm"));
        SurveyForm surveyForm = (SurveyForm)form;
        try {
            PropertyUtils.copyProperties((Object)((Object)surveyForm), (Object)((Object)existForm));
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        ToolAccessMode mode = this.getAccessMode(request);
        if (mode.isAuthor()) {
            return mapping.findForward("success");
        }
        return mapping.findForward("definelater");
    }

    private ActionForward updateContent(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SurveyForm surveyForm = (SurveyForm)form;
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(surveyForm.getSessionMapID());
        ToolAccessMode mode = this.getAccessMode(request);
        ActionMessages errors = this.validate(surveyForm, mapping, request);
        if (!errors.isEmpty()) {
            this.saveErrors(request, errors);
            if (mode.isAuthor()) {
                return mapping.findForward("author");
            }
            return mapping.findForward("monitor");
        }
        Survey survey = surveyForm.getSurvey();
        ISurveyService service = this.getSurveyService();
        Survey surveyPO = service.getSurveyByContentId(surveyForm.getSurvey().getContentId());
        if (surveyPO == null) {
            surveyPO = survey;
            surveyPO.setCreated(new Timestamp(new Date().getTime()));
            surveyPO.setUpdated(new Timestamp(new Date().getTime()));
        } else {
            if (mode.isAuthor()) {
                Long uid = surveyPO.getUid();
                PropertyUtils.copyProperties((Object)surveyPO, (Object)survey);
                surveyPO.setUid(uid);
            } else {
                surveyPO.setInstructions(survey.getInstructions());
                surveyPO.setTitle(survey.getTitle());
                surveyPO.setDefineLater(false);
            }
            surveyPO.setUpdated(new Timestamp(new Date().getTime()));
        }
        HttpSession ss = SessionManager.getSession();
        UserDTO user = (UserDTO)ss.getAttribute("user");
        SurveyUser surveyUser = service.getUserByIDAndContent(new Long(user.getUserID().intValue()), surveyForm.getSurvey().getContentId());
        if (surveyUser == null) {
            surveyUser = new SurveyUser(user, surveyPO);
        }
        surveyPO.setCreatedBy(surveyUser);
        HashSet<SurveyAttachment> attPOSet = surveyPO.getAttachments();
        if (attPOSet == null) {
            attPOSet = new HashSet<SurveyAttachment>();
        }
        List attachmentList = this.getAttachmentList(sessionMap);
        List deleteAttachmentList = this.getDeletedAttachmentList(sessionMap);
        for (SurveyAttachment newAtt : attachmentList) {
            attPOSet.add(newAtt);
        }
        attachmentList.clear();
        Iterator iter = deleteAttachmentList.iterator();
        while (iter.hasNext()) {
            SurveyAttachment delAtt = (SurveyAttachment)iter.next();
            iter.remove();
            if (delAtt.getUid() == null) continue;
            Iterator attIter = attPOSet.iterator();
            while (attIter.hasNext()) {
                SurveyAttachment att = (SurveyAttachment)attIter.next();
                if (!delAtt.getUid().equals(att.getUid())) continue;
                attIter.remove();
                break;
            }
            service.deleteSurveyAttachment(delAtt.getUid());
        }
        surveyPO.setAttachments(attPOSet);
        LinkedHashSet<SurveyQuestion> questionList = new LinkedHashSet<SurveyQuestion>();
        SortedSet<SurveyQuestion> topics = this.getSurveyItemList(sessionMap);
        for (SurveyQuestion item : topics) {
            if (item == null) continue;
            item.setCreateBy(surveyUser);
            questionList.add(item);
        }
        surveyPO.setQuestions(questionList);
        List delSurveyItemList = this.getDeletedSurveyItemList(sessionMap);
        iter = delSurveyItemList.iterator();
        while (iter.hasNext()) {
            SurveyQuestion item = (SurveyQuestion)iter.next();
            iter.remove();
            if (item.getUid() == null) continue;
            service.deleteQuestion(item.getUid());
        }
        service.saveOrUpdateSurvey(surveyPO);
        attachmentList = this.getAttachmentList(sessionMap);
        attachmentList.addAll(survey.getAttachments());
        surveyForm.setSurvey(surveyPO);
        request.setAttribute("LAMS_AUTHORING_SUCCESS_FLAG", (Object)Boolean.TRUE);
        if (mode.isAuthor()) {
            return mapping.findForward("author");
        }
        return mapping.findForward("monitor");
    }

    public ActionForward uploadOnline(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws UploadSurveyFileException {
        return this.uploadFile(mapping, form, "ONLINE", request);
    }

    public ActionForward uploadOffline(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws UploadSurveyFileException {
        return this.uploadFile(mapping, form, "OFFLINE", request);
    }

    private ActionForward uploadFile(ActionMapping mapping, ActionForm form, String type, HttpServletRequest request) throws UploadSurveyFileException {
        SurveyForm surveyForm = (SurveyForm)form;
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(surveyForm.getSessionMapID());
        FormFile file = StringUtils.equals((String)"OFFLINE", (String)type) ? surveyForm.getOfflineFile() : surveyForm.getOnlineFile();
        if (file == null || StringUtils.isBlank((String)file.getFileName())) {
            return mapping.findForward("success");
        }
        ActionMessages errors = new ActionMessages();
        FileValidatorUtil.validateFileSize((FormFile)file, (boolean)true, (ActionMessages)errors);
        if (!errors.isEmpty()) {
            this.saveErrors(request, errors);
            return mapping.findForward("success");
        }
        ISurveyService service = this.getSurveyService();
        SurveyAttachment att = service.uploadInstructionFile(file, type);
        List attachmentList = this.getAttachmentList(sessionMap);
        List deleteAttachmentList = this.getDeletedAttachmentList(sessionMap);
        Iterator iter = attachmentList.iterator();
        while (iter.hasNext()) {
            SurveyAttachment existAtt = (SurveyAttachment)iter.next();
            if (!StringUtils.equals((String)existAtt.getFileName(), (String)att.getFileName()) || !StringUtils.equals((String)existAtt.getFileType(), (String)att.getFileType())) continue;
            deleteAttachmentList.add(existAtt);
            iter.remove();
            break;
        }
        attachmentList.add(att);
        return mapping.findForward("success");
    }

    public ActionForward deleteOfflineFile(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return this.deleteFile(mapping, request, response, form, "OFFLINE");
    }

    public ActionForward deleteOnlineFile(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return this.deleteFile(mapping, request, response, form, "ONLINE");
    }

    private ActionForward deleteFile(ActionMapping mapping, HttpServletRequest request, HttpServletResponse response, ActionForm form, String type) {
        Long versionID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"fileVersionId"));
        Long uuID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"fileUuid"));
        String sessionMapID = WebUtil.readStrParam((HttpServletRequest)request, (String)"sessionMapID");
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(sessionMapID);
        List attachmentList = this.getAttachmentList(sessionMap);
        List deleteAttachmentList = this.getDeletedAttachmentList(sessionMap);
        Iterator iter = attachmentList.iterator();
        while (iter.hasNext()) {
            SurveyAttachment existAtt = (SurveyAttachment)iter.next();
            if (!existAtt.getFileUuid().equals(uuID) || !existAtt.getFileVersionId().equals(versionID)) continue;
            deleteAttachmentList.add(existAtt);
            iter.remove();
        }
        request.setAttribute("fileTypeFlag", (Object)type);
        request.setAttribute("sessionMapID", (Object)sessionMapID);
        return mapping.findForward("success");
    }

    private ISurveyService getSurveyService() {
        WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
        return (ISurveyService)wac.getBean("lasurvSurveyService");
    }

    private List getAttachmentList(SessionMap sessionMap) {
        return this.getListFromSession(sessionMap, "instructionAttachmentList");
    }

    private List getDeletedAttachmentList(SessionMap sessionMap) {
        return this.getListFromSession(sessionMap, "deletedAttachmmentList");
    }

    private SortedSet<SurveyQuestion> getSurveyItemList(SessionMap sessionMap) {
        TreeSet<SurveyQuestion> list = (TreeSet<SurveyQuestion>)sessionMap.get((Object)"questionList");
        if (list == null) {
            list = new TreeSet<SurveyQuestion>(new QuestionsComparator());
            sessionMap.put((Object)"questionList", list);
        }
        return list;
    }

    private List getDeletedSurveyItemList(SessionMap sessionMap) {
        return this.getListFromSession(sessionMap, "deletedQuestionList");
    }

    private List getListFromSession(SessionMap sessionMap, String name) {
        ArrayList list = (ArrayList)sessionMap.get((Object)name);
        if (list == null) {
            list = new ArrayList();
            sessionMap.put((Object)name, list);
        }
        return list;
    }

    private List<String> getInstructionsFromRequest(HttpServletRequest request) {
        String list = request.getParameter("instructionList");
        ArrayList<String> instructionList = new ArrayList<String>();
        if (list == null) {
            return instructionList;
        }
        String[] params = list.split("&");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        for (String item : params) {
            String[] pair = item.split("=");
            if (pair == null || pair.length != 2) continue;
            try {
                paramMap.put(pair[0], URLDecoder.decode(pair[1], "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                log.error((Object)("Error occurs when decode instruction string:" + e.toString()));
            }
        }
        int count = NumberUtils.stringToInt((String)((String)paramMap.get(INSTRUCTION_ITEM_COUNT)));
        for (int idx = 0; idx < count; ++idx) {
            String item = (String)paramMap.get(INSTRUCTION_ITEM_DESC_PREFIX + idx);
            if (item == null) continue;
            instructionList.add(item);
        }
        return instructionList;
    }

    private void populateItemToForm(int itemIdx, SurveyQuestion item, QuestionForm form, HttpServletRequest request) {
        if (itemIdx >= 0) {
            form.setItemIndex(new Integer(itemIdx).toString());
        }
        form.setQuestion(item);
        Set<SurveyOption> instructionList = item.getOptions();
        ArrayList<String> instructions = new ArrayList<String>();
        for (SurveyOption in : instructionList) {
            instructions.add(in.getDescription());
        }
        request.setAttribute("instructionList", instructions);
    }

    private void extractFormToSurveyItem(HttpServletRequest request, List<String> instructionList, QuestionForm itemForm) throws Exception {
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(itemForm.getSessionMapID());
        SortedSet<SurveyQuestion> surveyList = this.getSurveyItemList(sessionMap);
        int itemIdx = NumberUtils.stringToInt((String)itemForm.getItemIndex(), (int)-1);
        SurveyQuestion item = itemForm.getQuestion();
        if (itemIdx == -1) {
            item.setCreateDate(new Timestamp(new Date().getTime()));
            int maxSeq = 1;
            if (surveyList != null && surveyList.size() > 0) {
                SurveyQuestion last = surveyList.last();
                maxSeq = last.getSequenceId() + 1;
            }
            item.setSequenceId(maxSeq);
            surveyList.add(item);
        } else {
            ArrayList<SurveyQuestion> rList = new ArrayList<SurveyQuestion>(surveyList);
            item = (SurveyQuestion)rList.get(itemIdx);
            item.setDescription(itemForm.getQuestion().getDescription());
            item.setOptional(itemForm.getQuestion().isOptional());
            item.setAppendText(itemForm.getQuestion().isAppendText());
            item.setAllowMultipleAnswer(itemForm.getQuestion().isAllowMultipleAnswer());
        }
        AuthoringAction.retriveQuestionForDisplay(item);
        short type = this.getQuestionType(itemForm);
        item.setType(type);
        LinkedHashSet<SurveyOption> instructions = new LinkedHashSet<SurveyOption>();
        int idx = 0;
        for (String ins : instructionList) {
            SurveyOption rii = new SurveyOption();
            rii.setDescription(ins);
            rii.setSequenceId(idx++);
            instructions.add(rii);
        }
        item.setOptions(instructions);
    }

    private short getQuestionType(QuestionForm itemForm) {
        int type = itemForm.getItemType() == 3 ? 3 : (itemForm.getQuestion().isAllowMultipleAnswer() ? 2 : 1);
        return (short)type;
    }

    private void retriveQuestionListForDisplay(List<SurveyQuestion> list) {
        for (SurveyQuestion item : list) {
            AuthoringAction.retriveQuestionForDisplay(item);
        }
    }

    public static void retriveQuestionForDisplay(SurveyQuestion item) {
        String desc = item.getDescription();
        desc = desc.replaceAll("<(.|\n)*?>", "");
        item.setShortTitle(StringUtils.abbreviate((String)desc, (int)60));
    }

    private ActionErrors validateSurveyItem(QuestionForm itemForm, List<String> instructionList) {
        short type;
        ActionErrors errors = new ActionErrors();
        if (StringUtils.isBlank((String)itemForm.getQuestion().getDescription())) {
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("error.survey.item.question.blank"));
        }
        if ((type = this.getQuestionType(itemForm)) != 3 && (instructionList == null || instructionList.size() < 2)) {
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("error.survey.item.question.less.option"));
        }
        return errors;
    }

    private ToolAccessMode getAccessMode(HttpServletRequest request) {
        String modeStr = request.getParameter("mode");
        ToolAccessMode mode = StringUtils.equalsIgnoreCase((String)modeStr, (String)ToolAccessMode.TEACHER.toString()) ? ToolAccessMode.TEACHER : ToolAccessMode.AUTHOR;
        return mode;
    }

    private ActionMessages validate(SurveyForm surveyForm, ActionMapping mapping, HttpServletRequest request) {
        ActionMessages errors = new ActionMessages();
        String modeStr = request.getParameter("mode");
        if (StringUtils.equals((String)modeStr, (String)ToolAccessMode.TEACHER.toString())) {
            return errors;
        }
        return errors;
    }

    private ActionForward newInstruction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        int count = NumberUtils.stringToInt((String)request.getParameter(INSTRUCTION_ITEM_COUNT), (int)0);
        ArrayList<String> instructionList = new ArrayList<String>(++count);
        for (int idx = 0; idx < count; ++idx) {
            String item = request.getParameter(INSTRUCTION_ITEM_DESC_PREFIX + idx);
            if (item == null) {
                instructionList.add("");
                continue;
            }
            instructionList.add(item);
        }
        request.setAttribute("instructionList", instructionList);
        return mapping.findForward("success");
    }

    private ActionForward removeInstruction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        int count = NumberUtils.stringToInt((String)request.getParameter(INSTRUCTION_ITEM_COUNT), (int)0);
        int removeIdx = NumberUtils.stringToInt((String)request.getParameter("removeIdx"), (int)-1);
        ArrayList<String> instructionList = new ArrayList<String>(count - 1);
        for (int idx = 0; idx < count; ++idx) {
            String item = request.getParameter(INSTRUCTION_ITEM_DESC_PREFIX + idx);
            if (idx == removeIdx) continue;
            if (item == null) {
                instructionList.add("");
                continue;
            }
            instructionList.add(item);
        }
        request.setAttribute("instructionList", instructionList);
        return mapping.findForward("success");
    }
}

