/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.survey.web.action;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.DefaultPieDataset;
import org.lamsfoundation.lams.tool.survey.dto.AnswerDTO;
import org.lamsfoundation.lams.tool.survey.model.SurveyOption;
import org.lamsfoundation.lams.tool.survey.service.ISurveyService;
import org.lamsfoundation.lams.util.ChartUtil;
import org.lamsfoundation.lams.util.WebUtil;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class ChartAction
extends Action {
    static Logger logger = Logger.getLogger(ChartAction.class);
    private MessageResources resource;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.resource = this.getResources(request);
        ServletOutputStream out = response.getOutputStream();
        String type = WebUtil.readStrParam((HttpServletRequest)request, (String)"chartType");
        Long sessionId = WebUtil.readLongParam((HttpServletRequest)request, (String)"toolSessionID");
        Long questionUid = WebUtil.readLongParam((HttpServletRequest)request, (String)"questionUid");
        ISurveyService service = this.getSurveyService();
        AnswerDTO answer = service.getQuestionResponse(sessionId, questionUid);
        if (answer.getType() == 3) {
            logger.error((Object)"Error question type : Text entry can not generate chart.");
            response.getWriter().print(this.resource.getMessage("error.chart.gen"));
            return null;
        }
        try {
            if (type.equals("pie")) {
                DefaultPieDataset data = this.createPieDataset(answer);
                ChartUtil.outputPieChart((HttpServletResponse)response, (OutputStream)out, (String)this.resource.getMessage("piechart.title", (Object)answer.getSequenceId()), (DefaultPieDataset)data);
            } else if (type.equals("bar")) {
                DefaultCategoryDataset data = this.createBarDataset(answer);
                ChartUtil.outputBarChart((HttpServletResponse)response, (OutputStream)out, (String)this.resource.getMessage("barchart.title", (Object)answer.getSequenceId()), (DefaultCategoryDataset)data, (String)this.resource.getMessage("barchart.category.axis.label"), (String)this.resource.getMessage("barchart.value.axis.label"));
            }
        }
        catch (IOException e) {
            logger.error((Object)("Error creating chart for sessionId " + sessionId), (Throwable)e);
            response.getWriter().print(this.resource.getMessage("error.chart.gen"));
        }
        return null;
    }

    public DefaultPieDataset createPieDataset(AnswerDTO answer) {
        DefaultPieDataset data = new DefaultPieDataset();
        Set<SurveyOption> options = answer.getOptions();
        int optIdx = 1;
        for (SurveyOption option : options) {
            data.setValue((Comparable)((Object)("a" + optIdx)), (Number)option.getResponse());
            ++optIdx;
        }
        if (answer.isAppendText()) {
            data.setValue((Comparable)((Object)this.resource.getMessage("label.open.response")), (Number)answer.getOpenResponse());
        }
        return data;
    }

    public DefaultCategoryDataset createBarDataset(AnswerDTO answer) {
        DefaultCategoryDataset data = new DefaultCategoryDataset();
        Set<SurveyOption> options = answer.getOptions();
        int optIdx = 1;
        for (SurveyOption option : options) {
            data.setValue((Number)option.getResponse(), (Comparable)((Object)("a" + optIdx)), (Comparable)((Object)("a" + optIdx)));
            ++optIdx;
        }
        if (answer.isAppendText()) {
            data.setValue((Number)answer.getOpenResponse(), (Comparable)((Object)this.resource.getMessage("label.open.response")), (Comparable)((Object)this.resource.getMessage("label.open.response")));
        }
        return data;
    }

    private ISurveyService getSurveyService() {
        WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
        return (ISurveyService)wac.getBean("lasurvSurveyService");
    }
}

