/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.survey.web.action;

import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.lamsfoundation.lams.notebook.model.NotebookEntry;
import org.lamsfoundation.lams.notebook.service.CoreNotebookConstants;
import org.lamsfoundation.lams.tool.ToolAccessMode;
import org.lamsfoundation.lams.tool.survey.SurveyConstants;
import org.lamsfoundation.lams.tool.survey.dto.AnswerDTO;
import org.lamsfoundation.lams.tool.survey.model.Survey;
import org.lamsfoundation.lams.tool.survey.model.SurveyAnswer;
import org.lamsfoundation.lams.tool.survey.model.SurveySession;
import org.lamsfoundation.lams.tool.survey.model.SurveyUser;
import org.lamsfoundation.lams.tool.survey.service.ISurveyService;
import org.lamsfoundation.lams.tool.survey.service.SurveyApplicationException;
import org.lamsfoundation.lams.tool.survey.util.IntegerComparator;
import org.lamsfoundation.lams.tool.survey.util.SurveyWebUtils;
import org.lamsfoundation.lams.tool.survey.web.form.AnswerForm;
import org.lamsfoundation.lams.tool.survey.web.form.ReflectionForm;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.lamsfoundation.lams.web.util.SessionMap;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LearningAction
extends Action {
    private static Logger log = Logger.getLogger(LearningAction.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String param = mapping.getParameter();
        if (param.equals("start")) {
            return this.start(mapping, form, request, response);
        }
        if (param.equals("previousQuestion")) {
            return this.previousQuestion(mapping, form, request, response);
        }
        if (param.equals("nextQuestion")) {
            return this.nextQuestion(mapping, form, request, response);
        }
        if (param.equals("doSurvey")) {
            return this.doSurvey(mapping, form, request, response);
        }
        if (param.equals("retake")) {
            return this.retake(mapping, form, request, response);
        }
        if (param.equals("finish")) {
            return this.finish(mapping, form, request, response);
        }
        if (param.equals("newReflection")) {
            return this.newReflection(mapping, form, request, response);
        }
        if (param.equals("submitReflection")) {
            return this.submitReflection(mapping, form, request, response);
        }
        return mapping.findForward("error");
    }

    private ActionForward start(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        AnswerForm answerForm = (AnswerForm)form;
        SessionMap sessionMap = new SessionMap();
        request.getSession().setAttribute(sessionMap.getSessionID(), (Object)sessionMap);
        answerForm.setSessionMapID(sessionMap.getSessionID());
        ToolAccessMode mode = WebUtil.readToolAccessModeParam((HttpServletRequest)request, (String)"mode", (boolean)true);
        Long sessionId = new Long(request.getParameter("toolSessionID"));
        request.setAttribute("sessionMapID", (Object)sessionMap.getSessionID());
        ISurveyService service = this.getSurveyService();
        SurveyUser surveyUser = null;
        surveyUser = mode != null && mode.isTeacher() ? this.getSpecifiedUser(service, sessionId, WebUtil.readIntParam((HttpServletRequest)request, (String)"userID", (boolean)false)) : this.getCurrentUser(service, sessionId);
        List<AnswerDTO> answers = service.getQuestionAnswers(sessionId, surveyUser.getUid());
        Survey survey = service.getSurveyBySessionId(sessionId);
        boolean lock = survey.getLockWhenFinished() && surveyUser.isSessionFinished();
        String entryText = new String();
        NotebookEntry notebookEntry = service.getEntry(sessionId, CoreNotebookConstants.NOTEBOOK_TOOL, "lasurv11", surveyUser.getUserId().intValue());
        if (notebookEntry != null) {
            entryText = notebookEntry.getEntry();
        }
        sessionMap.put((Object)"title", (Object)survey.getTitle());
        sessionMap.put((Object)"instructions", (Object)survey.getInstructions());
        sessionMap.put((Object)"finishedLock", (Object)lock);
        sessionMap.put((Object)"lockOnFinish", (Object)survey.getLockWhenFinished());
        sessionMap.put((Object)"showOnOnePage", (Object)survey.isShowOnePage());
        sessionMap.put((Object)"userFinished", (Object)surveyUser.isSessionFinished());
        sessionMap.put((Object)"toolSessionID", (Object)sessionId);
        sessionMap.put((Object)"mode", (Object)mode);
        sessionMap.put((Object)"reflectOn", (Object)survey.isReflectOnActivity());
        sessionMap.put((Object)"reflectInstructions", (Object)survey.getReflectInstructions());
        sessionMap.put((Object)"reflectEntry", (Object)entryText);
        if (survey.isDefineLater()) {
            return mapping.findForward("definelater");
        }
        survey.setContentInUse(true);
        survey.setDefineLater(false);
        service.saveOrUpdateSurvey(survey);
        if (survey.getRunOffline()) {
            sessionMap.put((Object)"runOffline", (Object)true);
            return mapping.findForward("runOffline");
        }
        sessionMap.put((Object)"runOffline", (Object)false);
        SortedMap<Integer, AnswerDTO> surveyItemList = this.getQuestionList(sessionMap);
        surveyItemList.clear();
        if (answers != null) {
            for (AnswerDTO answer : answers) {
                surveyItemList.put(answer.getSequenceId(), answer);
            }
        }
        if (survey.isShowOnePage()) {
            answerForm.setQuestionSeqID(null);
        } else if (surveyItemList.size() > 0) {
            answerForm.setQuestionSeqID(surveyItemList.firstKey());
        }
        sessionMap.put((Object)"totalQuestions", (Object)surveyItemList.size());
        answerForm.setCurrentIdx(1);
        if (surveyItemList.size() < 2) {
            answerForm.setPosition(SurveyConstants.POSITION_ONLY_ONE);
        } else {
            answerForm.setPosition(SurveyConstants.POSITION_FIRST);
        }
        if (lock) {
            return mapping.findForward("result");
        }
        return mapping.findForward("success");
    }

    private ActionForward nextQuestion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        AnswerForm answerForm = (AnswerForm)form;
        Integer questionSeqID = answerForm.getQuestionSeqID();
        String sessionMapID = answerForm.getSessionMapID();
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(sessionMapID);
        SortedMap<Integer, AnswerDTO> surveyItemMap = this.getQuestionList(sessionMap);
        ActionErrors errors = this.getAnswer(request, (AnswerDTO)surveyItemMap.get(questionSeqID));
        if (!errors.isEmpty()) {
            return mapping.getInputForward();
        }
        boolean next = false;
        for (Map.Entry<Integer, AnswerDTO> entry : surveyItemMap.entrySet()) {
            if (entry.getKey().equals(questionSeqID)) {
                next = true;
                questionSeqID = entry.getKey();
                continue;
            }
            if (!next) continue;
            questionSeqID = entry.getKey();
            break;
        }
        int currIdx = new ArrayList<Integer>(surveyItemMap.keySet()).indexOf(questionSeqID) + 1;
        answerForm.setCurrentIdx(currIdx);
        if (questionSeqID.equals(surveyItemMap.lastKey())) {
            answerForm.setPosition(SurveyConstants.POSITION_LAST);
        } else {
            answerForm.setPosition(SurveyConstants.POSITION_INSIDE);
        }
        answerForm.setQuestionSeqID(questionSeqID);
        return mapping.findForward("success");
    }

    private ActionForward previousQuestion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        AnswerForm answerForm = (AnswerForm)form;
        Integer questionSeqID = answerForm.getQuestionSeqID();
        String sessionMapID = answerForm.getSessionMapID();
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(sessionMapID);
        SortedMap<Integer, AnswerDTO> surveyItemMap = this.getQuestionList(sessionMap);
        ActionErrors errors = this.getAnswer(request, (AnswerDTO)surveyItemMap.get(questionSeqID));
        if (!errors.isEmpty()) {
            return mapping.getInputForward();
        }
        SortedMap<Integer, AnswerDTO> subMap = surveyItemMap.headMap(questionSeqID);
        questionSeqID = subMap.isEmpty() ? surveyItemMap.firstKey() : subMap.lastKey();
        int currIdx = new ArrayList<Integer>(surveyItemMap.keySet()).indexOf(questionSeqID) + 1;
        answerForm.setCurrentIdx(currIdx);
        if (questionSeqID.equals(surveyItemMap.firstKey())) {
            answerForm.setPosition(SurveyConstants.POSITION_FIRST);
        } else {
            answerForm.setPosition(SurveyConstants.POSITION_INSIDE);
        }
        answerForm.setQuestionSeqID(questionSeqID);
        return mapping.findForward("success");
    }

    private ActionForward retake(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        AnswerForm answerForm = (AnswerForm)form;
        Integer questionSeqID = answerForm.getQuestionSeqID();
        answerForm.setPosition(SurveyConstants.POSITION_ONLY_ONE);
        String sessionMapID = answerForm.getSessionMapID();
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(sessionMapID);
        SortedMap<Integer, AnswerDTO> surveyItemMap = this.getQuestionList(sessionMap);
        int currIdx = new ArrayList<Integer>(surveyItemMap.keySet()).indexOf(questionSeqID) + 1;
        answerForm.setCurrentIdx(currIdx);
        return mapping.findForward("success");
    }

    private ActionForward doSurvey(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        AnswerForm answerForm = (AnswerForm)form;
        Integer questionSeqID = answerForm.getQuestionSeqID();
        String sessionMapID = answerForm.getSessionMapID();
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(sessionMapID);
        SortedMap<Integer, AnswerDTO> surveyItemMap = this.getQuestionList(sessionMap);
        Collection<AnswerDTO> surveyItemList = surveyItemMap.values();
        ActionErrors errors = questionSeqID == null || questionSeqID.equals(0) ? this.getAnswers(request) : this.getAnswer(request, (AnswerDTO)surveyItemMap.get(questionSeqID));
        if (!errors.isEmpty()) {
            return mapping.getInputForward();
        }
        ArrayList<SurveyAnswer> answerList = new ArrayList<SurveyAnswer>();
        for (AnswerDTO question : surveyItemList) {
            if (question.getAnswer() == null) continue;
            answerList.add(question.getAnswer());
        }
        ISurveyService service = this.getSurveyService();
        service.updateAnswerList(answerList);
        request.setAttribute("sessionMapID", (Object)sessionMapID);
        return mapping.findForward("success");
    }

    private ActionForward finish(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String sessionMapID = request.getParameter("sessionMapID");
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(sessionMapID);
        Long sessionId = (Long)sessionMap.get((Object)"toolSessionID");
        ISurveyService service = this.getSurveyService();
        String nextActivityUrl = null;
        try {
            HttpSession ss = SessionManager.getSession();
            UserDTO user = (UserDTO)ss.getAttribute("user");
            Long userID = new Long(user.getUserID().longValue());
            nextActivityUrl = service.finishToolSession(sessionId, userID);
            request.setAttribute("nextActivityUrl", (Object)nextActivityUrl);
        }
        catch (SurveyApplicationException e) {
            log.error((Object)("Failed get next activity url:" + e.getMessage()));
        }
        return mapping.findForward("success");
    }

    private ActionForward newReflection(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String sessionMapID = WebUtil.readStrParam((HttpServletRequest)request, (String)"sessionMapID");
        ReflectionForm refForm = (ReflectionForm)form;
        HttpSession ss = SessionManager.getSession();
        UserDTO user = (UserDTO)ss.getAttribute("user");
        refForm.setUserID(user.getUserID());
        refForm.setSessionMapID(sessionMapID);
        ISurveyService submitFilesService = this.getSurveyService();
        SessionMap map = (SessionMap)request.getSession().getAttribute(sessionMapID);
        Long toolSessionID = (Long)map.get((Object)"toolSessionID");
        NotebookEntry entry = submitFilesService.getEntry(toolSessionID, CoreNotebookConstants.NOTEBOOK_TOOL, "lasurv11", user.getUserID());
        if (entry != null) {
            refForm.setEntryText(entry.getEntry());
        }
        return mapping.findForward("success");
    }

    private ActionForward submitReflection(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ReflectionForm refForm = (ReflectionForm)form;
        Integer userId = refForm.getUserID();
        String sessionMapID = WebUtil.readStrParam((HttpServletRequest)request, (String)"sessionMapID");
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(sessionMapID);
        Long sessionId = (Long)sessionMap.get((Object)"toolSessionID");
        ISurveyService service = this.getSurveyService();
        NotebookEntry entry = service.getEntry(sessionId, CoreNotebookConstants.NOTEBOOK_TOOL, "lasurv11", userId);
        if (entry == null) {
            service.createNotebookEntry(sessionId, CoreNotebookConstants.NOTEBOOK_TOOL, "lasurv11", userId, refForm.getEntryText());
        } else {
            entry.setEntry(refForm.getEntryText());
            entry.setLastModified(new Date());
            service.updateEntry(entry);
        }
        return this.finish(mapping, form, request, response);
    }

    private ActionErrors getAnswer(HttpServletRequest request, AnswerDTO answerDto) {
        ActionErrors errors = new ActionErrors();
        String sessionMapID = request.getParameter("sessionMapID");
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(sessionMapID);
        Long sessionID = (Long)sessionMap.get((Object)"toolSessionID");
        SurveyAnswer answer = this.getAnswerFromPage(request, answerDto, sessionID);
        answerDto.setAnswer(answer);
        this.validateAnswers(request, answerDto, errors, answer);
        if (!errors.isEmpty()) {
            this.addErrors(request, (ActionMessages)errors);
        }
        return errors;
    }

    private ActionErrors getAnswers(HttpServletRequest request) {
        ActionErrors errors = new ActionErrors();
        String sessionMapID = request.getParameter("sessionMapID");
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(sessionMapID);
        Long sessionID = (Long)sessionMap.get((Object)"toolSessionID");
        Collection<AnswerDTO> answerDtoList = this.getQuestionList(sessionMap).values();
        for (AnswerDTO answerDto : answerDtoList) {
            SurveyAnswer answer = this.getAnswerFromPage(request, answerDto, sessionID);
            answerDto.setAnswer(answer);
            this.validateAnswers(request, answerDto, errors, answer);
        }
        if (!errors.isEmpty()) {
            this.addErrors(request, (ActionMessages)errors);
        }
        return errors;
    }

    private void validateAnswers(HttpServletRequest request, AnswerDTO question, ActionErrors errors, SurveyAnswer answer) {
        if (!question.isOptional() && answer == null) {
            errors.add("questionError" + question.getUid(), new ActionMessage("error.mandatory.question"));
        }
        if (question.getType() == 1 && question.isAppendText() && answer != null && !StringUtils.isBlank((String)answer.getAnswerChoices()) && !StringUtils.isBlank((String)answer.getAnswerText())) {
            errors.add("questionError" + question.getUid(), new ActionMessage("error.single.choice.over"));
        }
    }

    private SurveyAnswer getAnswerFromPage(HttpServletRequest request, AnswerDTO question, Long sessionID) {
        String[] choiceList = request.getParameterValues("optionChoice" + question.getUid());
        String textEntry = request.getParameter("optionText" + question.getUid());
        if (choiceList == null && StringUtils.isBlank((String)textEntry)) {
            return null;
        }
        SurveyAnswer answer = question.getAnswer();
        if (answer == null) {
            answer = new SurveyAnswer();
        }
        answer.setAnswerChoices(SurveyWebUtils.getChoicesStr(choiceList));
        answer.setChoices(choiceList);
        answer.setAnswerText(textEntry);
        ISurveyService service = this.getSurveyService();
        answer.setUser(this.getCurrentUser(service, sessionID));
        answer.setUpdateDate(new Timestamp(new Date().getTime()));
        answer.setSurveyQuestion(question);
        return answer;
    }

    private ISurveyService getSurveyService() {
        WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
        return (ISurveyService)wac.getBean("lasurvSurveyService");
    }

    private SortedMap<Integer, AnswerDTO> getQuestionList(SessionMap sessionMap) {
        TreeMap list = (TreeMap)sessionMap.get((Object)"questionList");
        if (list == null) {
            list = new TreeMap(new IntegerComparator());
            sessionMap.put((Object)"questionList", list);
        }
        return list;
    }

    private SurveyUser getCurrentUser(ISurveyService service, Long sessionId) {
        HttpSession ss = SessionManager.getSession();
        UserDTO user = (UserDTO)ss.getAttribute("user");
        SurveyUser surveyUser = service.getUserByIDAndSession(new Long(user.getUserID().intValue()), sessionId);
        if (surveyUser == null) {
            SurveySession session = service.getSurveySessionBySessionId(sessionId);
            surveyUser = new SurveyUser(user, session);
            service.createUser(surveyUser);
        }
        return surveyUser;
    }

    private SurveyUser getSpecifiedUser(ISurveyService service, Long sessionId, Integer userId) {
        return service.getUserByIDAndSession(new Long(userId.intValue()), sessionId);
    }
}

