/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.survey.web.action;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.lamsfoundation.lams.notebook.model.NotebookEntry;
import org.lamsfoundation.lams.notebook.service.CoreNotebookConstants;
import org.lamsfoundation.lams.tool.survey.dto.AnswerDTO;
import org.lamsfoundation.lams.tool.survey.dto.ReflectDTO;
import org.lamsfoundation.lams.tool.survey.model.Survey;
import org.lamsfoundation.lams.tool.survey.model.SurveyOption;
import org.lamsfoundation.lams.tool.survey.model.SurveyQuestion;
import org.lamsfoundation.lams.tool.survey.model.SurveySession;
import org.lamsfoundation.lams.tool.survey.model.SurveyUser;
import org.lamsfoundation.lams.tool.survey.service.ISurveyService;
import org.lamsfoundation.lams.tool.survey.util.SurveyUserComparator;
import org.lamsfoundation.lams.tool.survey.util.SurveyWebUtils;
import org.lamsfoundation.lams.util.MessageService;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.util.SessionMap;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class MonitoringAction
extends Action {
    private static final String MSG_LABEL_QUESTION = "label.question";
    private static final String MSG_LABEL_OPEN_RESPONSE = "label.open.response";
    private static final String MSG_LABEL_SESSION_NAME = "label.session.name";
    private static final String MSG_LABEL_POSSIBLE_ANSWERS = "message.possible.answers";
    private static final String MSG_LABEL_LEARNER = "label.learner";
    public static Logger log = Logger.getLogger(MonitoringAction.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String param = mapping.getParameter();
        if (param.equals("summary")) {
            return this.summary(mapping, form, request, response);
        }
        if (param.equals("viewChartReport")) {
            return this.viewChartReport(mapping, form, request, response);
        }
        if (param.equals("listAnswers")) {
            return this.listAnswers(mapping, form, request, response);
        }
        if (param.equals("viewReflection")) {
            return this.viewReflection(mapping, form, request, response);
        }
        if (param.equals("exportSurvey")) {
            return this.exportSurvey(mapping, form, request, response);
        }
        return mapping.findForward("error");
    }

    private ActionForward summary(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        SessionMap sessionMap = new SessionMap();
        request.getSession().setAttribute(sessionMap.getSessionID(), (Object)sessionMap);
        request.setAttribute("sessionMapID", (Object)sessionMap.getSessionID());
        sessionMap.put((Object)"contentFolderID", (Object)WebUtil.readStrParam((HttpServletRequest)request, (String)"contentFolderID"));
        request.setAttribute("initialTabId", (Object)WebUtil.readLongParam((HttpServletRequest)request, (String)"currentTab", (boolean)true));
        Long contentId = WebUtil.readLongParam((HttpServletRequest)request, (String)"toolContentID");
        ISurveyService service = this.getSurveyService();
        SortedMap<SurveySession, List<AnswerDTO>> summary = service.getSummary(contentId);
        Survey survey = service.getSurveyByContentId(contentId);
        survey.toDTO();
        SortedMap<SurveySession, Integer> statis = service.getStatistic(contentId);
        Map<Long, Set<ReflectDTO>> relectList = service.getReflectList(contentId, false);
        sessionMap.put((Object)"summaryList", summary);
        sessionMap.put((Object)"statistic", statis);
        sessionMap.put((Object)"isPageEditable", (Object)new Boolean(SurveyWebUtils.isSurveyEditable(survey)));
        sessionMap.put((Object)"survey", (Object)survey);
        sessionMap.put((Object)"toolContentID", (Object)contentId);
        sessionMap.put((Object)"reflectList", relectList);
        return mapping.findForward("success");
    }

    private ActionForward viewChartReport(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Long sessionId = WebUtil.readLongParam((HttpServletRequest)request, (String)"toolSessionID");
        String type = WebUtil.readStrParam((HttpServletRequest)request, (String)"chartType");
        Long questionUid = WebUtil.readLongParam((HttpServletRequest)request, (String)"questionUid");
        ISurveyService service = this.getSurveyService();
        SurveyQuestion question = service.getQuestion(questionUid);
        request.setAttribute("toolSessionID", (Object)sessionId);
        request.setAttribute("chartType", (Object)type);
        request.setAttribute("question", (Object)question);
        return mapping.findForward("success");
    }

    private ActionForward listAnswers(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Long sessionId = WebUtil.readLongParam((HttpServletRequest)request, (String)"toolSessionID");
        Long questionUid = WebUtil.readLongParam((HttpServletRequest)request, (String)"questionUid");
        ISurveyService service = this.getSurveyService();
        TreeMap<SurveyUser, AnswerDTO> userAnswerMap = new TreeMap<SurveyUser, AnswerDTO>(new SurveyUserComparator());
        List<SurveyUser> users = service.getSessionUsers(sessionId);
        block0: for (SurveyUser user : users) {
            List<AnswerDTO> questionAnswers = service.getQuestionAnswers(sessionId, user.getUid());
            for (AnswerDTO questionAnswer : questionAnswers) {
                if (!questionUid.equals(questionAnswer.getUid())) continue;
                userAnswerMap.put(user, questionAnswer);
                continue block0;
            }
        }
        request.setAttribute("answerList", userAnswerMap);
        return mapping.findForward("success");
    }

    private ActionForward viewReflection(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Long uid = WebUtil.readLongParam((HttpServletRequest)request, (String)"userUid");
        Long sessionID = WebUtil.readLongParam((HttpServletRequest)request, (String)"toolSessionID");
        ISurveyService service = this.getSurveyService();
        SurveyUser user = service.getUser(uid);
        NotebookEntry notebookEntry = service.getEntry(sessionID, CoreNotebookConstants.NOTEBOOK_TOOL, "lasurv11", user.getUserId().intValue());
        SurveySession session = service.getSurveySessionBySessionId(sessionID);
        ReflectDTO refDTO = new ReflectDTO(user);
        if (notebookEntry == null) {
            refDTO.setFinishReflection(false);
            refDTO.setReflect(null);
        } else {
            refDTO.setFinishReflection(true);
            refDTO.setReflect(notebookEntry.getEntry());
        }
        refDTO.setReflectInstrctions(session.getSurvey().getReflectInstructions());
        request.setAttribute("userDTO", (Object)refDTO);
        return mapping.findForward("success");
    }

    private ActionForward exportSurvey(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Long toolSessionID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"toolSessionID"));
        ISurveyService service = this.getSurveyService();
        SortedMap<SurveySession, SortedMap<SurveyQuestion, List<AnswerDTO>>> groupList = service.exportBySessionId(toolSessionID);
        String errors = null;
        MessageService resource = this.getMessageService();
        try {
            HSSFWorkbook wb = new HSSFWorkbook();
            HSSFSheet sheet = wb.createSheet("Survey");
            sheet.setColumnWidth((short)0, (short)5000);
            int idx = 0;
            Set<Map.Entry<SurveySession, SortedMap<SurveyQuestion, List<AnswerDTO>>>> entries = groupList.entrySet();
            for (Map.Entry<SurveySession, SortedMap<SurveyQuestion, List<AnswerDTO>>> entry : entries) {
                SurveySession session = entry.getKey();
                SortedMap<SurveyQuestion, List<AnswerDTO>> map = entry.getValue();
                Survey survey = session.getSurvey();
                HSSFRow row = sheet.createRow(idx++);
                HSSFCell cell = row.createCell((short)0);
                cell.setEncoding((short)1);
                cell.setCellValue(survey.getTitle());
                row = sheet.createRow(idx++);
                cell = row.createCell((short)0);
                cell.setEncoding((short)1);
                cell.setCellValue(survey.getInstructions());
                row = sheet.createRow(idx++);
                cell = row.createCell((short)0);
                cell.setCellValue("");
                row = sheet.createRow(idx++);
                cell = row.createCell((short)0);
                cell.setCellValue("");
                row = sheet.createRow(idx++);
                cell = row.createCell((short)0);
                cell.setEncoding((short)1);
                cell.setCellValue(resource.getMessage(MSG_LABEL_SESSION_NAME));
                cell = row.createCell((short)1);
                cell.setEncoding((short)1);
                cell.setCellValue(session.getSessionName());
                Set<Map.Entry<SurveyQuestion, List<AnswerDTO>>> questionEntries = map.entrySet();
                int questionIdx = 0;
                for (Map.Entry<SurveyQuestion, List<AnswerDTO>> questionEntry : questionEntries) {
                    row = sheet.createRow(idx++);
                    cell = row.createCell((short)0);
                    cell.setCellValue("");
                    ++questionIdx;
                    SurveyQuestion question = questionEntry.getKey();
                    List<AnswerDTO> answers = questionEntry.getValue();
                    row = sheet.createRow(idx++);
                    cell = row.createCell((short)0);
                    cell.setEncoding((short)1);
                    cell.setCellValue(resource.getMessage(MSG_LABEL_QUESTION) + " " + questionIdx);
                    cell = row.createCell((short)1);
                    cell.setEncoding((short)1);
                    cell.setCellValue(question.getDescription());
                    Set<SurveyOption> options = question.getOptions();
                    row = sheet.createRow(idx++);
                    cell = row.createCell((short)0);
                    cell.setEncoding((short)1);
                    cell.setCellValue(resource.getMessage(MSG_LABEL_POSSIBLE_ANSWERS));
                    int optionIdx = 0;
                    for (SurveyOption option : options) {
                        row = sheet.createRow(idx++);
                        cell = row.createCell((short)0);
                        cell.setCellValue("a" + ++optionIdx);
                        cell = row.createCell((short)1);
                        cell.setEncoding((short)1);
                        cell.setCellValue(option.getDescription());
                    }
                    if (question.isAppendText() || question.getType() == 3) {
                        row = sheet.createRow(idx++);
                        cell = row.createCell((short)0);
                        cell.setCellValue("a" + ++optionIdx);
                        cell = row.createCell((short)1);
                        cell.setEncoding((short)1);
                        cell.setCellValue(resource.getMessage(MSG_LABEL_OPEN_RESPONSE));
                    }
                    row = sheet.createRow(idx++);
                    cell = row.createCell((short)0);
                    cell.setCellValue("");
                    int cellIdx = 0;
                    row = sheet.createRow(idx++);
                    cell = row.createCell((short)cellIdx);
                    cell.setEncoding((short)1);
                    cell.setCellValue(resource.getMessage(MSG_LABEL_LEARNER));
                    int optionsNum = options.size();
                    if (question.isAppendText() || question.getType() == 3) {
                        ++optionsNum;
                    }
                    for (cellIdx = 1; cellIdx <= optionsNum; ++cellIdx) {
                        cell = row.createCell((short)cellIdx);
                        cell.setCellValue("a" + cellIdx);
                    }
                    for (AnswerDTO answer : answers) {
                        row = sheet.createRow(idx++);
                        cellIdx = 0;
                        cell = row.createCell((short)cellIdx);
                        cell.setCellValue(answer.getReplier().getLoginName());
                        for (SurveyOption option : options) {
                            String[] choices;
                            cell = row.createCell((short)(++cellIdx));
                            if (answer.getAnswer() == null) break;
                            for (String choice : choices = answer.getAnswer().getChoices()) {
                                if (!StringUtils.equals((String)choice, (String)option.getUid().toString())) continue;
                                cell.setCellValue("X");
                            }
                        }
                        if (!question.isAppendText() && question.getType() != 3) continue;
                        cell = row.createCell((short)(++cellIdx));
                        cell.setEncoding((short)1);
                        if (answer.getAnswer() == null) continue;
                        cell.setCellValue(answer.getAnswer().getAnswerText());
                    }
                }
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            wb.write((OutputStream)bos);
            String fileName = "lams_survey_" + toolSessionID + ".xls";
            String mineType = "application/vnd.ms-excel";
            String header = "attachment; filename=\"" + fileName + "\";";
            response.setContentType(mineType);
            response.setHeader("Content-Disposition", header);
            byte[] data = bos.toByteArray();
            response.getOutputStream().write(data, 0, data.length);
            response.getOutputStream().flush();
        }
        catch (Exception e) {
            log.error((Object)e);
            errors = new ActionMessage("error.monitoring.export.excel", (Object)e.toString()).toString();
        }
        if (errors != null) {
            try {
                PrintWriter out = response.getWriter();
                out.write(errors);
                out.flush();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return null;
    }

    private ISurveyService getSurveyService() {
        WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
        return (ISurveyService)wac.getBean("lasurvSurveyService");
    }

    private MessageService getMessageService() {
        WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
        return (MessageService)wac.getBean("lasurvMessageService");
    }
}

