/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.survey.web.servlet;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeSet;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.notebook.model.NotebookEntry;
import org.lamsfoundation.lams.notebook.service.CoreNotebookConstants;
import org.lamsfoundation.lams.tool.ToolAccessMode;
import org.lamsfoundation.lams.tool.survey.dto.AnswerDTO;
import org.lamsfoundation.lams.tool.survey.dto.ReflectDTO;
import org.lamsfoundation.lams.tool.survey.model.Survey;
import org.lamsfoundation.lams.tool.survey.model.SurveyQuestion;
import org.lamsfoundation.lams.tool.survey.model.SurveySession;
import org.lamsfoundation.lams.tool.survey.model.SurveyUser;
import org.lamsfoundation.lams.tool.survey.service.ISurveyService;
import org.lamsfoundation.lams.tool.survey.service.SurveyApplicationException;
import org.lamsfoundation.lams.tool.survey.service.SurveyServiceProxy;
import org.lamsfoundation.lams.tool.survey.util.ReflectDTOComparator;
import org.lamsfoundation.lams.web.servlet.AbstractExportPortfolioServlet;
import org.lamsfoundation.lams.web.util.SessionMap;

public class ExportServlet
extends AbstractExportPortfolioServlet {
    private static final long serialVersionUID = -4529093489007108143L;
    private static Logger logger = Logger.getLogger(ExportServlet.class);
    private final String FILENAME = "survey_main.html";
    private ISurveyService service;

    public void init() throws ServletException {
        this.service = SurveyServiceProxy.getSurveyService(this.getServletContext());
        super.init();
    }

    public String doExport(HttpServletRequest request, HttpServletResponse response, String directoryName, Cookie[] cookies) {
        SessionMap sessionMap = new SessionMap();
        request.getSession().setAttribute(sessionMap.getSessionID(), (Object)sessionMap);
        try {
            if (StringUtils.equals((String)this.mode, (String)ToolAccessMode.LEARNER.toString())) {
                sessionMap.put((Object)"mode", (Object)ToolAccessMode.LEARNER);
                this.learner(request, response, directoryName, cookies, (HashMap)sessionMap);
            } else if (StringUtils.equals((String)this.mode, (String)ToolAccessMode.TEACHER.toString())) {
                sessionMap.put((Object)"mode", (Object)ToolAccessMode.TEACHER);
                this.teacher(request, response, directoryName, cookies, (HashMap)sessionMap);
            }
        }
        catch (SurveyApplicationException e) {
            logger.error((Object)"Cannot perform export for survey tool.");
        }
        String basePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath();
        this.writeResponseToFile(basePath + "/pages/export/exportportfolio.jsp?sessionMapID=" + sessionMap.getSessionID(), directoryName, "survey_main.html", cookies);
        return "survey_main.html";
    }

    protected String doOfflineExport(HttpServletRequest request, HttpServletResponse response, String directoryName, Cookie[] cookies) {
        if (this.toolContentID == null && this.toolSessionID == null) {
            logger.error((Object)"Tool content Id or and session Id are null. Unable to activity title");
        } else {
            Survey content = null;
            if (this.toolContentID != null) {
                content = this.service.getSurveyByContentId(this.toolContentID);
            } else {
                SurveySession session = this.service.getSurveySessionBySessionId(this.toolSessionID);
                if (session != null) {
                    content = session.getSurvey();
                }
            }
            if (content != null) {
                this.activityTitle = content.getTitle();
            }
        }
        return super.doOfflineExport(request, response, directoryName, cookies);
    }

    public void learner(HttpServletRequest request, HttpServletResponse response, String directoryName, Cookie[] cookies, HashMap sessionMap) throws SurveyApplicationException {
        if (this.userID == null || this.toolSessionID == null) {
            String error = "Tool session Id or user Id is null. Unable to continue";
            logger.error((Object)error);
            throw new SurveyApplicationException(error);
        }
        SurveyUser learner = this.service.getUserByIDAndSession(this.userID, this.toolSessionID);
        if (learner == null) {
            String error = "The user with user id " + this.userID + " does not exist.";
            logger.error((Object)error);
            throw new SurveyApplicationException(error);
        }
        Survey content = this.service.getSurveyBySessionId(this.toolSessionID);
        if (content == null) {
            String error = "The content for this activity has not been defined yet.";
            logger.error((Object)error);
            throw new SurveyApplicationException(error);
        }
        sessionMap.put("reflectOn", content.isReflectOnActivity());
        if (content.isReflectOnActivity()) {
            HashMap<Long, TreeSet<ReflectDTO>> map = new HashMap<Long, TreeSet<ReflectDTO>>();
            TreeSet<ReflectDTO> reflectDTOSet = new TreeSet<ReflectDTO>(new ReflectDTOComparator());
            reflectDTOSet.add(this.getReflectionEntry(learner));
            map.put(this.toolSessionID, reflectDTOSet);
            sessionMap.put("reflectList", map);
        }
        SortedMap<SurveySession, SortedMap<SurveyQuestion, List<AnswerDTO>>> groupList = this.service.exportByLearner(learner);
        sessionMap.put("title", content.getTitle());
        sessionMap.put("summaryList", groupList);
    }

    public void teacher(HttpServletRequest request, HttpServletResponse response, String directoryName, Cookie[] cookies, HashMap sessionMap) throws SurveyApplicationException {
        if (this.toolContentID == null) {
            String error = "Tool Content Id is missing. Unable to continue";
            logger.error((Object)error);
            throw new SurveyApplicationException(error);
        }
        Survey content = this.service.getSurveyByContentId(this.toolContentID);
        if (content == null) {
            String error = "Data is missing from the database. Unable to Continue";
            logger.error((Object)error);
            throw new SurveyApplicationException(error);
        }
        SortedMap<SurveySession, SortedMap<SurveyQuestion, List<AnswerDTO>>> groupList = this.service.exportByContentId(this.toolContentID);
        sessionMap.put("reflectOn", content.isReflectOnActivity());
        if (content.isReflectOnActivity()) {
            Map<Long, Set<ReflectDTO>> reflectList = this.service.getReflectList(content.getContentId(), true);
            sessionMap.put("reflectList", reflectList);
        }
        sessionMap.put("title", content.getTitle());
        sessionMap.put("summaryList", groupList);
    }

    private ReflectDTO getReflectionEntry(SurveyUser surveyUser) {
        ReflectDTO reflectDTO = new ReflectDTO(surveyUser);
        NotebookEntry notebookEntry = this.service.getEntry(surveyUser.getSession().getSessionId(), CoreNotebookConstants.NOTEBOOK_TOOL, "lasurv11", surveyUser.getUserId().intValue());
        if (notebookEntry != null) {
            reflectDTO.setReflect(notebookEntry.getEntry());
            logger.debug((Object)("Could not find notebookEntry for SurveyUser: " + surveyUser.getUid()));
        }
        return reflectDTO;
    }
}

