/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.admin.service;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.struts.upload.FormFile;
import org.lamsfoundation.lams.admin.service.IImportService;
import org.lamsfoundation.lams.admin.web.dto.V1OrgRightDTO;
import org.lamsfoundation.lams.admin.web.dto.V1OrganisationDTO;
import org.lamsfoundation.lams.admin.web.dto.V1UserDTO;
import org.lamsfoundation.lams.themes.Theme;
import org.lamsfoundation.lams.usermanagement.AuthenticationMethod;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.OrganisationState;
import org.lamsfoundation.lams.usermanagement.OrganisationType;
import org.lamsfoundation.lams.usermanagement.Role;
import org.lamsfoundation.lams.usermanagement.SupportedLocale;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;
import org.lamsfoundation.lams.util.HashUtil;
import org.lamsfoundation.lams.util.LanguageUtil;
import org.lamsfoundation.lams.util.MessageService;
import org.lamsfoundation.lams.util.audit.IAuditService;
import org.lamsfoundation.lams.web.session.SessionManager;

public class ImportService
implements IImportService {
    private static Logger log = Logger.getLogger(ImportService.class);
    public IUserManagementService service;
    public MessageService messageService;
    public IAuditService auditService;
    private static final short LOGIN = 0;
    private static final short PASSWORD = 1;
    private static final short TITLE = 2;
    private static final short FIRST_NAME = 3;
    private static final short LAST_NAME = 4;
    private static final short AUTH_METHOD = 5;
    private static final short EMAIL = 6;
    private static final short FLASH_THEME = 7;
    private static final short HTML_THEME = 8;
    private static final short LOCALE = 9;
    private static final short ADDRESS1 = 10;
    private static final short ADDRESS2 = 11;
    private static final short ADDRESS3 = 12;
    private static final short CITY = 13;
    private static final short STATE = 14;
    private static final short POSTCODE = 15;
    private static final short COUNTRY = 16;
    private static final short DAY_PHONE = 17;
    private static final short EVE_PHONE = 18;
    private static final short MOB_PHONE = 19;
    private static final short FAX = 20;
    private static final short ORGANISATION = 1;
    private static final short ROLES = 2;
    private static final short NAME = 0;
    private static final short CODE = 1;
    private static final short DESCRIPTION = 2;
    private static final short LOCALE_ID = 3;
    private static final short ORGANISATION_STATE = 4;
    private static final short ADMIN_ADD_NEW_USERS = 5;
    private static final short ADMIN_BROWSE_ALL_USERS = 6;
    private static final short ADMIN_CHANGE_STATUS = 7;
    ArrayList<ArrayList> results = new ArrayList();
    ArrayList<String> rowResult = new ArrayList();
    private boolean emptyRow;
    private boolean hasError;
    private Organisation parentOrg;

    public IUserManagementService getService() {
        return this.service;
    }

    public void setService(IUserManagementService service) {
        this.service = service;
    }

    public MessageService getMessageService() {
        return this.messageService;
    }

    public void setMessageService(MessageService messageService) {
        this.messageService = messageService;
    }

    public IAuditService getAuditService() {
        return this.auditService;
    }

    public void setAuditService(IAuditService auditService) {
        this.auditService = auditService;
    }

    private HSSFSheet getSheet(FormFile fileItem) throws IOException {
        POIFSFileSystem fs = new POIFSFileSystem(fileItem.getInputStream());
        HSSFWorkbook wb = new HSSFWorkbook(fs);
        return wb.getSheetAt(0);
    }

    @Override
    public boolean isUserSpreadsheet(FormFile fileItem) throws IOException {
        HSSFSheet sheet = this.getSheet(fileItem);
        HSSFRow row = sheet.getRow(sheet.getFirstRowNum());
        String string = this.parseStringCell(row.getCell((short)1));
        return StringUtils.equals((String)string, (String)"* password");
    }

    @Override
    public boolean isRolesSpreadsheet(FormFile fileItem) throws IOException {
        HSSFSheet sheet = this.getSheet(fileItem);
        HSSFRow row = sheet.getRow(sheet.getFirstRowNum());
        String string = this.parseStringCell(row.getCell((short)1));
        return StringUtils.equals((String)string, (String)"* organisation");
    }

    @Override
    public List parseSpreadsheet(FormFile fileItem, String sessionId) throws IOException {
        if (this.isUserSpreadsheet(fileItem)) {
            return this.parseUserSpreadsheet(fileItem, sessionId);
        }
        if (this.isRolesSpreadsheet(fileItem)) {
            return this.parseRolesSpreadsheet(fileItem, sessionId);
        }
        return new ArrayList();
    }

    @Override
    public List parseGroupSpreadsheet(FormFile fileItem) throws IOException {
        this.results = new ArrayList();
        this.parentOrg = this.service.getRootOrganisation();
        HSSFSheet sheet = this.getSheet(fileItem);
        int startRow = sheet.getFirstRowNum();
        int endRow = sheet.getLastRowNum();
        log.debug((Object)("Parsing spreadsheet rows " + startRow + " through " + endRow));
        Organisation org = null;
        int successful = 0;
        for (int i = startRow + 1; i < endRow + 1; ++i) {
            this.emptyRow = true;
            this.hasError = false;
            this.rowResult = new ArrayList();
            HSSFRow row = sheet.getRow(i);
            if (row != null) {
                org = this.parseGroup(row, i);
            }
            if (this.emptyRow) {
                log.debug((Object)("Row " + i + " is empty."));
                this.parentOrg = this.service.getRootOrganisation();
                continue;
            }
            if (this.hasError) {
                log.debug((Object)("Row " + i + " has an error which has been sent to the browser."));
                this.results.add(this.rowResult);
                continue;
            }
            org = this.service.saveOrganisation(org, this.getCurrentUserId());
            ++successful;
            this.rowResult.add(org.getOrganisationId().toString());
            this.rowResult.add(org.getName());
            this.rowResult.add(org.getParentOrganisation().getOrganisationId().toString());
            this.rowResult.add(org.getOrganisationType().getOrganisationTypeId().toString());
            this.writeOrgAuditLog(org);
            if (this.parentOrg.getOrganisationType().getOrganisationTypeId().equals(OrganisationType.ROOT_TYPE)) {
                this.parentOrg = org;
            }
            this.results.add(this.rowResult);
        }
        log.debug((Object)("Found " + this.results.size() + " orgs in spreadsheet."));
        this.writeSuccessAuditLog(successful, null, "audit.successful.organisation.import");
        return this.results;
    }

    private Integer getCurrentUserId() {
        try {
            UserDTO user = (UserDTO)SessionManager.getSession().getAttribute("user");
            return user.getUserID();
        }
        catch (Exception e) {
            log.error((Object)e);
            return null;
        }
    }

    private Organisation parseGroup(HSSFRow row, int rowIndex) {
        Organisation org = new Organisation();
        Object[] args = new String[1];
        String name = this.parseStringCell(row.getCell((short)0));
        if (name == null || name == "") {
            this.rowResult.add(this.messageService.getMessage("error.name.required"));
            this.hasError = true;
            return null;
        }
        org.setName(name);
        org.setCode(this.parseStringCell(row.getCell((short)1)));
        org.setDescription(this.parseStringCell(row.getCell((short)2)));
        String localeId = this.parseStringCell(row.getCell((short)3));
        SupportedLocale locale = this.getLocale(localeId);
        if (locale == null) {
            args[0] = "(" + localeId + ")";
            this.rowResult.add(this.messageService.getMessage("error.locale.invalid", args));
            this.hasError = true;
        } else {
            org.setLocale(locale);
        }
        String orgStateText = this.parseStringCell(row.getCell((short)4));
        OrganisationState orgState = this.getOrganisationState(orgStateText);
        org.setOrganisationState(orgState);
        org.setOrganisationType((OrganisationType)this.service.findById(OrganisationType.class, (Serializable)(this.parentOrg.getOrganisationType().getOrganisationTypeId().equals(OrganisationType.ROOT_TYPE) ? OrganisationType.COURSE_TYPE : OrganisationType.CLASS_TYPE)));
        org.setParentOrganisation(this.parentOrg);
        org.setCourseAdminCanAddNewUsers(Boolean.valueOf(this.parseBooleanCell(row.getCell((short)5))));
        org.setCourseAdminCanBrowseAllUsers(Boolean.valueOf(this.parseBooleanCell(row.getCell((short)6))));
        org.setCourseAdminCanChangeStatusOfCourse(Boolean.valueOf(this.parseBooleanCell(row.getCell((short)7))));
        return this.hasError ? null : org;
    }

    @Override
    public List<List> parseV1UsersFile(FormFile fileItem, boolean includeIntegrated) throws IOException {
        ArrayList<V1UserDTO> users = new ArrayList<V1UserDTO>();
        ArrayList<V1OrganisationDTO> orgs = new ArrayList<V1OrganisationDTO>();
        ArrayList<List> results = new ArrayList<List>();
        ArrayList<String> integPrefixes = new ArrayList<String>();
        ArrayList<String> integOrgid = new ArrayList<String>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(fileItem.getInputStream()));
        String line = reader.readLine();
        while (!line.startsWith("login\tpassword")) {
            if (!line.startsWith("prefix")) {
                String[] lineArray = line.split("\t");
                if (lineArray.length > 0) {
                    integPrefixes.add(lineArray[0]);
                }
                if (lineArray.length > 1) {
                    integOrgid.add(lineArray[1]);
                }
            }
            line = reader.readLine();
        }
        line = reader.readLine();
        while (!line.startsWith("sid\tname")) {
            String[] userDetails = line.split("\t");
            line = reader.readLine();
            if (!includeIntegrated && this.isIntegratedUser(integPrefixes, userDetails[0])) continue;
            V1UserDTO userDTO = new V1UserDTO(userDetails[0], userDetails[1], userDetails[2], userDetails[3]);
            if (userDetails.length > 4 && !StringUtils.equals((String)userDetails[4], (String)"NULL")) {
                userDTO.setEmail(userDetails[4]);
            }
            users.add(userDTO);
        }
        line = reader.readLine();
        while (!line.startsWith("login\tg")) {
            String[] orgDetails = line.split("\t");
            line = reader.readLine();
            if (orgDetails.length != 4) {
                log.debug((Object)"LAMS 1 text file has troublesome organisation: ");
                for (int i = 0; i < orgDetails.length; ++i) {
                    log.debug((Object)("column: " + orgDetails[i]));
                }
                continue;
            }
            if (!includeIntegrated && integOrgid.contains(orgDetails[0])) continue;
            V1OrganisationDTO org = new V1OrganisationDTO(orgDetails[0], orgDetails[1], orgDetails[2], orgDetails[3]);
            orgs.add(org);
        }
        line = reader.readLine();
        ArrayList<String> currentRoles = new ArrayList<String>();
        String currentLogin = "";
        while (!line.startsWith("login\tsid")) {
            String[] userRole = line.split("\t");
            line = reader.readLine();
            if (!includeIntegrated && this.isIntegratedUser(integPrefixes, userRole[0])) continue;
            if (!StringUtils.equals((String)userRole[0], (String)currentLogin)) {
                if (!currentRoles.isEmpty()) {
                    int index = users.indexOf(new V1UserDTO(currentLogin));
                    V1UserDTO userDTO = (V1UserDTO)users.get(index);
                    userDTO.setRoleIds(new ArrayList<String>(currentRoles));
                    users.set(index, userDTO);
                }
                currentLogin = userRole[0];
                currentRoles.clear();
            }
            currentRoles.add(userRole[1]);
        }
        int index = users.indexOf(new V1UserDTO(currentLogin));
        V1UserDTO userDTO = (V1UserDTO)users.get(index);
        userDTO.setRoleIds(new ArrayList<String>(currentRoles));
        users.set(index, userDTO);
        line = reader.readLine();
        while (line != null) {
            String[] userRight = line.split("\t");
            line = reader.readLine();
            if (!includeIntegrated && this.isIntegratedUser(integPrefixes, userRight[0])) continue;
            V1OrgRightDTO orgRightDTO = new V1OrgRightDTO(userRight[1], userRight[2]);
            index = users.indexOf(new V1UserDTO(userRight[0]));
            userDTO = (V1UserDTO)users.get(index);
            List<V1OrgRightDTO> orgRights = userDTO.getOrgRights();
            if (orgRights == null) {
                orgRights = new ArrayList<V1OrgRightDTO>();
            }
            orgRights.add(orgRightDTO);
            userDTO.setOrgRights(orgRights);
            users.set(index, userDTO);
        }
        results.add(users);
        results.add(orgs);
        return results;
    }

    private boolean isIntegratedUser(List<String> integPrefixes, String login) {
        int underscore = login.indexOf(95);
        return underscore >= 0 && integPrefixes.contains(login.substring(0, underscore));
    }

    @Override
    public int getNumRows(FormFile fileItem) throws IOException {
        HSSFSheet sheet = this.getSheet(fileItem);
        int startRow = sheet.getFirstRowNum();
        int endRow = sheet.getLastRowNum();
        return endRow - startRow;
    }

    @Override
    public List parseUserSpreadsheet(FormFile fileItem, String sessionId) throws IOException {
        this.results = new ArrayList();
        HSSFSheet sheet = this.getSheet(fileItem);
        int startRow = sheet.getFirstRowNum();
        int endRow = sheet.getLastRowNum();
        this.setupImportStatus(sessionId, endRow - startRow);
        UserDTO userDTO = (UserDTO)SessionManager.getSession((String)sessionId).getAttribute("user");
        log.debug((Object)("Parsing spreadsheet rows " + startRow + " through " + endRow));
        User user = null;
        int successful = 0;
        for (int i = startRow + 1; i < endRow + 1; ++i) {
            this.emptyRow = true;
            this.hasError = false;
            this.rowResult = new ArrayList();
            HSSFRow row = sheet.getRow(i);
            user = this.parseUser(row, i);
            if (this.emptyRow) {
                log.debug((Object)("Row " + i + " is empty."));
                break;
            }
            if (this.hasError) {
                log.debug((Object)("Row " + i + " has an error which has been sent to the browser."));
                this.results.add(this.rowResult);
                this.writeErrorsAuditLog(i + 1, this.rowResult, userDTO);
                this.updateImportStatus(sessionId, this.results.size());
                continue;
            }
            try {
                this.service.save((Object)user);
                ++successful;
                this.writeAuditLog(user, userDTO);
                log.debug((Object)("Row " + i + " saved user: " + user.getLogin()));
            }
            catch (Exception e) {
                log.debug((Object)e);
                this.rowResult.add(this.messageService.getMessage("error.fail.add"));
            }
            if (this.rowResult.size() > 0) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Row " + i + " has " + this.rowResult.size() + " messages."));
                }
                this.writeErrorsAuditLog(i + 1, this.rowResult, userDTO);
            }
            this.results.add(this.rowResult);
            this.updateImportStatus(sessionId, this.results.size());
        }
        log.debug((Object)("Found " + this.results.size() + " users in spreadsheet."));
        this.writeSuccessAuditLog(successful, userDTO, "audit.successful.user.import");
        return this.results;
    }

    private void setupImportStatus(String sessionId, int importTotal) {
        HttpSession ss = SessionManager.getSession((String)sessionId);
        ss.setAttribute("importTotal", (Object)importTotal);
        ss.setAttribute("imported", (Object)0);
    }

    private void updateImportStatus(String sessionId, int imported) {
        HttpSession ss = SessionManager.getSession((String)sessionId);
        ss.removeAttribute("imported");
        ss.setAttribute("imported", (Object)imported);
    }

    @Override
    public List parseRolesSpreadsheet(FormFile fileItem, String sessionId) throws IOException {
        this.results = new ArrayList();
        HSSFSheet sheet = this.getSheet(fileItem);
        int startRow = sheet.getFirstRowNum();
        int endRow = sheet.getLastRowNum();
        log.debug((Object)("Parsing spreadsheet rows " + startRow + " through " + endRow));
        this.setupImportStatus(sessionId, endRow - startRow);
        UserDTO userDTO = (UserDTO)SessionManager.getSession((String)sessionId).getAttribute("user");
        int successful = 0;
        for (int i = startRow + 1; i < endRow + 1; ++i) {
            this.emptyRow = true;
            this.hasError = false;
            this.rowResult = new ArrayList();
            HSSFRow row = sheet.getRow(i);
            String login = this.parseStringCell(row.getCell((short)0));
            String orgId = this.parseStringCell(row.getCell((short)1));
            List<String> roles = this.parseRolesCell(row.getCell((short)2));
            if (this.emptyRow) {
                log.debug((Object)("Row " + i + " is empty."));
                break;
            }
            if (this.hasError) {
                log.debug((Object)("Row " + i + " has an error which has been sent to the browser."));
                this.results.add(this.rowResult);
                this.writeErrorsAuditLog(i + 1, this.rowResult, userDTO);
                this.updateImportStatus(sessionId, this.results.size());
                continue;
            }
            try {
                this.saveUserRoles(this.isSysadmin(sessionId), login, orgId, roles, row);
                ++successful;
            }
            catch (Exception e) {
                log.error((Object)("Unable to assign roles to user: " + login), (Throwable)e);
                this.rowResult.add(this.messageService.getMessage("error.fail.add"));
            }
            if (this.rowResult.size() > 0) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Row " + i + " has " + this.rowResult.size() + " messages."));
                }
                this.writeErrorsAuditLog(i + 1, this.rowResult, userDTO);
            }
            this.results.add(this.rowResult);
            this.updateImportStatus(sessionId, this.results.size());
        }
        log.debug((Object)("Found " + this.results.size() + " users in spreadsheet."));
        this.writeSuccessAuditLog(successful, userDTO, "audit.successful.role.import");
        return this.results;
    }

    private void setError(String message, String arg) {
        if (StringUtils.isBlank((String)arg)) {
            this.rowResult.add(this.messageService.getMessage(message));
        } else {
            Object[] args = new String[]{arg};
            this.rowResult.add(this.messageService.getMessage(message, args));
        }
        this.hasError = true;
    }

    private boolean isSysadmin(String sessionId) {
        UserDTO userDTO = (UserDTO)SessionManager.getSession((String)sessionId).getAttribute("user");
        return this.service.isUserInRole(userDTO.getUserID(), this.service.getRootOrganisation().getOrganisationId(), "SYSADMIN");
    }

    private void saveUserRoles(boolean isSysadmin, String login, String orgId, List<String> roles, HSSFRow row) {
        User user = null;
        if (StringUtils.isNotBlank((String)login)) {
            user = this.service.getUserByLogin(login);
        } else if (StringUtils.isBlank((String)login)) {
            this.setError("error.login.required", "");
        }
        if (user == null) {
            this.setError("error.user.does.not.exist", "(" + login + ")");
        }
        Organisation org = null;
        if (StringUtils.isNotBlank((String)orgId)) {
            org = (Organisation)this.service.findById(Organisation.class, (Serializable)new Integer(orgId));
        }
        if (StringUtils.isBlank((String)orgId) || org == null) {
            this.setError("error.org.invalid", "(" + orgId + ")");
        } else if (roles == null || !this.checkValidRoles(roles, isSysadmin, org.getOrganisationType())) {
            this.setError("error.roles.invalid", "(" + this.parseStringCell(row.getCell((short)2)) + ")");
        }
        if (!this.hasError) {
            this.service.setRolesForUserOrganisation(user, org.getOrganisationId(), roles);
            if (log.isDebugEnabled()) {
                log.debug((Object)("added: " + login + " to: " + org.getName() + " with roles: " + roles));
            }
        }
    }

    private User parseUser(HSSFRow row, int rowIndex) {
        User user = new User();
        Object[] args = new String[1];
        String login = this.parseStringCell(row.getCell((short)0));
        if (login == null || login == "") {
            this.rowResult.add(this.messageService.getMessage("error.login.required"));
            this.hasError = true;
            return null;
        }
        if (this.service.getUserByLogin(login) != null) {
            args[0] = "(" + login + ")";
            this.rowResult.add(this.messageService.getMessage("error.login.unique", args));
            this.hasError = true;
            return null;
        }
        user.setLogin(login);
        String password = HashUtil.sha1((String)this.parseStringCell(row.getCell((short)1)));
        user.setPassword(password);
        user.setTitle(this.parseStringCell(row.getCell((short)2)));
        String fname = this.parseStringCell(row.getCell((short)3));
        if (fname == null || fname == "") {
            this.rowResult.add(this.messageService.getMessage("error.firstname.required"));
            this.hasError = true;
        } else {
            user.setFirstName(fname);
        }
        String lname = this.parseStringCell(row.getCell((short)4));
        if (lname == null || lname == "") {
            this.rowResult.add(this.messageService.getMessage("error.lastname.required"));
            this.hasError = true;
        } else {
            user.setLastName(lname);
        }
        String authMethodName = this.parseStringCell(row.getCell((short)5));
        AuthenticationMethod authMethod = this.getAuthMethod(authMethodName);
        if (authMethod == null) {
            args[0] = "(" + authMethodName + ")";
            this.rowResult.add(this.messageService.getMessage("error.authmethod.invalid", args));
            this.hasError = true;
        } else {
            user.setAuthenticationMethod(authMethod);
        }
        String email = this.parseStringCell(row.getCell((short)6));
        if (email == null || email == "") {
            this.rowResult.add(this.messageService.getMessage("error.email.required"));
            this.hasError = true;
        } else {
            Pattern p = Pattern.compile(".+@.+\\.[a-z]+");
            Matcher m = p.matcher(email);
            if (!m.matches()) {
                this.rowResult.add(this.messageService.getMessage("error.valid.email.required"));
                this.hasError = true;
            }
            user.setEmail(email);
        }
        String flashId = this.parseStringCell(row.getCell((short)7));
        Theme flashTheme = this.getFlashTheme(flashId);
        if (flashTheme == null) {
            args[0] = "(" + flashId + ")";
            this.rowResult.add(this.messageService.getMessage("error.flash.theme.invalid", args));
            this.hasError = true;
        } else {
            user.setFlashTheme(flashTheme);
        }
        String htmlId = this.parseStringCell(row.getCell((short)8));
        Theme htmlTheme = this.getHtmlTheme(htmlId);
        if (htmlTheme == null) {
            args[0] = "(" + htmlId + ")";
            this.rowResult.add(this.messageService.getMessage("error.html.theme.invalid", args));
            this.hasError = true;
        } else {
            user.setHtmlTheme(htmlTheme);
        }
        String localeId = this.parseStringCell(row.getCell((short)9));
        SupportedLocale locale = this.getLocale(localeId);
        if (locale == null) {
            args[0] = "(" + localeId + ")";
            this.rowResult.add(this.messageService.getMessage("error.locale.invalid", args));
            this.hasError = true;
        } else {
            user.setLocale(locale);
        }
        user.setAddressLine1(this.parseStringCell(row.getCell((short)10)));
        user.setAddressLine2(this.parseStringCell(row.getCell((short)11)));
        user.setAddressLine3(this.parseStringCell(row.getCell((short)12)));
        user.setCity(this.parseStringCell(row.getCell((short)13)));
        user.setState(this.parseStringCell(row.getCell((short)14)));
        user.setPostcode(this.parseStringCell(row.getCell((short)15)));
        user.setCountry(this.parseStringCell(row.getCell((short)16)));
        user.setDayPhone(this.parseStringCell(row.getCell((short)17)));
        user.setEveningPhone(this.parseStringCell(row.getCell((short)18)));
        user.setMobilePhone(this.parseStringCell(row.getCell((short)19)));
        user.setFax(this.parseStringCell(row.getCell((short)20)));
        user.setDisabledFlag(Boolean.valueOf(false));
        user.setCreateDate(new Date());
        user.setTimeZone(user.getTimeZone());
        user.setTutorialsDisabled(Boolean.valueOf(false));
        user.setFirstLogin(Boolean.valueOf(true));
        user.setEnableFlash(Boolean.valueOf(Configuration.getAsBoolean((String)ConfigurationKeys.FLASH_ENABLE)));
        return this.hasError ? null : user;
    }

    private boolean parseBooleanCell(HSSFCell cell) {
        if (cell != null) {
            String value;
            try {
                cell.setCellType(1);
                if (cell.getStringCellValue() != null) {
                    if (cell.getStringCellValue().trim().length() != 0) {
                        this.emptyRow = false;
                    }
                } else {
                    return false;
                }
                value = cell.getStringCellValue().trim();
            }
            catch (Exception e) {
                cell.setCellType(0);
                double d = cell.getNumericCellValue();
                this.emptyRow = false;
                value = new Long(new Double(d).longValue()).toString();
            }
            if (StringUtils.equals((String)value, (String)"1") || StringUtils.equalsIgnoreCase((String)value, (String)"true")) {
                return true;
            }
        }
        return false;
    }

    private String parseStringCell(HSSFCell cell) {
        if (cell != null) {
            try {
                cell.setCellType(1);
                if (cell.getStringCellValue() != null) {
                    if (cell.getStringCellValue().trim().length() != 0) {
                        this.emptyRow = false;
                    }
                } else {
                    return null;
                }
                return cell.getStringCellValue().trim();
            }
            catch (Exception e) {
                cell.setCellType(0);
                double d = cell.getNumericCellValue();
                this.emptyRow = false;
                return new Long(new Double(d).longValue()).toString();
            }
        }
        return null;
    }

    private AuthenticationMethod getAuthMethod(String authMethodName) {
        if (authMethodName == null || authMethodName == "") {
            return (AuthenticationMethod)this.service.findById(AuthenticationMethod.class, (Serializable)AuthenticationMethod.DB);
        }
        try {
            Integer authMethodId = new Integer(authMethodName);
            return (AuthenticationMethod)this.service.findById(AuthenticationMethod.class, (Serializable)authMethodId);
        }
        catch (NumberFormatException e) {
            List list = this.service.findByProperty(AuthenticationMethod.class, "authenticationMethodName", (Object)authMethodName);
            return list == null || list.isEmpty() ? null : (AuthenticationMethod)list.get(0);
        }
    }

    private List<String> parseRolesCell(HSSFCell cell) {
        String roleDescription = "";
        if (cell != null) {
            String role;
            try {
                cell.setCellType(1);
                if (cell.getStringCellValue() == null && cell.getStringCellValue().trim().length() == 0) {
                    log.debug((Object)"Couldn't find any roles in spreadsheet column index 2");
                    return null;
                }
                this.emptyRow = false;
                roleDescription = cell.getStringCellValue().trim();
            }
            catch (Exception e) {
                log.error((Object)("Caught exception when reading roles in spreadsheet: " + e.getMessage()));
                return null;
            }
            ArrayList<String> roles = new ArrayList<String>();
            int fromIndex = 0;
            int index = roleDescription.indexOf("|", fromIndex);
            while (index != -1) {
                role = this.addRoleId(roleDescription, fromIndex, index);
                log.debug((Object)("Found role: " + role));
                if (role == null) {
                    return null;
                }
                roles.add(role);
                fromIndex = index + 1;
                index = roleDescription.indexOf("|", fromIndex);
            }
            role = this.addRoleId(roleDescription, fromIndex, roleDescription.length());
            log.debug((Object)("Found last role: " + role));
            if (role == null) {
                return null;
            }
            roles.add(role);
            return roles;
        }
        return null;
    }

    private String addRoleId(String roleDescription, int fromIndex, int index) {
        Role role;
        List list = this.service.findByProperty(Role.class, "name", (Object)roleDescription.substring(fromIndex, index));
        Role role2 = role = list == null || list.isEmpty() ? null : (Role)list.get(0);
        if (role != null) {
            return role.getRoleId().toString();
        }
        return null;
    }

    private boolean checkValidRoles(List<String> idList, boolean isSysadmin, OrganisationType orgType) {
        ArrayList<Role> roleList = new ArrayList<Role>();
        for (String id : idList) {
            Role role = (Role)this.service.findById(Role.class, (Serializable)Integer.valueOf(Integer.parseInt(id)));
            if (role != null) {
                roleList.add(role);
                continue;
            }
            return false;
        }
        List validRoles = this.service.filterRoles(roleList, Boolean.valueOf(isSysadmin), orgType);
        for (Role r : roleList) {
            if (validRoles.contains(r)) continue;
            return false;
        }
        return true;
    }

    private Theme getFlashTheme(String flashId) {
        if (flashId == null || flashId == "") {
            return this.service.getDefaultFlashTheme();
        }
        try {
            return (Theme)this.service.findById(Theme.class, (Serializable)new Long(flashId));
        }
        catch (Exception e) {
            return null;
        }
    }

    private Theme getHtmlTheme(String htmlId) {
        if (htmlId == null || htmlId == "") {
            return this.service.getDefaultHtmlTheme();
        }
        try {
            return (Theme)this.service.findById(Theme.class, (Serializable)new Long(htmlId));
        }
        catch (Exception e) {
            return null;
        }
    }

    private SupportedLocale getLocale(String localeId) {
        if (localeId == null || localeId == "") {
            return LanguageUtil.getDefaultLocale();
        }
        try {
            return (SupportedLocale)this.service.findById(SupportedLocale.class, (Serializable)new Integer(localeId));
        }
        catch (Exception e) {
            return null;
        }
    }

    private OrganisationState getOrganisationState(String orgStateText) {
        if (StringUtils.equals((String)orgStateText, (String)"hidden")) {
            return (OrganisationState)this.service.findById(OrganisationState.class, (Serializable)OrganisationState.HIDDEN);
        }
        if (StringUtils.equals((String)orgStateText, (String)"archived")) {
            return (OrganisationState)this.service.findById(OrganisationState.class, (Serializable)OrganisationState.ARCHIVED);
        }
        return (OrganisationState)this.service.findById(OrganisationState.class, (Serializable)OrganisationState.ACTIVE);
    }

    private void writeAuditLog(User user, UserDTO userDTO) {
        Object[] args = new String[]{user.getLogin() + "(" + user.getUserId() + ")", user.getFullName()};
        String message = this.messageService.getMessage("audit.user.create", args);
        this.auditService.log(userDTO, "admin", message);
    }

    private void writeOrgAuditLog(Organisation org) {
        Object[] args = new String[]{org.getName() + "(" + org.getOrganisationId() + ")", org.getOrganisationType().getName()};
        String message = this.messageService.getMessage("audit.organisation.create", args);
        this.auditService.log("admin", message);
    }

    private void writeErrorsAuditLog(int row, List<String> list, UserDTO userDTO) {
        for (String s : list) {
            this.writeErrorAuditLog(row, s, userDTO);
        }
    }

    private void writeErrorAuditLog(int row, String error, UserDTO userDTO) {
        Object[] args = new String[]{Integer.toString(row), error};
        String message = this.messageService.getMessage("audit.spreadsheet.error", args);
        this.auditService.log(userDTO, "admin", message);
    }

    private void writeSuccessAuditLog(int successful, UserDTO userDTO, String key) {
        Object[] args = new String[]{Integer.toString(successful)};
        String message = this.messageService.getMessage(key, args);
        if (userDTO == null) {
            this.auditService.log("admin", message);
        } else {
            this.auditService.log(userDTO, "admin", message);
        }
    }
}

