/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.admin.web;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.upload.FormFile;
import org.lamsfoundation.lams.admin.service.AdminServiceProxy;
import org.lamsfoundation.lams.admin.service.IImportService;
import org.lamsfoundation.lams.admin.web.ImportExcelForm;
import org.lamsfoundation.lams.web.session.SessionManager;

public class ImportExcelSaveAction
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.isCancelled(request)) {
            return mapping.findForward("sysadmin");
        }
        IImportService importService = AdminServiceProxy.getImportService(this.getServlet().getServletContext());
        ImportExcelForm importExcelForm = (ImportExcelForm)form;
        FormFile file = importExcelForm.getFile();
        if (file == null || file.getFileSize() <= 0) {
            return mapping.findForward("import");
        }
        String sessionId = SessionManager.getSession().getId();
        SessionManager.getSession().setAttribute("file", (Object)file);
        if (importService.getNumRows(file) < 500) {
            List results = importService.parseSpreadsheet(file, sessionId);
            SessionManager.getSession((String)sessionId).setAttribute("results", (Object)results);
            return mapping.findForward("results");
        }
        Thread t = new Thread(new ImportExcelThread(sessionId));
        t.start();
        return mapping.findForward("status");
    }

    private class ImportExcelThread
    implements Runnable {
        private String sessionId;

        public ImportExcelThread(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public void run() {
            IImportService importService = AdminServiceProxy.getImportService(ImportExcelSaveAction.this.getServlet().getServletContext());
            try {
                FormFile file = (FormFile)SessionManager.getSession((String)this.sessionId).getAttribute("file");
                List results = importService.parseSpreadsheet(file, this.sessionId);
                SessionManager.getSession((String)this.sessionId).setAttribute("results", (Object)results);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

