/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.admin.web;

import java.io.Serializable;
import java.util.Date;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.action.DynaActionForm;
import org.lamsfoundation.lams.admin.service.AdminServiceProxy;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.OrganisationState;
import org.lamsfoundation.lams.usermanagement.OrganisationType;
import org.lamsfoundation.lams.usermanagement.SupportedLocale;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.MessageService;
import org.lamsfoundation.lams.util.audit.IAuditService;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class OrgSaveAction
extends Action {
    private static Logger log = Logger.getLogger(OrgSaveAction.class);
    private static IUserManagementService service;
    private MessageService messageService;

    /*
     * Enabled aggressive block sorting
     */
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Organisation org;
        if (service == null) {
            service = AdminServiceProxy.getService(this.getServlet().getServletContext());
        }
        if (this.messageService == null) {
            this.messageService = AdminServiceProxy.getMessageService(this.getServlet().getServletContext());
        }
        DynaActionForm orgForm = (DynaActionForm)form;
        Integer orgId = (Integer)orgForm.get("orgId");
        if (this.isCancelled(request)) {
            if (orgId != 0) {
                request.setAttribute("org", (Object)orgId);
                Organisation org2 = (Organisation)service.findById(Organisation.class, (Serializable)orgId);
                if (!org2.getOrganisationType().getOrganisationTypeId().equals(OrganisationType.CLASS_TYPE)) return mapping.findForward("orglist");
                return mapping.findForward("userlist");
            } else {
                request.setAttribute("org", orgForm.get("parentId"));
            }
            return mapping.findForward("orglist");
        }
        ActionMessages errors = new ActionMessages();
        if (orgForm.get("name") == null || orgForm.getString("name").trim().length() == 0) {
            errors.add("name", new ActionMessage("error.name.required"));
        }
        if (!errors.isEmpty()) {
            this.saveErrors(request, errors);
            return mapping.findForward("organisation");
        }
        HttpSession ss = SessionManager.getSession();
        UserDTO user = (UserDTO)ss.getAttribute("user");
        SupportedLocale locale = (SupportedLocale)service.findById(SupportedLocale.class, (Serializable)((Integer)orgForm.get("localeId")));
        OrganisationState state = (OrganisationState)service.findById(OrganisationState.class, (Serializable)((Integer)orgForm.get("stateId")));
        if (orgId != 0) {
            if (!service.canEditGroup(user.getUserID(), orgId)) {
                request.setAttribute("errorName", (Object)"UserAction");
                request.setAttribute("errorMessage", (Object)this.messageService.getMessage("error.authorisation"));
                return mapping.findForward("error");
            }
            org = (Organisation)service.findById(Organisation.class, (Serializable)orgId);
            if (state.getOrganisationStateId().equals(OrganisationState.ARCHIVED) && !org.getOrganisationState().getOrganisationStateId().equals(OrganisationState.ARCHIVED)) {
                org.setArchivedDate(new Date());
            }
            this.writeAuditLog(org, orgForm, state, locale);
            BeanUtils.copyProperties((Object)org, (Object)orgForm);
        } else {
            org = new Organisation();
            BeanUtils.copyProperties((Object)org, (Object)orgForm);
            org.setParentOrganisation((Organisation)service.findById(Organisation.class, (Serializable)((Integer)orgForm.get("parentId"))));
            org.setOrganisationType((OrganisationType)service.findById(OrganisationType.class, (Serializable)((Integer)orgForm.get("typeId"))));
            this.writeAuditLog(org, orgForm, org.getOrganisationState(), org.getLocale());
        }
        org.setLocale(locale);
        org.setOrganisationState(state);
        if (log.isDebugEnabled()) {
            log.debug((Object)("orgId: " + org.getOrganisationId() + " create date: " + org.getCreateDate()));
        }
        org = service.saveOrganisation(org, user.getUserID());
        request.setAttribute("org", orgForm.get("parentId"));
        return mapping.findForward("orglist");
    }

    private void writeAuditLog(Organisation org, DynaActionForm orgForm, OrganisationState newState, SupportedLocale newLocale) {
        WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
        IAuditService auditService = (IAuditService)ctx.getBean("auditService");
        MessageService messageService = (MessageService)ctx.getBean("adminMessageService");
        if ((Integer)orgForm.get("orgId") != 0) {
            String message;
            String key = "audit.organisation.change";
            Object[] args = new String[4];
            args[1] = org.getName() + "(" + org.getOrganisationId() + ")";
            if (!org.getOrganisationState().getOrganisationStateId().equals((Integer)orgForm.get("stateId"))) {
                args[0] = "state";
                args[2] = org.getOrganisationState().getDescription();
                args[3] = newState.getDescription();
                message = messageService.getMessage("audit.organisation.change", args);
                auditService.log("admin", message);
            }
            if (!StringUtils.equals((String)org.getName(), (String)((String)orgForm.get("name")))) {
                args[0] = "name";
                args[2] = org.getName();
                args[3] = (String)orgForm.get("name");
                message = messageService.getMessage("audit.organisation.change", args);
                auditService.log("admin", message);
            }
            if (!StringUtils.equals((String)org.getCode(), (String)((String)orgForm.get("code")))) {
                args[0] = "code";
                args[2] = org.getCode();
                args[3] = (String)orgForm.get("code");
                message = messageService.getMessage("audit.organisation.change", args);
                auditService.log("admin", message);
            }
            if (!StringUtils.equals((String)org.getDescription(), (String)orgForm.getString("description"))) {
                args[0] = "description";
                args[2] = org.getDescription();
                args[3] = (String)orgForm.get("description");
                message = messageService.getMessage("audit.organisation.change", args);
                auditService.log("admin", message);
            }
            if (!org.getCourseAdminCanAddNewUsers().equals((Boolean)orgForm.get("courseAdminCanAddNewUsers"))) {
                args[0] = "courseAdminCanAddNewUsers";
                args[2] = org.getCourseAdminCanAddNewUsers() != false ? "true" : "false";
                args[3] = (Boolean)orgForm.get("courseAdminCanAddNewUsers") != false ? "true" : "false";
                message = messageService.getMessage("audit.organisation.change", args);
                auditService.log("admin", message);
            }
            if (!org.getCourseAdminCanBrowseAllUsers().equals((Boolean)orgForm.get("courseAdminCanBrowseAllUsers"))) {
                args[0] = "courseAdminCanBrowseAllUsers";
                args[2] = org.getCourseAdminCanBrowseAllUsers() != false ? "true" : "false";
                args[3] = (Boolean)orgForm.get("courseAdminCanBrowseAllUsers") != false ? "true" : "false";
                message = messageService.getMessage("audit.organisation.change", args);
                auditService.log("admin", message);
            }
            if (!org.getCourseAdminCanChangeStatusOfCourse().equals((Boolean)orgForm.get("courseAdminCanChangeStatusOfCourse"))) {
                args[0] = "courseAdminCanChangeStatusOfCourse";
                args[2] = org.getCourseAdminCanChangeStatusOfCourse() != false ? "true" : "false";
                args[3] = (Boolean)orgForm.get("courseAdminCanChangeStatusOfCourse") != false ? "true" : "false";
                message = messageService.getMessage("audit.organisation.change", args);
                auditService.log("admin", message);
            }
            if (!org.getLocale().getLocaleId().equals((Integer)orgForm.get("localeId"))) {
                args[0] = "locale";
                args[2] = org.getLocale().getDescription();
                args[3] = newLocale.getDescription();
                message = messageService.getMessage("audit.organisation.change", args);
                auditService.log("admin", message);
            }
        } else {
            Object[] args = new String[]{org.getName() + "(" + org.getOrganisationId() + ")", org.getOrganisationType().getName()};
            String message = messageService.getMessage("audit.organisation.create", args);
            auditService.log("admin", message);
        }
    }
}

