/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.admin.web;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;
import org.lamsfoundation.lams.admin.service.AdminServiceProxy;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.OrganisationState;
import org.lamsfoundation.lams.usermanagement.OrganisationType;
import org.lamsfoundation.lams.usermanagement.SupportedLocale;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.MessageService;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.action.LamsDispatchAction;
import org.lamsfoundation.lams.web.session.SessionManager;

public class OrganisationAction
extends LamsDispatchAction {
    private static IUserManagementService service;
    private static MessageService messageService;
    private static List<SupportedLocale> locales;
    private static List status;

    public ActionForward edit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Integer userId;
        UserDTO userDto;
        service = AdminServiceProxy.getService(this.getServlet().getServletContext());
        this.initLocalesAndStatus();
        DynaActionForm orgForm = (DynaActionForm)form;
        Integer orgId = WebUtil.readIntParam((HttpServletRequest)request, (String)"orgId", (boolean)true);
        HttpSession session = SessionManager.getSession();
        if (session != null && (userDto = (UserDTO)session.getAttribute("user")) != null && service.canEditGroup(userId = userDto.getUserID(), orgId)) {
            if (orgId != null) {
                Organisation org = (Organisation)service.findById(Organisation.class, (Serializable)orgId);
                BeanUtils.copyProperties((Object)orgForm, (Object)org);
                orgForm.set("parentId", (Object)org.getParentOrganisation().getOrganisationId());
                orgForm.set("parentName", (Object)org.getParentOrganisation().getName());
                orgForm.set("typeId", (Object)org.getOrganisationType().getOrganisationTypeId());
                orgForm.set("stateId", (Object)org.getOrganisationState().getOrganisationStateId());
                SupportedLocale locale = org.getLocale();
                orgForm.set("localeId", (Object)(locale != null ? locale.getLocaleId() : null));
            }
            request.getSession().setAttribute("locales", locales);
            request.getSession().setAttribute("status", (Object)status);
            if (service.isUserSysAdmin() || service.isUserGlobalGroupAdmin()) {
                return mapping.findForward("organisation");
            }
            return mapping.findForward("organisationCourseAdmin");
        }
        return this.error(mapping, request);
    }

    public ActionForward create(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        service = AdminServiceProxy.getService(this.getServlet().getServletContext());
        this.initLocalesAndStatus();
        DynaActionForm orgForm = (DynaActionForm)form;
        if (!request.isUserInRole("SYSADMIN") && !service.isUserGlobalGroupAdmin() && (orgForm.get("typeId") != null && orgForm.get("typeId").equals(OrganisationType.COURSE_TYPE) || orgForm.get("typeId") == null)) {
            return this.error(mapping, request);
        }
        orgForm.set("orgId", null);
        Integer parentId = WebUtil.readIntParam((HttpServletRequest)request, (String)"parentId", (boolean)true);
        if (parentId != null) {
            Organisation parentOrg = (Organisation)service.findById(Organisation.class, (Serializable)parentId);
            orgForm.set("parentName", (Object)parentOrg.getName());
        }
        request.getSession().setAttribute("locales", locales);
        request.getSession().setAttribute("status", (Object)status);
        return mapping.findForward("organisation");
    }

    private ActionForward error(ActionMapping mapping, HttpServletRequest request) {
        messageService = AdminServiceProxy.getMessageService(this.getServlet().getServletContext());
        request.setAttribute("errorName", (Object)"OrganisationAction");
        request.setAttribute("errorMessage", (Object)messageService.getMessage("error.authorisation"));
        return mapping.findForward("error");
    }

    private void initLocalesAndStatus() {
        if (locales == null || status == null && service != null) {
            locales = service.findAll(SupportedLocale.class);
            status = service.findAll(OrganisationState.class);
            Collections.sort(locales);
        }
    }
}

