/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.admin.web;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.lamsfoundation.lams.admin.service.AdminServiceProxy;
import org.lamsfoundation.lams.learningdesign.dto.LearningLibraryDTO;
import org.lamsfoundation.lams.learningdesign.dto.LibraryActivityDTO;
import org.lamsfoundation.lams.learningdesign.service.ILearningDesignService;
import org.lamsfoundation.lams.tool.Tool;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class ToolContentListAction
extends Action {
    private static final String PARAM_ACTION = "action";
    private static final String PARAM_LIBRARY_ID = "libraryID";
    private static final String ATTRIBUTE_ERROR_NAME = "errorName";
    private static final String ATTRIBUTE_ERROR_MESSAGE = "errorMessage";
    private static final String ATTRIBUTE_LIBRARY = "toolLibrary";
    private static final String ATTRIBUTE_VALIDITY = "learningLibraryValidity";
    private static final String ATTRIBUTE_TOOL_VERSIONS = "toolVersions";
    private static final String ATTRIBUTE_DATABASE_VERSIONS = "dbVersions";
    private static final String FORWARD_SUCCESS = "toolcontentlist";
    private static final String FORWARD_ERROR = "error";
    private static final String ACTION_ENABLE = "enable";
    private static final String ACTION_DISABLE = "disable";
    private static final String QUERY_DATABASE_VERSIONS = "select system_name, patch_level from patches";
    private static ILearningDesignService learningDesignService;
    private static IUserManagementService userManagementService;
    private static DataSource dataSource;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!request.isUserInRole("SYSADMIN") && !request.isUserInRole("AUTHOR ADMIN")) {
            request.setAttribute(ATTRIBUTE_ERROR_NAME, (Object)"ToolContentListAction");
            request.setAttribute(ATTRIBUTE_ERROR_MESSAGE, (Object)AdminServiceProxy.getMessageService(this.getServlet().getServletContext()).getMessage("error.authorisation"));
            return mapping.findForward(FORWARD_ERROR);
        }
        String param = request.getParameter(PARAM_ACTION);
        if (StringUtils.equals((String)param, (String)ACTION_ENABLE)) {
            if (!this.checkPriviledge(request)) return mapping.findForward(FORWARD_ERROR);
            this.enableLibrary(mapping, form, request, response);
        } else if (StringUtils.equals((String)param, (String)ACTION_DISABLE)) {
            if (!this.checkPriviledge(request)) return mapping.findForward(FORWARD_ERROR);
            this.disableLibrary(mapping, form, request, response);
        }
        ArrayList learningLibraryDTOs = this.getLearningDesignService().getAllLearningLibraryDetails(false, this.getUserLanguage());
        HashMap<Long, Boolean> learningLibraryValidity = new HashMap<Long, Boolean>(learningLibraryDTOs.size());
        ArrayList<LibraryActivityDTO> toolLibrary = this.filterMultipleToolEntries(learningLibraryDTOs, learningLibraryValidity);
        request.setAttribute(ATTRIBUTE_LIBRARY, toolLibrary);
        request.setAttribute(ATTRIBUTE_VALIDITY, learningLibraryValidity);
        HashMap<Long, String> toolVersions = new HashMap<Long, String>();
        List tools = this.getUserManagementService().findAll(Tool.class);
        for (Tool tool : tools) {
            toolVersions.put(tool.getToolId(), tool.getToolVersion());
        }
        request.setAttribute(ATTRIBUTE_TOOL_VERSIONS, toolVersions);
        HashMap<String, Integer> dbVersions = new HashMap<String, Integer>();
        Connection conn = this.getDataSource().getConnection();
        PreparedStatement query = conn.prepareStatement(QUERY_DATABASE_VERSIONS);
        ResultSet results = query.executeQuery();
        while (results.next()) {
            dbVersions.put(results.getString("system_name"), results.getInt("patch_level"));
        }
        request.setAttribute(ATTRIBUTE_DATABASE_VERSIONS, dbVersions);
        return mapping.findForward(FORWARD_SUCCESS);
    }

    private ArrayList<LibraryActivityDTO> filterMultipleToolEntries(List<LearningLibraryDTO> learningLibraryDTOs, HashMap<Long, Boolean> learningLibraryValidity) {
        ArrayList<LibraryActivityDTO> activeTools = new ArrayList<LibraryActivityDTO>();
        ArrayList<LibraryActivityDTO> activeCombinedTools = new ArrayList<LibraryActivityDTO>();
        for (LearningLibraryDTO learningLibraryDTO : learningLibraryDTOs) {
            learningLibraryValidity.put(learningLibraryDTO.getLearningLibraryID(), learningLibraryDTO.getValidFlag());
            for (LibraryActivityDTO template : learningLibraryDTO.getTemplateActivities()) {
                if (template.getLearningLibraryID() == null) continue;
                if (template.getToolContentID() == null) {
                    if (this.toolExists(template, activeCombinedTools)) continue;
                    activeCombinedTools.add(template);
                    continue;
                }
                if (this.toolExists(template, activeTools)) continue;
                activeTools.add(template);
            }
        }
        activeTools.addAll(activeCombinedTools);
        return activeTools;
    }

    private boolean toolExists(LibraryActivityDTO newItem, ArrayList<LibraryActivityDTO> list) {
        for (LibraryActivityDTO libraryActivityDTO : list) {
            if (!newItem.getLearningLibraryID().equals(libraryActivityDTO.getLearningLibraryID())) continue;
            return true;
        }
        return false;
    }

    private String getUserLanguage() {
        HttpSession ss = SessionManager.getSession();
        UserDTO user = (UserDTO)ss.getAttribute("user");
        return user == null ? "" : user.getLocaleLanguage();
    }

    private boolean checkPriviledge(HttpServletRequest request) {
        if (!this.getUserManagementService().isUserSysAdmin()) {
            request.setAttribute(ATTRIBUTE_ERROR_NAME, (Object)"ToolContentListAction");
            request.setAttribute(ATTRIBUTE_ERROR_MESSAGE, (Object)AdminServiceProxy.getMessageService(this.getServlet().getServletContext()).getMessage("error.no.sysadmin.priviledge"));
            return false;
        }
        return true;
    }

    private void disableLibrary(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Long learningLibraryId = WebUtil.readLongParam((HttpServletRequest)request, (String)PARAM_LIBRARY_ID, (boolean)false);
        ILearningDesignService ldService = this.getLearningDesignService();
        ldService.setValid(learningLibraryId, false);
    }

    private void enableLibrary(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Long learningLibraryId = WebUtil.readLongParam((HttpServletRequest)request, (String)PARAM_LIBRARY_ID, (boolean)false);
        ILearningDesignService ldService = this.getLearningDesignService();
        ldService.setValid(learningLibraryId, true);
    }

    private ILearningDesignService getLearningDesignService() {
        if (learningDesignService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            learningDesignService = (ILearningDesignService)ctx.getBean("learningDesignService");
        }
        return learningDesignService;
    }

    private IUserManagementService getUserManagementService() {
        if (userManagementService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            userManagementService = (IUserManagementService)ctx.getBean("userManagementService");
        }
        return userManagementService;
    }

    private DataSource getDataSource() {
        if (dataSource == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            dataSource = (DataSource)ctx.getBean("dataSource");
        }
        return dataSource;
    }
}

