/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.admin.web;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TimeZone;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;
import org.lamsfoundation.lams.admin.service.AdminServiceProxy;
import org.lamsfoundation.lams.admin.web.dto.UserOrgRoleDTO;
import org.lamsfoundation.lams.themes.Theme;
import org.lamsfoundation.lams.themes.service.IThemeService;
import org.lamsfoundation.lams.timezone.Timezone;
import org.lamsfoundation.lams.timezone.dto.TimezoneDTO;
import org.lamsfoundation.lams.timezone.service.ITimezoneService;
import org.lamsfoundation.lams.timezone.util.TimezoneDTOComparator;
import org.lamsfoundation.lams.usermanagement.AuthenticationMethod;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.OrganisationState;
import org.lamsfoundation.lams.usermanagement.OrganisationType;
import org.lamsfoundation.lams.usermanagement.SupportedLocale;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.UserOrganisation;
import org.lamsfoundation.lams.usermanagement.UserOrganisationRole;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.LanguageUtil;
import org.lamsfoundation.lams.util.MessageService;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.action.LamsDispatchAction;

public class UserAction
extends LamsDispatchAction {
    private static Logger log = Logger.getLogger(UserAction.class);
    private IUserManagementService service;
    private MessageService messageService;
    private static IThemeService themeService;
    private static ITimezoneService timezoneService;
    private static List<SupportedLocale> locales;
    private static List<AuthenticationMethod> authenticationMethods;

    private void initServices() {
        if (this.service == null) {
            this.service = AdminServiceProxy.getService(this.getServlet().getServletContext());
        }
        if (this.messageService == null) {
            this.messageService = AdminServiceProxy.getMessageService(this.getServlet().getServletContext());
        }
        if (themeService == null) {
            themeService = AdminServiceProxy.getThemeService(this.getServlet().getServletContext());
        }
        if (timezoneService == null) {
            timezoneService = AdminServiceProxy.getTimezoneService(this.getServlet().getServletContext());
        }
    }

    public ActionForward edit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.initServices();
        if (locales == null) {
            locales = this.service.findAll(SupportedLocale.class);
            Collections.sort(locales);
        }
        if (authenticationMethods == null) {
            authenticationMethods = this.service.findAll(AuthenticationMethod.class);
        }
        DynaActionForm userForm = (DynaActionForm)form;
        Integer orgId = WebUtil.readIntParam((HttpServletRequest)request, (String)"orgId", (boolean)true);
        Integer userId = WebUtil.readIntParam((HttpServletRequest)request, (String)"userId", (boolean)true);
        List cssThemes = themeService.getAllCSSThemes();
        request.setAttribute("cssThemes", (Object)cssThemes);
        List flashThemes = themeService.getAllFlashThemes();
        request.setAttribute("flashThemes", (Object)flashThemes);
        Theme defaultCSSTheme = themeService.getDefaultCSSTheme();
        for (Theme theme : cssThemes) {
            if (!theme.getThemeId().equals(defaultCSSTheme.getThemeId())) continue;
            userForm.set("userCSSTheme", (Object)theme.getThemeId());
            break;
        }
        Theme defaultFlashTheme = themeService.getDefaultFlashTheme();
        for (Theme theme : flashThemes) {
            if (!theme.getThemeId().equals(defaultFlashTheme.getThemeId())) continue;
            userForm.set("userFlashTheme", (Object)theme.getThemeId());
            break;
        }
        Organisation org = null;
        Boolean canEdit = this.service.isUserGlobalGroupAdmin();
        if (orgId != null) {
            org = (Organisation)this.service.findById(Organisation.class, (Serializable)orgId);
            if (!canEdit.booleanValue()) {
                OrganisationType orgType = org.getOrganisationType();
                Integer orgIdOfCourse = orgType.getOrganisationTypeId().equals(OrganisationType.CLASS_TYPE) ? org.getParentOrganisation().getOrganisationId() : orgId;
                User requestor = this.service.getUserByLogin(request.getRemoteUser());
                if (this.service.isUserInRole(requestor.getUserId(), orgIdOfCourse, "GROUP ADMIN") || this.service.isUserInRole(requestor.getUserId(), orgIdOfCourse, "GROUP MANAGER")) {
                    Organisation course = (Organisation)this.service.findById(Organisation.class, (Serializable)orgIdOfCourse);
                    canEdit = course.getCourseAdminCanAddNewUsers();
                }
            }
        }
        if (!canEdit.booleanValue() && !request.isUserInRole("SYSADMIN")) {
            request.setAttribute("errorName", (Object)"UserAction");
            request.setAttribute("errorMessage", (Object)this.messageService.getMessage("error.authorisation"));
            return mapping.findForward("error");
        }
        if (userId != null && userId != 0) {
            User user = (User)this.service.findById(User.class, (Serializable)userId);
            log.debug((Object)("got userid to edit: " + userId));
            BeanUtils.copyProperties((Object)userForm, (Object)user);
            userForm.set("password", null);
            SupportedLocale locale = user.getLocale();
            userForm.set("localeId", (Object)locale.getLocaleId());
            AuthenticationMethod authenticationMethod = user.getAuthenticationMethod();
            userForm.set("authenticationMethodId", (Object)authenticationMethod.getAuthenticationMethodId());
            request.setAttribute("userOrgRoles", this.getUserOrgRoles(user));
            request.setAttribute("globalRoles", (Object)this.getGlobalRoles(user));
            Long userSelectedCSSTheme = null;
            if (user.getHtmlTheme() != null) {
                for (Theme theme : cssThemes) {
                    if (theme.getThemeId() != user.getHtmlTheme().getThemeId()) continue;
                    userSelectedCSSTheme = theme.getThemeId();
                    break;
                }
            }
            if (userSelectedCSSTheme == null) {
                userSelectedCSSTheme = themeService.getDefaultCSSTheme().getThemeId();
            }
            userForm.set("userCSSTheme", (Object)userSelectedCSSTheme);
            Long userSelectedFlashTheme = null;
            if (user.getHtmlTheme() != null) {
                for (Theme theme : flashThemes) {
                    if (theme.getThemeId() != user.getFlashTheme().getThemeId()) continue;
                    userSelectedFlashTheme = theme.getThemeId();
                    break;
                }
            }
            if (userSelectedFlashTheme == null) {
                userSelectedFlashTheme = themeService.getDefaultFlashTheme().getThemeId();
            }
            userForm.set("userFlashTheme", (Object)userSelectedFlashTheme);
        } else {
            try {
                SupportedLocale locale = LanguageUtil.getDefaultLocale();
                userForm.set("localeId", (Object)locale.getLocaleId());
            }
            catch (Exception e) {
                log.debug((Object)e);
            }
        }
        userForm.set("orgId", (Object)(org == null ? null : org.getOrganisationId()));
        List availableTimeZones = timezoneService.getDefaultTimezones();
        TreeSet<TimezoneDTO> timezoneDtos = new TreeSet<TimezoneDTO>((Comparator<TimezoneDTO>)new TimezoneDTOComparator());
        for (Timezone availableTimeZone : availableTimeZones) {
            String timezoneId = availableTimeZone.getTimezoneId();
            TimezoneDTO timezoneDto = new TimezoneDTO();
            timezoneDto.setTimeZoneId(timezoneId);
            timezoneDto.setDisplayName(TimeZone.getTimeZone(timezoneId).getDisplayName());
            timezoneDtos.add(timezoneDto);
        }
        request.setAttribute("timezoneDtos", timezoneDtos);
        if (org != null) {
            request.setAttribute("orgName", (Object)org.getName());
            Organisation parentOrg = org.getParentOrganisation();
            if (parentOrg != null && !parentOrg.equals((Object)this.service.getRootOrganisation())) {
                request.setAttribute("pOrgId", (Object)parentOrg.getOrganisationId());
                request.setAttribute("parentName", (Object)parentOrg.getName());
            }
        }
        request.setAttribute("locales", locales);
        request.setAttribute("authenticationMethods", authenticationMethods);
        return mapping.findForward("user");
    }

    private UserOrgRoleDTO getGlobalRoles(User user) {
        this.initServices();
        UserOrganisation uo = this.service.getUserOrganisation(user.getUserId(), this.service.getRootOrganisation().getOrganisationId());
        if (uo == null) {
            return null;
        }
        UserOrgRoleDTO uorDTO = new UserOrgRoleDTO();
        ArrayList<String> roles = new ArrayList<String>();
        for (Object uor : uo.getUserOrganisationRoles()) {
            roles.add(((UserOrganisationRole)uor).getRole().getName());
        }
        Collections.sort(roles);
        uorDTO.setOrgName(uo.getOrganisation().getName());
        uorDTO.setRoles(roles);
        return uorDTO;
    }

    private List<UserOrgRoleDTO> getUserOrgRoles(User user) {
        this.initServices();
        ArrayList<UserOrgRoleDTO> uorDTOs = new ArrayList<UserOrgRoleDTO>();
        List uos = this.service.getUserOrganisationsForUserByTypeAndStatus(user.getLogin(), OrganisationType.COURSE_TYPE, OrganisationState.ACTIVE);
        for (UserOrganisation uo : uos) {
            UserOrgRoleDTO uorDTO = new UserOrgRoleDTO();
            ArrayList<String> roles = new ArrayList<String>();
            for (Object uor : uo.getUserOrganisationRoles()) {
                roles.add(((UserOrganisationRole)uor).getRole().getName());
            }
            Collections.sort(roles);
            uorDTO.setOrgName(uo.getOrganisation().getName());
            uorDTO.setRoles(roles);
            ArrayList<UserOrgRoleDTO> childDTOs = new ArrayList<UserOrgRoleDTO>();
            List childuos = this.service.getUserOrganisationsForUserByTypeAndStatusAndParent(user.getLogin(), OrganisationType.CLASS_TYPE, OrganisationState.ACTIVE, uo.getOrganisation().getOrganisationId());
            for (UserOrganisation childuo : childuos) {
                UserOrgRoleDTO childDTO = new UserOrgRoleDTO();
                ArrayList<String> childroles = new ArrayList<String>();
                for (Object uor : childuo.getUserOrganisationRoles()) {
                    childroles.add(((UserOrganisationRole)uor).getRole().getName());
                }
                Collections.sort(childroles);
                childDTO.setOrgName(childuo.getOrganisation().getName());
                childDTO.setRoles(childroles);
                childDTOs.add(childDTO);
            }
            uorDTO.setChildDTOs(childDTOs);
            uorDTOs.add(uorDTO);
        }
        return uorDTOs;
    }

    public ActionForward remove(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.initServices();
        if (!request.isUserInRole("SYSADMIN") && !this.service.isUserGlobalGroupAdmin()) {
            request.setAttribute("errorName", (Object)"UserAction");
            request.setAttribute("errorMessage", (Object)this.messageService.getMessage("error.authorisation"));
            return mapping.findForward("error");
        }
        Integer orgId = WebUtil.readIntParam((HttpServletRequest)request, (String)"orgId", (boolean)true);
        Integer userId = WebUtil.readIntParam((HttpServletRequest)request, (String)"userId");
        User user = (User)this.service.findById(User.class, (Serializable)userId);
        Boolean hasData = this.service.userHasData(user);
        request.setAttribute("method", (Object)(hasData != false ? "disable" : "delete"));
        request.setAttribute("orgId", (Object)orgId);
        request.setAttribute("userId", (Object)userId);
        return mapping.findForward("remove");
    }

    public ActionForward disable(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.initServices();
        if (!request.isUserInRole("SYSADMIN") && !this.service.isUserGlobalGroupAdmin()) {
            request.setAttribute("errorName", (Object)"UserAction");
            request.setAttribute("errorMessage", (Object)this.messageService.getMessage("error.authorisation"));
            return mapping.findForward("error");
        }
        Integer orgId = WebUtil.readIntParam((HttpServletRequest)request, (String)"orgId", (boolean)true);
        Integer userId = WebUtil.readIntParam((HttpServletRequest)request, (String)"userId");
        this.service.disableUser(userId);
        Object[] args = new String[]{userId.toString()};
        String message = this.messageService.getMessage("audit.user.disable", args);
        AdminServiceProxy.getAuditService(this.getServlet().getServletContext()).log("admin", message);
        if (orgId == null || orgId == 0) {
            return mapping.findForward("usersearch");
        }
        request.setAttribute("org", (Object)orgId);
        return mapping.findForward("userlist");
    }

    public ActionForward delete(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.initServices();
        if (!request.isUserInRole("SYSADMIN") && !this.service.isUserGlobalGroupAdmin()) {
            request.setAttribute("errorName", (Object)"UserAction");
            request.setAttribute("errorMessage", (Object)this.messageService.getMessage("error.authorisation"));
            return mapping.findForward("error");
        }
        Integer orgId = WebUtil.readIntParam((HttpServletRequest)request, (String)"orgId", (boolean)true);
        Integer userId = WebUtil.readIntParam((HttpServletRequest)request, (String)"userId");
        try {
            this.service.removeUser(userId);
        }
        catch (Exception e) {
            request.setAttribute("errorName", (Object)"UserAction");
            request.setAttribute("errorMessage", (Object)e.getMessage());
            return mapping.findForward("error");
        }
        Object[] args = new String[]{userId.toString()};
        String message = this.messageService.getMessage("audit.user.delete", args);
        AdminServiceProxy.getAuditService(this.getServlet().getServletContext()).log("admin", message);
        if (orgId == null || orgId == 0) {
            return mapping.findForward("usersearch");
        }
        request.setAttribute("org", (Object)orgId);
        return mapping.findForward("userlist");
    }

    public ActionForward enable(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.initServices();
        if (!request.isUserInRole("SYSADMIN") && !this.service.isUserGlobalGroupAdmin()) {
            request.setAttribute("errorName", (Object)"UserAction");
            request.setAttribute("errorMessage", (Object)this.messageService.getMessage("error.authorisation"));
            return mapping.findForward("error");
        }
        Integer userId = WebUtil.readIntParam((HttpServletRequest)request, (String)"userId", (boolean)true);
        User user = (User)this.service.findById(User.class, (Serializable)userId);
        log.debug((Object)("enabling user: " + userId));
        user.setDisabledFlag(Boolean.valueOf(false));
        this.service.save((Object)user);
        return mapping.findForward("disabledlist");
    }
}

