/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.admin.web;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;
import org.lamsfoundation.lams.admin.service.AdminServiceProxy;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.Role;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.UserOrganisation;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;

public class UserOrgSaveAction
extends Action {
    private static Logger log = Logger.getLogger(UserOrgSaveAction.class);
    private static IUserManagementService service;
    private List<Role> rolelist;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DynaActionForm userOrgForm = (DynaActionForm)form;
        Integer orgId = (Integer)userOrgForm.get("orgId");
        request.setAttribute("org", (Object)orgId);
        if (this.isCancelled(request)) {
            return mapping.findForward("userlist");
        }
        service = AdminServiceProxy.getService(this.getServlet().getServletContext());
        if (this.rolelist == null) {
            this.rolelist = service.findAll(Role.class);
        }
        Organisation organisation = (Organisation)service.findById(Organisation.class, (Serializable)orgId);
        Set uos = organisation.getUserOrganisations();
        String[] userIds = (String[])userOrgForm.get("userIds");
        List<String> userIdList = Arrays.asList(userIds);
        log.debug((Object)("new user membership of orgId=" + orgId + " will be: " + userIdList));
        Iterator iter = uos.iterator();
        while (iter.hasNext()) {
            UserOrganisation uo = (UserOrganisation)iter.next();
            Integer userId = uo.getUser().getUserId();
            if (userIdList.indexOf(userId.toString()) >= 0) continue;
            User user = (User)service.findById(User.class, (Serializable)userId);
            Set userUos = user.getUserOrganisations();
            userUos.remove(uo);
            user.setUserOrganisations(userUos);
            iter.remove();
            log.debug((Object)("removed userId=" + userId + " from orgId=" + orgId));
            service.deleteChildUserOrganisations(uo.getUser(), uo.getOrganisation());
        }
        ArrayList<UserOrganisation> newUserOrganisations = new ArrayList<UserOrganisation>();
        for (int i = 0; i < userIdList.size(); ++i) {
            Integer userId = new Integer(userIdList.get(i));
            Iterator iter2 = uos.iterator();
            Boolean alreadyInOrg = false;
            while (iter2.hasNext()) {
                UserOrganisation uo = (UserOrganisation)iter2.next();
                if (!uo.getUser().getUserId().equals(userId)) continue;
                alreadyInOrg = true;
                break;
            }
            if (alreadyInOrg.booleanValue()) continue;
            User user = (User)service.findById(User.class, (Serializable)userId);
            UserOrganisation uo = new UserOrganisation(user, organisation);
            newUserOrganisations.add(uo);
        }
        organisation.setUserOrganisations(uos);
        service.save((Object)organisation);
        if (newUserOrganisations.isEmpty()) {
            log.debug((Object)("no new users to add to orgId=" + orgId));
            return mapping.findForward("userlist");
        }
        request.setAttribute("roles", (Object)service.filterRoles(this.rolelist, Boolean.valueOf(request.isUserInRole("SYSADMIN")), organisation.getOrganisationType()));
        request.setAttribute("newUserOrganisations", newUserOrganisations);
        request.setAttribute("orgId", (Object)orgId);
        return mapping.findForward("userorgrole");
    }
}

