/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.admin.web;

import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.action.DynaActionForm;
import org.lamsfoundation.lams.admin.service.AdminServiceProxy;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.OrganisationType;
import org.lamsfoundation.lams.usermanagement.Role;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.UserOrganisation;
import org.lamsfoundation.lams.usermanagement.UserOrganisationRole;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.MessageService;
import org.lamsfoundation.lams.util.WebUtil;

public class UserRolesAction
extends Action {
    private static Logger log = Logger.getLogger(UserRolesAction.class);
    private static IUserManagementService service;
    private static MessageService messageService;
    private static List<Role> rolelist;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        service = AdminServiceProxy.getService(this.getServlet().getServletContext());
        messageService = AdminServiceProxy.getMessageService(this.getServlet().getServletContext());
        if (rolelist == null) {
            rolelist = service.findAll(Role.class);
            Collections.sort(rolelist);
        }
        ActionMessages errors = new ActionMessages();
        DynaActionForm userRolesForm = (DynaActionForm)form;
        Integer orgId = WebUtil.readIntParam((HttpServletRequest)request, (String)"orgId", (boolean)true);
        Integer userId = WebUtil.readIntParam((HttpServletRequest)request, (String)"userId", (boolean)true);
        if (orgId == null) {
            orgId = (Integer)request.getAttribute("orgId");
        }
        if (orgId == null) {
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("error.org.invalid"));
            this.saveErrors(request, errors);
            return mapping.findForward("userrole");
        }
        if (userId == null || userId == 0) {
            userId = (Integer)request.getAttribute("userId");
        }
        if (userId == null) {
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("error.userid.invalid"));
            this.saveErrors(request, errors);
            return mapping.findForward("userrole");
        }
        log.debug((Object)("editing roles for userId: " + userId + " and orgId: " + orgId));
        Organisation org = (Organisation)service.findById(Organisation.class, (Serializable)orgId);
        User user = (User)service.findById(User.class, (Serializable)userId);
        OrganisationType orgType = org.getOrganisationType();
        Integer orgIdOfCourse = orgType.getOrganisationTypeId().equals(OrganisationType.CLASS_TYPE) ? org.getParentOrganisation().getOrganisationId() : orgId;
        Boolean isSysadmin = request.isUserInRole("SYSADMIN");
        User requestor = service.getUserByLogin(request.getRemoteUser());
        Integer rootOrgId = service.getRootOrganisation().getOrganisationId();
        Boolean requestorHasRole = service.isUserInRole(requestor.getUserId(), orgIdOfCourse, "GROUP MANAGER") || service.isUserInRole(requestor.getUserId(), orgIdOfCourse, "GROUP ADMIN") && !rootOrgId.equals(orgId) || service.isUserGlobalGroupAdmin() && !rootOrgId.equals(orgId);
        if (!requestorHasRole.booleanValue() && !isSysadmin.booleanValue()) {
            request.setAttribute("errorName", (Object)"UserRolesAction");
            request.setAttribute("errorMessage", (Object)messageService.getMessage("error.authorisation"));
            return mapping.findForward("error");
        }
        userRolesForm.set("userId", (Object)userId);
        userRolesForm.set("orgId", (Object)org.getOrganisationId());
        request.setAttribute("rolelist", (Object)service.filterRoles(rolelist, isSysadmin, orgType));
        request.setAttribute("login", (Object)user.getLogin());
        request.setAttribute("fullName", (Object)user.getFullName());
        request.setAttribute("orgName", (Object)org.getName());
        Organisation parentOrg = org.getParentOrganisation();
        if (parentOrg != null && !parentOrg.equals((Object)service.getRootOrganisation())) {
            request.setAttribute("pOrgId", (Object)parentOrg.getOrganisationId());
            request.setAttribute("parentName", (Object)parentOrg.getName());
        }
        String[] roles = null;
        UserOrganisation uo = service.getUserOrganisation(userId, orgId);
        if (uo != null) {
            Iterator iter2 = uo.getUserOrganisationRoles().iterator();
            roles = new String[uo.getUserOrganisationRoles().size()];
            int i = 0;
            while (iter2.hasNext()) {
                UserOrganisationRole uor = (UserOrganisationRole)iter2.next();
                roles[i] = uor.getRole().getRoleId().toString();
                log.debug((Object)("got roleid: " + roles[i]));
                ++i;
            }
        } else {
            ActionMessages messages = new ActionMessages();
            messages.add("roles", new ActionMessage("msg.add.to.org", (Object)org.getName()));
            this.saveMessages(request, messages);
        }
        userRolesForm.set("roles", (Object)roles);
        return mapping.findForward("userrole");
    }
}

