/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.admin.web;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.action.DynaActionForm;
import org.lamsfoundation.lams.admin.service.AdminServiceProxy;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.Role;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;

public class UserRolesSaveAction
extends Action {
    private static Logger log = Logger.getLogger(UserRolesSaveAction.class);
    private static IUserManagementService service;
    private static List<Role> rolelist;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        service = AdminServiceProxy.getService(this.getServlet().getServletContext());
        if (rolelist == null) {
            rolelist = service.findAll(Role.class);
            Collections.sort(rolelist);
        }
        ActionMessages errors = new ActionMessages();
        DynaActionForm userRolesForm = (DynaActionForm)form;
        Integer orgId = (Integer)userRolesForm.get("orgId");
        Integer userId = (Integer)userRolesForm.get("userId");
        String[] roles = (String[])userRolesForm.get("roles");
        request.setAttribute("org", (Object)orgId);
        if (this.isCancelled(request)) {
            return mapping.findForward("userlist");
        }
        log.debug((Object)("userId: " + userId + ", orgId: " + orgId + " will have " + roles.length + " roles"));
        Organisation org = (Organisation)service.findById(Organisation.class, (Serializable)orgId);
        User user = (User)service.findById(User.class, (Serializable)userId);
        if (roles.length < 1) {
            errors.add("roles", new ActionMessage("error.roles.empty"));
            this.saveErrors(request, errors);
            request.setAttribute("rolelist", (Object)service.filterRoles(rolelist, Boolean.valueOf(request.isUserInRole("SYSADMIN")), org.getOrganisationType()));
            request.setAttribute("login", (Object)user.getLogin());
            request.setAttribute("fullName", (Object)user.getFullName());
            return mapping.findForward("userroles");
        }
        service.setRolesForUserOrganisation(user, orgId, Arrays.asList(roles));
        return mapping.findForward("userlist");
    }
}

