/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.admin.web.action;

import java.io.File;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.action.DynaActionForm;
import org.lamsfoundation.lams.admin.service.AdminServiceProxy;
import org.lamsfoundation.lams.util.FileUtil;
import org.lamsfoundation.lams.util.MessageService;
import org.lamsfoundation.lams.util.WebUtil;

public class CleanupTempFilesAction
extends Action {
    private static Logger log = Logger.getLogger(CleanupTempFilesAction.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!request.isUserInRole("SYSADMIN")) {
            request.setAttribute("errorName", (Object)"CleanupTempFilesAction");
            request.setAttribute("errorMessage", (Object)AdminServiceProxy.getMessageService(this.getServlet().getServletContext()).getMessage("error.need.sysadmin"));
            return mapping.findForward("error");
        }
        if (this.isCancelled(request)) {
            return mapping.findForward("sysadmin");
        }
        String action = WebUtil.readStrParam((HttpServletRequest)request, (String)"action", (boolean)true);
        if (action != null && StringUtils.equals((String)action, (String)"refresh")) {
            return this.refresh(mapping, form, request, response);
        }
        ActionMessages errors = new ActionMessages();
        DynaActionForm dynaForm = (DynaActionForm)form;
        Integer numDays = (Integer)dynaForm.get("numDays");
        if (numDays != null) {
            if (numDays >= 0) {
                int filesDeleted = FileUtil.cleanupOldFiles((File[])FileUtil.getOldTempFiles((int)numDays));
                MessageService messageService = AdminServiceProxy.getMessageService(this.getServlet().getServletContext());
                Object[] args = new String[]{new Integer(filesDeleted).toString()};
                request.setAttribute("filesDeleted", (Object)messageService.getMessage("msg.cleanup.files.deleted", args));
            } else {
                errors.add("numDays", new ActionMessage("error.non.negative.number.required"));
            }
        } else {
            dynaForm.set("numDays", (Object)new Integer(1));
        }
        return mapping.findForward("cleanup");
    }

    public ActionForward refresh(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        File[] oldFiles = FileUtil.getOldTempFiles((int)0);
        long zipTotal = 0L;
        long tmpTotal = 0L;
        if (oldFiles != null) {
            for (int i = 0; i < oldFiles.length; ++i) {
                if (oldFiles[i].getName().startsWith("lamszip_")) {
                    zipTotal += FileUtil.calculateFileSize((File)oldFiles[i]);
                    continue;
                }
                if (!oldFiles[i].getName().startsWith("lamstmp_")) continue;
                tmpTotal += FileUtil.calculateFileSize((File)oldFiles[i]);
            }
        }
        request.setAttribute("zipTotal", (Object)(zipTotal / 1024L));
        request.setAttribute("tmpTotal", (Object)(tmpTotal / 1024L));
        DynaActionForm dynaForm = (DynaActionForm)form;
        Integer numDays = (Integer)dynaForm.get("numDays");
        if (numDays == null) {
            dynaForm.set("numDays", (Object)new Integer(1));
        }
        return mapping.findForward("cleanup");
    }
}

