/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.admin.web.action;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.lamsfoundation.lams.admin.service.AdminServiceProxy;
import org.lamsfoundation.lams.lesson.service.ILessonService;
import org.lamsfoundation.lams.monitoring.service.IMonitoringService;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.OrganisationState;
import org.lamsfoundation.lams.usermanagement.OrganisationType;
import org.lamsfoundation.lams.usermanagement.exception.UserAccessDeniedException;
import org.lamsfoundation.lams.usermanagement.exception.UserException;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.WebUtil;

public class CloneLessonsAction
extends Action {
    private static final Logger log = Logger.getLogger(CloneLessonsAction.class);
    private static IUserManagementService userManagementService;
    private static ILessonService lessonService;
    private static IMonitoringService monitoringService;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws UserAccessDeniedException {
        if (!request.isUserInRole("SYSADMIN")) {
            throw new UserAccessDeniedException();
        }
        ArrayList<String> errors = new ArrayList<String>();
        try {
            userManagementService = AdminServiceProxy.getService(this.getServlet().getServletContext());
            String method = WebUtil.readStrParam((HttpServletRequest)request, (String)"method", (boolean)true);
            if (StringUtils.equals((String)method, (String)"getGroups")) {
                return this.getGroups(mapping, form, request, response);
            }
            if (StringUtils.equals((String)method, (String)"getSubgroups")) {
                return this.getSubgroups(mapping, form, request, response);
            }
            if (StringUtils.equals((String)method, (String)"availableLessons")) {
                return this.availableLessons(mapping, form, request, response);
            }
            if (StringUtils.equals((String)method, (String)"selectStaff")) {
                return this.selectStaff(mapping, form, request, response);
            }
            if (StringUtils.equals((String)method, (String)"selectLearners")) {
                return this.selectLearners(mapping, form, request, response);
            }
            if (StringUtils.equals((String)method, (String)"clone")) {
                return this.clone(mapping, form, request, response);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            errors.add(e.getMessage());
        }
        request.setAttribute("errors", errors);
        Integer groupId = WebUtil.readIntParam((HttpServletRequest)request, (String)"groupId", (boolean)false);
        request.setAttribute("org", userManagementService.findById(Organisation.class, (Serializable)groupId));
        return mapping.findForward("start");
    }

    public ActionForward getGroups(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        response.addHeader("Cache-Control", "no-cache");
        response.addHeader("content-type", "text/html; charset=UTF-8");
        List groups = userManagementService.getOrganisationsByTypeAndStatus(OrganisationType.COURSE_TYPE, OrganisationState.ACTIVE);
        for (Object o : groups) {
            Organisation org = (Organisation)o;
            response.getWriter().println("<option value='" + org.getOrganisationId() + "'>" + org.getName() + "</option>");
        }
        return null;
    }

    public ActionForward getSubgroups(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Integer groupId = WebUtil.readIntParam((HttpServletRequest)request, (String)"groupId", (boolean)true);
        response.addHeader("Cache-Control", "no-cache");
        response.addHeader("content-type", "text/html; charset=UTF-8");
        if (groupId != null) {
            HashMap<String, Integer> properties = new HashMap<String, Integer>();
            properties.put("parentOrganisation.organisationId", groupId);
            properties.put("organisationType.organisationTypeId", OrganisationType.CLASS_TYPE);
            properties.put("organisationState.organisationStateId", OrganisationState.ACTIVE);
            response.getWriter().println("<option value=''></option>");
            List groups = userManagementService.findByProperties(Organisation.class, properties);
            for (Object o : groups) {
                Organisation org = (Organisation)o;
                response.getWriter().println("<option value='" + org.getOrganisationId() + "'>" + org.getName() + "</option>");
            }
        }
        return null;
    }

    public ActionForward availableLessons(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Integer sourceGroupId = WebUtil.readIntParam((HttpServletRequest)request, (String)"sourceGroupId", (boolean)true);
        if (sourceGroupId != null) {
            lessonService = AdminServiceProxy.getLessonService(this.getServlet().getServletContext());
            List lessons = lessonService.getLessonsByGroup(sourceGroupId);
            request.setAttribute("lessons", (Object)lessons);
        }
        response.addHeader("Cache-Control", "no-cache");
        return mapping.findForward("availableLessonsPart");
    }

    public ActionForward selectStaff(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Integer groupId = WebUtil.readIntParam((HttpServletRequest)request, (String)"groupId", (boolean)false);
        Vector monitors = userManagementService.getUsersFromOrganisationByRole(groupId, "MONITOR", false, true);
        request.setAttribute("monitors", (Object)monitors);
        response.addHeader("Cache-Control", "no-cache");
        return mapping.findForward("selectStaffPart");
    }

    public ActionForward selectLearners(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Integer groupId = WebUtil.readIntParam((HttpServletRequest)request, (String)"groupId", (boolean)false);
        Vector learners = userManagementService.getUsersFromOrganisationByRole(groupId, "LEARNER", false, true);
        request.setAttribute("learners", (Object)learners);
        response.addHeader("Cache-Control", "no-cache");
        return mapping.findForward("selectLearnersPart");
    }

    public ActionForward clone(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Integer groupId = WebUtil.readIntParam((HttpServletRequest)request, (String)"groupId", (boolean)false);
        String lessons = request.getParameter("lessons");
        String staff = request.getParameter("staff");
        String learners = request.getParameter("learners");
        Boolean addAllStaff = WebUtil.readBooleanParam((HttpServletRequest)request, (String)"addAllStaff", (boolean)false);
        Boolean addAllLearners = WebUtil.readBooleanParam((HttpServletRequest)request, (String)"addAllLearners", (boolean)false);
        String[] lessonIds = new String[]{};
        String[] staffIds = new String[]{};
        String[] learnerIds = new String[]{};
        if (StringUtils.isNotEmpty((String)lessons)) {
            lessonIds = lessons.split(",");
        }
        if (StringUtils.isNotEmpty((String)staff)) {
            staffIds = staff.split(",");
        }
        if (StringUtils.isNotEmpty((String)learners)) {
            learnerIds = learners.split(",");
        }
        monitoringService = AdminServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        int result = 0;
        Organisation group = (Organisation)userManagementService.findById(Organisation.class, (Serializable)groupId);
        if (group == null) {
            throw new UserException("Couldn't find Organisation based on id=" + groupId);
        }
        result = monitoringService.cloneLessons(lessonIds, addAllStaff, addAllLearners, staffIds, learnerIds, group);
        request.setAttribute("org", (Object)group);
        request.setAttribute("result", (Object)result);
        return mapping.findForward("result");
    }
}

