/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.admin.web.action;

import java.io.Serializable;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.lamsfoundation.lams.admin.service.AdminServiceProxy;
import org.lamsfoundation.lams.admin.web.form.EmailForm;
import org.lamsfoundation.lams.events.IEventNotificationService;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.Emailer;
import org.lamsfoundation.lams.util.MessageService;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.action.LamsDispatchAction;
import org.lamsfoundation.lams.web.session.SessionManager;

public class EmailUserAction
extends LamsDispatchAction {
    private static Logger log = Logger.getLogger(EmailUserAction.class);
    private IUserManagementService service;
    private MessageService messageService;
    private IEventNotificationService eventNotificationService;

    private void initServices() {
        if (this.service == null) {
            this.service = AdminServiceProxy.getService(this.getServlet().getServletContext());
        }
        if (this.messageService == null) {
            this.messageService = AdminServiceProxy.getMessageService(this.getServlet().getServletContext());
        }
        if (this.eventNotificationService == null) {
            this.eventNotificationService = AdminServiceProxy.getEventNotificationService(this.getServlet().getServletContext());
        }
    }

    public ActionForward composeMail(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.initServices();
        if (!request.isUserInRole("SYSADMIN") && !this.service.isUserGlobalGroupAdmin()) {
            request.setAttribute("errorName", (Object)"UserAction");
            request.setAttribute("errorMessage", (Object)this.messageService.getMessage("error.authorisation"));
            return mapping.findForward("error");
        }
        Integer userId = WebUtil.readIntParam((HttpServletRequest)request, (String)"userId");
        User user = (User)this.service.findById(User.class, (Serializable)userId);
        request.setAttribute("user", (Object)user);
        return mapping.findForward("emailuser");
    }

    public ActionForward send(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.initServices();
        if (!request.isUserInRole("SYSADMIN") && !this.service.isUserGlobalGroupAdmin()) {
            request.setAttribute("errorName", (Object)"UserAction");
            request.setAttribute("errorMessage", (Object)this.messageService.getMessage("error.authorisation"));
            return mapping.findForward("error");
        }
        EmailForm emailForm = (EmailForm)form;
        Integer userId = emailForm.getUserId();
        User user = (User)this.service.findById(User.class, (Serializable)userId);
        String subject = emailForm.getSubject();
        String body = emailForm.getBody().replaceAll("<BR>", "\n").replaceAll("\\<.*?\\>", "");
        HttpSession ss1 = SessionManager.getSession();
        UserDTO administrator = (UserDTO)ss1.getAttribute("user");
        String to = user.getEmail();
        String toPerson = user.getFirstName() + " " + user.getLastName();
        String from = administrator.getEmail();
        String fromPerson = administrator.getFirstName() + " " + administrator.getLastName();
        log.debug((Object)("Administrator " + fromPerson + " (" + from + ") " + " sent email to user " + toPerson + "( " + to + ") " + ": \n[subject] " + subject + "\n[message] " + body));
        Properties properties = new Properties();
        Emailer.send((String)subject, (String)to, (String)toPerson, (String)from, (String)fromPerson, (String)body, (Properties)properties);
        return mapping.findForward("usersearch");
    }
}

