/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.admin.web.action;

import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.lamsfoundation.lams.admin.service.AdminServiceProxy;
import org.lamsfoundation.lams.admin.web.form.ThemeForm;
import org.lamsfoundation.lams.themes.Theme;
import org.lamsfoundation.lams.themes.service.IThemeService;
import org.lamsfoundation.lams.util.CSSThemeUtil;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;
import org.lamsfoundation.lams.web.action.LamsDispatchAction;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class ThemeManagementAction
extends LamsDispatchAction {
    private static IThemeService themeService;
    private static Configuration configurationService;

    public ActionForward unspecified(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!request.isUserInRole("SYSADMIN")) {
            request.setAttribute("errorName", (Object)"RegisterAction");
            request.setAttribute("errorMessage", (Object)AdminServiceProxy.getMessageService(this.getServlet().getServletContext()).getMessage("error.authorisation"));
            return mapping.findForward("error");
        }
        if (themeService == null) {
            themeService = AdminServiceProxy.getThemeService(this.getServlet().getServletContext());
        }
        List themes = themeService.getAllThemes();
        String currentCSSTheme = Configuration.get((String)ConfigurationKeys.DEFAULT_HTML_THEME);
        String currentFlashTheme = Configuration.get((String)ConfigurationKeys.DEFAULT_FLASH_THEME);
        for (Theme theme : themes) {
            theme.setCurrentDefaultTheme(Boolean.FALSE);
            if (theme.getName().equals(currentCSSTheme) || theme.getName().equals(currentFlashTheme)) {
                theme.setCurrentDefaultTheme(Boolean.TRUE);
            }
            theme.setNotEditable(Boolean.FALSE);
            if (!theme.getName().equals(CSSThemeUtil.DEFAULT_HTML_THEME) && !theme.getName().equals(CSSThemeUtil.DEFAULT_FLASH_THEME)) continue;
            theme.setNotEditable(Boolean.TRUE);
        }
        request.setAttribute("themes", (Object)themes);
        return mapping.findForward("success");
    }

    public ActionForward addOrEditTheme(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ThemeForm themeForm = (ThemeForm)form;
        Theme theme = null;
        theme = themeForm.getId() != null && themeForm.getId() != 0L ? themeService.getTheme(themeForm.getId()) : new Theme();
        this.updateThemeFromForm(theme, themeForm);
        themeService.saveOrUpdateTheme(theme);
        if (themeForm.getCurrentDefaultTheme() != null && themeForm.getCurrentDefaultTheme().booleanValue()) {
            if (Integer.parseInt(themeForm.getType()) == 1) {
                Configuration.updateItem((String)ConfigurationKeys.DEFAULT_HTML_THEME, (String)themeForm.getName());
                this.getConfiguration().persistUpdate();
            } else {
                Configuration.updateItem((String)ConfigurationKeys.DEFAULT_FLASH_THEME, (String)themeForm.getName());
                this.getConfiguration().persistUpdate();
            }
        } else if (Integer.parseInt(themeForm.getType()) == 1) {
            String currentTheme = Configuration.get((String)ConfigurationKeys.DEFAULT_HTML_THEME);
            if (themeForm.getName().equals(currentTheme)) {
                Configuration.updateItem((String)ConfigurationKeys.DEFAULT_HTML_THEME, (String)CSSThemeUtil.DEFAULT_HTML_THEME);
                this.getConfiguration().persistUpdate();
            }
        } else {
            String currentTheme = Configuration.get((String)ConfigurationKeys.DEFAULT_FLASH_THEME);
            if (themeForm.getName().equals(currentTheme)) {
                Configuration.updateItem((String)ConfigurationKeys.DEFAULT_FLASH_THEME, (String)CSSThemeUtil.DEFAULT_FLASH_THEME);
                this.getConfiguration().persistUpdate();
            }
        }
        themeForm.clear();
        return this.unspecified(mapping, themeForm, request, response);
    }

    public ActionForward removeTheme(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ThemeForm themeForm = (ThemeForm)form;
        if (themeForm.getId() != null) {
            themeService.removeTheme(themeForm.getId());
        }
        if (Integer.parseInt(themeForm.getType()) == 1) {
            String currentTheme = Configuration.get((String)ConfigurationKeys.DEFAULT_HTML_THEME);
            if (themeForm.getName().equals(currentTheme)) {
                Configuration.updateItem((String)ConfigurationKeys.DEFAULT_HTML_THEME, (String)CSSThemeUtil.DEFAULT_HTML_THEME);
                this.getConfiguration().persistUpdate();
            }
        } else {
            String currentTheme = Configuration.get((String)ConfigurationKeys.DEFAULT_FLASH_THEME);
            if (themeForm.getName().equals(currentTheme)) {
                Configuration.updateItem((String)ConfigurationKeys.DEFAULT_FLASH_THEME, (String)CSSThemeUtil.DEFAULT_FLASH_THEME);
                this.getConfiguration().persistUpdate();
            }
        }
        themeForm.clear();
        return this.unspecified(mapping, themeForm, request, response);
    }

    public ActionForward setAsDefault(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ThemeForm themeForm = (ThemeForm)form;
        if (themeForm.getName() != null) {
            Configuration.updateItem((String)ConfigurationKeys.DEFAULT_HTML_THEME, (String)themeForm.getName());
            this.getConfiguration().persistUpdate();
        }
        themeForm.clear();
        return this.unspecified(mapping, themeForm, request, response);
    }

    private Theme updateThemeFromForm(Theme theme, ThemeForm form) {
        theme.setName(form.getName());
        theme.setDescription(form.getDescription());
        theme.setImageDirectory(form.getImageDirectory());
        theme.setType(Integer.valueOf(Integer.parseInt(form.getType())));
        return theme;
    }

    private Configuration getConfiguration() {
        if (configurationService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            configurationService = (Configuration)ctx.getBean("configurationService");
        }
        return configurationService;
    }
}

