/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.admin.web.action;

import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;
import org.lamsfoundation.lams.admin.service.AdminServiceProxy;
import org.lamsfoundation.lams.timezone.Timezone;
import org.lamsfoundation.lams.timezone.dto.TimezoneDTO;
import org.lamsfoundation.lams.timezone.service.ITimezoneService;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.action.LamsDispatchAction;

public class TimezoneManagementAction
extends LamsDispatchAction {
    private static final String FORWARD_BACK = "sysadmin";
    private static final String FORWARD_TIMEZONE_MANAGEMENT = "timezoneManagement";
    private static final String FORWARD_SERVER_TIMEZONE_MANAGEMENT = "timezoneServerManagement";
    private static ITimezoneService timezoneService;

    public ActionForward unspecified(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        timezoneService = AdminServiceProxy.getTimezoneService(this.getServlet().getServletContext());
        List defaultTimezones = timezoneService.getDefaultTimezones();
        ArrayList<TimezoneDTO> timezoneDtos = new ArrayList<TimezoneDTO>();
        for (String availableTimezoneId : TimeZone.getAvailableIDs()) {
            boolean isSelected = defaultTimezones.contains(new Timezone(availableTimezoneId));
            TimeZone timeZone = TimeZone.getTimeZone(availableTimezoneId);
            TimezoneDTO timezoneDto = TimezoneDTO.createTimezoneDTO((TimeZone)timeZone, (boolean)isSelected);
            timezoneDtos.add(timezoneDto);
        }
        request.setAttribute("timezoneDtos", timezoneDtos);
        request.setAttribute("serverTimezone", (Object)timezoneService.getServerTimezone().getTimezoneId());
        return mapping.findForward(FORWARD_TIMEZONE_MANAGEMENT);
    }

    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.isCancelled(request)) {
            return mapping.findForward(FORWARD_BACK);
        }
        DynaActionForm timezoneForm = (DynaActionForm)form;
        String[] selectedTimezoneIds = (String[])timezoneForm.get("selected");
        ArrayList<Timezone> selectedTimezones = new ArrayList<Timezone>();
        for (String selectedTimezoneId : selectedTimezoneIds) {
            selectedTimezones.add(new Timezone(selectedTimezoneId));
        }
        timezoneService.updateTimezones(selectedTimezones);
        return mapping.findForward(FORWARD_BACK);
    }

    public ActionForward serverTimezoneManagement(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        timezoneService = AdminServiceProxy.getTimezoneService(this.getServlet().getServletContext());
        ArrayList<TimezoneDTO> timezoneDtos = new ArrayList<TimezoneDTO>();
        for (String availableTimezoneId : TimeZone.getAvailableIDs()) {
            TimeZone timeZone = TimeZone.getTimeZone(availableTimezoneId);
            TimezoneDTO timezoneDto = TimezoneDTO.createTimezoneDTO((TimeZone)timeZone, (boolean)false);
            timezoneDtos.add(timezoneDto);
        }
        request.setAttribute("timezoneDtos", timezoneDtos);
        request.setAttribute("serverTimezone", (Object)timezoneService.getServerTimezone().getTimezoneId());
        return mapping.findForward(FORWARD_SERVER_TIMEZONE_MANAGEMENT);
    }

    public ActionForward changeServerTimezone(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        timezoneService = AdminServiceProxy.getTimezoneService(this.getServlet().getServletContext());
        String timeZoneId = WebUtil.readStrParam((HttpServletRequest)request, (String)"timeZoneId");
        timezoneService.setServerTimezone(timeZoneId);
        return this.unspecified(mapping, form, request, response);
    }
}

