/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.deploy;

import org.lamsfoundation.lams.tool.deploy.DeployException;
import org.lamsfoundation.lams.tool.deploy.UpdateApplicationXmlTask;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AddWebAppToApplicationXmlTask
extends UpdateApplicationXmlTask {
    protected void updateApplicationXml(Document doc) throws DeployException {
        Element moduleElement = this.findElementWithWebURI(doc);
        if (moduleElement != null) {
            doc.getDocumentElement().removeChild(moduleElement);
        }
        moduleElement = doc.createElement("module");
        Element webElement = doc.createElement("web");
        moduleElement.appendChild(webElement);
        Element webUriElement = doc.createElement("web-uri");
        webUriElement.appendChild(doc.createTextNode(this.webUri));
        webElement.appendChild(webUriElement);
        Element contextRootElement = doc.createElement("context-root");
        contextRootElement.appendChild(doc.createTextNode(this.contextRoot));
        webElement.appendChild(contextRootElement);
        doc.getDocumentElement().appendChild(moduleElement);
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 3 || args[0] == null) {
            throw new IllegalArgumentException("Usage: AddModuleToApplicationXmlTask <lams.ear path> <module>");
        }
        try {
            System.out.println("Attempting to update " + args[0] + "/META-INF/application.xml");
            AddWebAppToApplicationXmlTask addModuleTask = new AddWebAppToApplicationXmlTask();
            addModuleTask.setLamsEarPath(args[0]);
            addModuleTask.setWebUri(args[1]);
            addModuleTask.setContextRoot(args[2]);
            addModuleTask.execute();
            System.out.println("application.xml update completed");
        }
        catch (Exception ex) {
            System.out.println("Application.xml update failed: " + ex.getMessage());
            ex.printStackTrace();
        }
    }
}

