/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.lesson.dao.hibernate;

import java.io.Serializable;
import java.util.List;
import org.hibernate.FetchMode;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Expression;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.lesson.dao.ILessonDAO;
import org.lamsfoundation.lams.usermanagement.User;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class LessonDAO
extends HibernateDaoSupport
implements ILessonDAO {
    private static final String TABLENAME = "lams_lesson";
    private static final String FIND_BY_USER = "from lams_lesson in class " + Lesson.class.getName() + " where user_id=?";

    public Lesson getLesson(Long lessonId) {
        return (Lesson)this.getHibernateTemplate().get(Lesson.class, (Serializable)lessonId);
    }

    public Lesson getLessonWithJoinFetchedProgress(final Long lessonId) {
        HibernateTemplate hibernateTemplate = new HibernateTemplate(this.getSessionFactory());
        return (Lesson)hibernateTemplate.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return session.createCriteria(Lesson.class).add((Criterion)Expression.like((String)"lessonId", (Object)lessonId)).setFetchMode("learnerProgresses", FetchMode.JOIN).uniqueResult();
            }
        });
    }

    public List getAllLessons() {
        return this.getHibernateTemplate().loadAll(Lesson.class);
    }

    public List getActiveLessonsForLearner(final User learner) {
        List lessons = null;
        HibernateTemplate hibernateTemplate = new HibernateTemplate(this.getSessionFactory());
        lessons = (List)hibernateTemplate.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query query = session.getNamedQuery("activeLessons");
                query.setInteger("userId", learner.getUserId().intValue());
                List result = query.list();
                return result;
            }
        });
        return lessons;
    }

    public List getActiveLearnerByLesson(final long lessonId) {
        List learners = null;
        HibernateTemplate hibernateTemplate = new HibernateTemplate(this.getSessionFactory());
        learners = (List)hibernateTemplate.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query query = session.getNamedQuery("activeLearners");
                query.setLong("lessonId", lessonId);
                List result = query.list();
                return result;
            }
        });
        return learners;
    }

    public void saveLesson(Lesson lesson) {
        this.getHibernateTemplate().save((Object)lesson);
    }

    public void deleteLesson(Lesson lesson) {
        this.getHibernateTemplate().delete((Object)lesson);
    }

    public void updateLesson(Lesson lesson) {
        this.getHibernateTemplate().update((Object)lesson);
    }

    public List getLessonsForUser(Integer userID) {
        List lessons = this.getHibernateTemplate().find(FIND_BY_USER, (Object)userID);
        return lessons;
    }
}

