/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.themes;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.themes.CSSStyle;
import org.lamsfoundation.lams.usermanagement.User;

public class CSSThemeVisualElement
implements Serializable {
    protected Logger log = Logger.getLogger(CSSThemeVisualElement.class);
    private Long id;
    private String name;
    private String description;
    private boolean theme;
    private CSSThemeVisualElement parentTheme;
    private Set users;
    private Set styles;
    private Set elements;

    public CSSThemeVisualElement(Long id, String name, String description, boolean theme, CSSThemeVisualElement parentTheme, Set styles, Set users, Set elements) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.theme = theme;
        this.parentTheme = parentTheme;
        this.styles = styles;
        this.users = users;
        this.elements = elements;
    }

    public CSSThemeVisualElement() {
    }

    public CSSThemeVisualElement(Long id, String name, boolean theme) {
        this.id = id;
        this.name = name;
        this.theme = theme;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isTheme() {
        return this.theme;
    }

    public void setTheme(boolean theme) {
        this.theme = theme;
    }

    public CSSStyle getStyle() {
        Set styleSet = this.getStyles();
        if (styleSet != null && styleSet.size() > 1) {
            this.log.warn((Object)("Theme/Visual element has more than one style - only one can be used. " + this));
        }
        if (styleSet.size() > 0) {
            return (CSSStyle)styleSet.iterator().next();
        }
        return null;
    }

    public void setStyle(CSSStyle style) {
        if (this.getStyles() != null) {
            this.getStyles().clear();
            this.getStyles().add(style);
        } else {
            HashSet<CSSStyle> styleSet = new HashSet<CSSStyle>();
            styleSet.add(style);
            this.setStyles(styleSet);
        }
        style.setThemeElement(this);
    }

    private Set getStyles() {
        return this.styles;
    }

    private void setStyles(Set styles) {
        this.styles = styles;
    }

    private Set getUsers() {
        return this.users;
    }

    private void setUsers(Set users) {
        this.users = users;
    }

    public void clearUsers() {
        if (this.getUsers() != null) {
            this.getUsers().clear();
        }
    }

    public void addUser(User user) {
        if (this.getUsers() == null) {
            HashSet<User> set = new HashSet<User>();
            set.add(user);
            this.setUsers(set);
        } else {
            this.getUsers().add(user);
        }
        user.setTheme(this);
    }

    public Set getElements() {
        return this.elements;
    }

    private void setElements(Set elements) {
        this.elements = elements;
    }

    public void clearElements() {
        if (this.getElements() != null) {
            this.getElements().clear();
        }
    }

    public void addElement(CSSThemeVisualElement element) {
        if (this.getElements() == null) {
            HashSet<CSSThemeVisualElement> set = new HashSet<CSSThemeVisualElement>();
            set.add(element);
            this.setElements(set);
        } else {
            this.getElements().add(element);
        }
        element.setParentTheme(this);
    }

    public CSSThemeVisualElement getParentTheme() {
        return this.parentTheme;
    }

    public void setParentTheme(CSSThemeVisualElement parentTheme) {
        this.parentTheme = parentTheme;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("id", (Object)this.getId()).append("name", (Object)this.getName()).append("description", (Object)this.getDescription()).append("is theme?", this.isTheme()).append("style", (Object)this.getStyle()).append("visual elements", (Object)this.getElements()).append("parent theme", (Object)this.getParentTheme()).toString();
    }
}

