/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.dao.hibernate;

import java.io.Serializable;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.Group;
import org.lamsfoundation.lams.tool.ToolSession;
import org.lamsfoundation.lams.tool.dao.IToolSessionDAO;
import org.lamsfoundation.lams.usermanagement.User;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class ToolSessionDAO
extends HibernateDaoSupport
implements IToolSessionDAO {
    protected static final String LOAD_NONGROUPED_TOOL_SESSION_BY_LEARNER = "from NonGroupedToolSession s where s.user = :learner and s.toolActivity = :activity";
    protected static final String LOAD_NONGROUPED_TOOL_SESSION_BY_GROUP = "from GroupedToolSession s where s.group = :group and s.toolActivity = :activity";

    public ToolSession getToolSession(Long toolSessionId) {
        return (ToolSession)this.getHibernateTemplate().get(ToolSession.class, (Serializable)toolSessionId);
    }

    public ToolSession getToolSessionByLearner(final User learner, final Activity activity) {
        HibernateTemplate hibernateTemplate = new HibernateTemplate(this.getSessionFactory());
        return (ToolSession)hibernateTemplate.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return session.createQuery(ToolSessionDAO.LOAD_NONGROUPED_TOOL_SESSION_BY_LEARNER).setEntity("learner", (Object)learner).setEntity("activity", (Object)activity).uniqueResult();
            }
        });
    }

    public ToolSession getToolSessionByGroup(final Group group, final Activity activity) {
        HibernateTemplate hibernateTemplate = new HibernateTemplate(this.getSessionFactory());
        return (ToolSession)hibernateTemplate.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return session.createQuery(ToolSessionDAO.LOAD_NONGROUPED_TOOL_SESSION_BY_GROUP).setEntity("group", (Object)group).setEntity("activity", (Object)activity).uniqueResult();
            }
        });
    }

    public void saveToolSession(ToolSession toolSession) {
        this.getHibernateTemplate().save((Object)toolSession);
    }

    public void removeToolSession(ToolSession toolSession) {
        this.getHibernateTemplate().delete((Object)toolSession);
    }

    public void updateToolSession(ToolSession toolSession) {
        this.getHibernateTemplate().update((Object)toolSession);
    }
}

