/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.usermanagement;

import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.lamsfoundation.lams.workspace.WorkspaceFolderContent;

public class WorkspaceFolder
implements Serializable {
    public static final Integer NORMAL = new Integer(1);
    public static final Integer RUN_SEQUENCES = new Integer(2);
    public static final Integer READ_ACCESS = new Integer(1);
    public static final Integer MEMBERSHIP_ACCESS = new Integer(2);
    public static final Integer OWNER_ACCESS = new Integer(3);
    public static final Integer NO_ACCESS = new Integer(4);
    private Integer workspaceFolderId;
    private String name;
    private Integer workspaceID;
    private WorkspaceFolder parentWorkspaceFolder;
    private Set workspaces;
    private Set childWorkspaceFolders;
    private Set learningDesigns;
    private Integer userID;
    private Date creationDate;
    private Date lastModifiedDate;
    private Integer workspaceFolderType;
    private Set folderContent;

    public WorkspaceFolder(String name, Integer workspaceID, Integer userID, Date creationDate, Date lastModifiedDate, Integer workspaceFolderType) {
        this.name = name;
        this.workspaceID = workspaceID;
        this.userID = userID;
        this.creationDate = creationDate;
        this.lastModifiedDate = lastModifiedDate;
        this.workspaceFolderType = workspaceFolderType;
    }

    public WorkspaceFolder(String name, Integer workspaceID, WorkspaceFolder parentWorkspaceFolder, Integer userID, Date creationDate, Date lastModifiedDate, Integer workspaceFolderType) {
        this.name = name;
        this.workspaceID = workspaceID;
        this.parentWorkspaceFolder = parentWorkspaceFolder;
        this.userID = userID;
        this.creationDate = creationDate;
        this.lastModifiedDate = lastModifiedDate;
        this.workspaceFolderType = workspaceFolderType;
    }

    public Set getLearningDesigns() {
        return this.learningDesigns;
    }

    public void setLearningDesigns(Set learningDesigns) {
        this.learningDesigns = learningDesigns;
    }

    public WorkspaceFolder(String name, WorkspaceFolder parentWorkspaceFolder, Set workspaces, Set childWorkspaceFolders) {
        this.name = name;
        this.parentWorkspaceFolder = parentWorkspaceFolder;
        this.workspaces = workspaces;
        this.childWorkspaceFolders = childWorkspaceFolders;
    }

    public WorkspaceFolder() {
    }

    public Integer getWorkspaceFolderId() {
        return this.workspaceFolderId;
    }

    public void setWorkspaceFolderId(Integer workspaceFolderId) {
        this.workspaceFolderId = workspaceFolderId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public WorkspaceFolder getParentWorkspaceFolder() {
        return this.parentWorkspaceFolder;
    }

    public void setParentWorkspaceFolder(WorkspaceFolder parentWorkspaceFolder) {
        this.parentWorkspaceFolder = parentWorkspaceFolder;
    }

    public Set getWorkspaces() {
        return this.workspaces;
    }

    public void setWorkspaces(Set workspaces) {
        this.workspaces = workspaces;
    }

    public Set getChildWorkspaceFolders() {
        return this.childWorkspaceFolders;
    }

    public void setChildWorkspaceFolders(Set childWorkspaceFolders) {
        this.childWorkspaceFolders = childWorkspaceFolders;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("workspaceFolderId", (Object)this.getWorkspaceFolderId()).toString();
    }

    public boolean equals(Object other) {
        if (!(other instanceof WorkspaceFolder)) {
            return false;
        }
        WorkspaceFolder castOther = (WorkspaceFolder)other;
        return new EqualsBuilder().append((Object)this.getWorkspaceFolderId(), (Object)castOther.getWorkspaceFolderId()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getWorkspaceFolderId()).toHashCode();
    }

    public Integer getUserID() {
        return this.userID;
    }

    public void setUserID(Integer userID) {
        this.userID = userID;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public Date getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public void setLastModifiedDate(Date lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }

    public Integer getWorkspaceFolderType() {
        return this.workspaceFolderType;
    }

    public void setWorkspaceFolderType(Integer workspaceFolderType) {
        this.workspaceFolderType = workspaceFolderType;
    }

    public Integer getWorkspaceID() {
        return this.workspaceID;
    }

    public void setWorkspaceID(Integer workspaceID) {
        this.workspaceID = workspaceID;
    }

    public boolean hasSubFolders() {
        return this.childWorkspaceFolders != null && this.childWorkspaceFolders.size() != 0;
    }

    public boolean isEmpty() {
        if (!this.hasSubFolders() && !this.hasFiles()) {
            return this.learningDesigns == null || this.learningDesigns.size() == 0;
        }
        return false;
    }

    public boolean hasFiles() {
        return this.folderContent != null && this.folderContent.size() != 0;
    }

    public Set getFolderContent() {
        return this.folderContent;
    }

    public void setFolderContent(Set folderContent) {
        this.folderContent = folderContent;
    }

    public void addFolderContent(WorkspaceFolderContent workspaceFolderContent) {
        if (this.folderContent == null) {
            this.folderContent = new HashSet();
        }
        this.folderContent.add(workspaceFolderContent);
    }
}

