/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.util;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.util.XmlFileLoader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ConfigurationLoader {
    private static Logger log = Logger.getLogger(ConfigurationLoader.class);
    public static final String ENV_CONFIG_PARAMETER = "LAMS_CONF_FILE";
    private static final String CONFIG_FILE_PATH_WINDOWS = "c:/lamsconf/lams.xml";
    private static final String CONFIG_FILE_PATH_UNIX = "/usr/local/lamsconf/lams.xml";
    private static String configFilePath;

    public static String getConfigFilePath() {
        ConfigurationLoader.setConfigFilePath();
        return configFilePath;
    }

    private static void setConfigFilePath() {
        String osName;
        String envConfigFilePath = null;
        try {
            envConfigFilePath = System.getenv(ENV_CONFIG_PARAMETER);
        }
        catch (Throwable t) {
            log.error((Object)"Fail to get LAMS_CONF_FILEfrom environment", t);
        }
        configFilePath = envConfigFilePath != null ? envConfigFilePath : ((osName = System.getProperty("os.name")).indexOf("Windows") != -1 || osName.indexOf("windows") != -1 ? CONFIG_FILE_PATH_WINDOWS : CONFIG_FILE_PATH_UNIX);
        log.debug((Object)("Loading Configuration File From: " + configFilePath));
    }

    public static Map load() {
        ConfigurationLoader.setConfigFilePath();
        Map<String, String> items = Collections.synchronizedMap(new HashMap());
        try {
            Document configureDoc = XmlFileLoader.getDocumentFromFilePath(configFilePath);
            Element root = (Element)configureDoc.getElementsByTagName("Lams").item(0);
            NodeList nodeList = root.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element ele;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1 || (ele = (Element)node).getLastChild() == null) continue;
                items.put(ele.getNodeName(), ele.getLastChild().getNodeValue());
            }
        }
        catch (IOException e) {
            log.error((Object)"===>IOExcpetion in ConfigurationLoader", (Throwable)e);
        }
        catch (SAXException e) {
            log.error((Object)"===>SAXExcpetion in ConfigurationLoader", (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            log.error((Object)"===>ParserConfigurationException in ConfigurationLoader ", (Throwable)e);
        }
        return items;
    }
}

