/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.http.Cookie;
import org.apache.log4j.Logger;

public class HttpUrlConnectionUtil {
    private static Logger log = Logger.getLogger(HttpUrlConnectionUtil.class);
    public static final int STATUS_OK = 1;
    public static final int STATUS_ERROR = -1;

    public static int writeResponseToFile(String urlToConnectTo, String directoryToStoreFile, String filename, Cookie[] cookies) throws MalformedURLException, FileNotFoundException, IOException {
        int statusCode;
        int status;
        String absoluteFilePath = directoryToStoreFile + File.separator + filename;
        URL url = new URL(urlToConnectTo);
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        con.setRequestProperty("Cookie", HttpUrlConnectionUtil.getCookieString(cookies));
        if (log.isDebugEnabled()) {
            log.debug((Object)("A connection has been established with " + urlToConnectTo));
        }
        if ((status = HttpUrlConnectionUtil.getStatus(statusCode = con.getResponseCode())) == 1) {
            InputStream inputStream = con.getInputStream();
            FileOutputStream outStream = new FileOutputStream(absoluteFilePath);
            int c = -1;
            while ((c = inputStream.read()) != -1) {
                ((OutputStream)outStream).write(c);
            }
            inputStream.close();
            ((OutputStream)outStream).close();
            if (log.isDebugEnabled()) {
                log.debug((Object)("A connection to " + urlToConnectTo + " has been closed"));
            }
        } else {
            log.error((Object)("URL Connection Error: A problem has occurred while connecting to this url " + urlToConnectTo));
        }
        return status;
    }

    public static String connectToToolExportURL(String toolsExportUrl, Cookie[] cookies) throws MalformedURLException, FileNotFoundException, IOException {
        String mainFileName = null;
        URL url = new URL(toolsExportUrl);
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        con.setRequestProperty("Cookie", HttpUrlConnectionUtil.getCookieString(cookies));
        int statusCode = con.getResponseCode();
        int status = HttpUrlConnectionUtil.getStatus(statusCode);
        if (status == 1) {
            InputStream inputStream = con.getInputStream();
            BufferedReader input = new BufferedReader(new InputStreamReader(inputStream));
            mainFileName = input.readLine();
            input.close();
            return mainFileName;
        }
        String errorMsg = "A problem has occurred while connecting to the tools export url " + toolsExportUrl;
        log.error((Object)errorMsg);
        return null;
    }

    private static int getStatus(int statusCode) {
        int status = -1;
        switch (statusCode) {
            case 200: {
                status = 1;
                break;
            }
            case 500: {
                status = -1;
                break;
            }
            case 404: {
                status = -1;
            }
        }
        return status;
    }

    private static String getCookieString(Cookie[] cookies) {
        StringBuffer cookieString = new StringBuffer();
        for (int i = 0; i < cookies.length; ++i) {
            cookieString.append(cookies[i].getName()).append("=").append(cookies[i].getValue());
            if (i == cookies.length - 1) continue;
            cookieString.append(";");
        }
        return cookieString.toString();
    }
}

