/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.web.servlet;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Writer;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.util.wddx.FlashMessage;

public abstract class AbstractStoreWDDXPacketServlet
extends HttpServlet {
    private static Logger log = Logger.getLogger(AbstractStoreWDDXPacketServlet.class);

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter writer = response.getWriter();
        FlashMessage flashMessage = FlashMessage.getWDDXPacketGetReceived(this.getMessageKey(null, request));
        ((Writer)writer).write(flashMessage.serializeMessage());
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        PrintWriter writer = null;
        String packet = null;
        String replyPacket = null;
        try {
            writer = response.getWriter();
            packet = this.getBody(request);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Request " + request.getRequestURI() + " received packet " + packet));
            }
            replyPacket = this.process(packet, request);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Request " + request.getRequestURI() + " sending back packet " + replyPacket));
            }
        }
        catch (Exception e) {
            String uri = request.getRequestURI();
            log.error((Object)(uri + " request triggered exception "), (Throwable)e);
            FlashMessage flashMessage = FlashMessage.getExceptionOccured(this.getMessageKey(packet, request), e.getMessage() != null ? e.getMessage() : "");
            writer.write(flashMessage.serializeMessage());
            return;
        }
        if (writer != null) {
            writer.println(replyPacket);
        }
    }

    private String getBody(HttpServletRequest req) throws IOException {
        int tempContentLength = req.getContentLength();
        ServletInputStream sis = req.getInputStream();
        BufferedReader buff = new BufferedReader(new InputStreamReader((InputStream)sis));
        StringBuffer tempStrBuf = new StringBuffer(tempContentLength > 0 ? tempContentLength : 200);
        String tempStr = buff.readLine();
        while (tempStr != null) {
            tempStrBuf.append(tempStr);
            tempStr = buff.readLine();
        }
        return tempStrBuf.toString();
    }

    protected abstract String process(String var1, HttpServletRequest var2) throws Exception;

    protected abstract String getMessageKey(String var1, HttpServletRequest var2);
}

