/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.monitoring.service;

import org.apache.log4j.Logger;
import org.lamsfoundation.lams.monitoring.service.IMonitoringService;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.scheduling.quartz.QuartzJobBean;

public class FinishScheduleLesson
extends QuartzJobBean {
    private static Logger log = Logger.getLogger(FinishScheduleLesson.class);
    private IMonitoringService monitoringService;

    public void setMonitoringService(IMonitoringService monitoringService) {
        this.monitoringService = monitoringService;
    }

    protected void executeInternal(JobExecutionContext context) throws JobExecutionException {
        JobDataMap properties = context.getJobDetail().getJobDataMap();
        long lessonId = (Long)properties.get("lessonID");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Lesson [" + lessonId + "] is stopping..."));
        }
        this.monitoringService.finishLesson(lessonId);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Lesson [" + lessonId + "] stopped"));
        }
    }
}

