/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.monitoring.web;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.monitoring.service.IMonitoringService;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.util.wddx.FlashMessage;
import org.lamsfoundation.lams.web.servlet.AbstractStoreWDDXPacketServlet;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class CreateLessionServlet
extends AbstractStoreWDDXPacketServlet {
    private static Logger log = Logger.getLogger(CreateLessionServlet.class);
    private static final long serialVersionUID = 6474150792777819606L;

    public IMonitoringService getMonitoringService() {
        WebApplicationContext webContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
        return (IMonitoringService)webContext.getBean("monitoringService");
    }

    protected String process(String lessionPackage, HttpServletRequest request) throws Exception {
        HttpSession ss = SessionManager.getSession();
        UserDTO user = (UserDTO)ss.getAttribute("user");
        if (user == null || user.getUserID() == null) {
            log.error((Object)"Can not find valid login user information");
            FlashMessage flashMessage = new FlashMessage("createLesson", (Object)"Can not find valid login user information", 1);
            return flashMessage.serializeMessage();
        }
        IMonitoringService monitoringService = this.getMonitoringService();
        return monitoringService.createLessonClassForLessonWDDX(user.getUserID(), lessionPackage);
    }

    protected String getMessageKey(String packet, HttpServletRequest request) {
        return "createLesson";
    }
}

