/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.monitoring.web;

import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;
import org.lamsfoundation.lams.learning.service.ILearnerService;
import org.lamsfoundation.lams.learning.web.util.LessonLearnerDataManager;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.GateActivity;
import org.lamsfoundation.lams.learningdesign.PermissionGateActivity;
import org.lamsfoundation.lams.learningdesign.ScheduleGateActivity;
import org.lamsfoundation.lams.learningdesign.SynchGateActivity;
import org.lamsfoundation.lams.monitoring.service.IMonitoringService;
import org.lamsfoundation.lams.monitoring.service.MonitoringServiceException;
import org.lamsfoundation.lams.monitoring.service.MonitoringServiceProxy;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.action.LamsDispatchAction;

public class GateAction
extends LamsDispatchAction {
    private static Logger log = Logger.getLogger(GateAction.class);
    private IMonitoringService monitoringService;
    private ILearnerService learnerService;
    private static final String VIEW_SYNCH_GATE = "viewSynchGate";
    private static final String VIEW_PERMISSION_GATE = "viewPermissionGate";
    private static final String VIEW_SCHEDULE_GATE = "viewScheduleGate";
    private static final String PARAM_GATE_ACTIVITY_ID = "activityId";
    private static final String PARAM_LESSON_ID = "lessonId";

    public ActionForward viewGate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        DynaActionForm gateForm = (DynaActionForm)form;
        long lessonId = WebUtil.readLongParam((HttpServletRequest)request, (String)PARAM_LESSON_ID);
        Long gateIdLong = (Long)gateForm.get(PARAM_GATE_ACTIVITY_ID);
        long gateId = gateIdLong != null ? gateIdLong : -1L;
        this.monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        this.learnerService = MonitoringServiceProxy.getLearnerService(this.getServlet().getServletContext());
        Activity gate = this.monitoringService.getActivityById(gateId);
        int totalLearners = LessonLearnerDataManager.getAllLessonLearners((ServletContext)this.getServlet().getServletContext(), (long)lessonId, (ILearnerService)this.learnerService).size();
        gateForm.set("totalLearners", (Object)new Integer(totalLearners));
        return this.findViewByGateType(mapping, gateForm, gate);
    }

    public ActionForward openGate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        DynaActionForm gateForm = (DynaActionForm)form;
        GateActivity gate = this.monitoringService.openGate((Long)gateForm.get(PARAM_GATE_ACTIVITY_ID));
        return this.findViewByGateType(mapping, gateForm, (Activity)gate);
    }

    private ActionForward findViewByGateType(ActionMapping mapping, DynaActionForm gateForm, Activity gate) {
        if (gate.isSynchGate()) {
            return this.viewSynchGate(mapping, gateForm, (SynchGateActivity)gate);
        }
        if (gate.isScheduleGate()) {
            return this.viewScheduleGate(mapping, gateForm, (ScheduleGateActivity)gate);
        }
        if (gate.isPermissionGate()) {
            return this.viewPermissionGate(mapping, gateForm, (PermissionGateActivity)gate);
        }
        throw new MonitoringServiceException("Invalid gate activity. gate id [" + gate.getActivityId() + "] - the type [" + gate.getActivityTypeId() + "] is not a gate type");
    }

    private ActionForward viewPermissionGate(ActionMapping mapping, DynaActionForm gateForm, PermissionGateActivity permissionGate) {
        gateForm.set("gate", (Object)permissionGate);
        gateForm.set("waitingLearners", (Object)new Integer(permissionGate.getWaitingLearners().size()));
        return mapping.findForward(VIEW_PERMISSION_GATE);
    }

    private ActionForward viewScheduleGate(ActionMapping mapping, DynaActionForm gateForm, ScheduleGateActivity scheduleGate) {
        gateForm.set("gate", (Object)scheduleGate);
        gateForm.set("waitingLearners", (Object)new Integer(scheduleGate.getWaitingLearners().size()));
        gateForm.set("startingTime", (Object)scheduleGate.getGateStartDateTime());
        gateForm.set("endingTime", (Object)scheduleGate.getGateEndDateTime());
        return mapping.findForward(VIEW_SCHEDULE_GATE);
    }

    private ActionForward viewSynchGate(ActionMapping mapping, DynaActionForm gateForm, SynchGateActivity synchgate) {
        gateForm.set("gate", (Object)synchgate);
        gateForm.set("waitingLearners", (Object)new Integer(synchgate.getWaitingLearners().size()));
        return mapping.findForward(VIEW_SYNCH_GATE);
    }
}

