/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.monitoring.web;

import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.monitoring.service.IMonitoringService;
import org.lamsfoundation.lams.monitoring.service.MonitoringServiceProxy;
import org.lamsfoundation.lams.tool.exception.LamsToolServiceException;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.util.wddx.FlashMessage;
import org.lamsfoundation.lams.web.action.LamsDispatchAction;
import org.lamsfoundation.lams.web.session.SessionManager;

public class MonitoringAction
extends LamsDispatchAction {
    private static Logger log = Logger.getLogger(MonitoringAction.class);
    private IMonitoringService monitoringService;
    private static final String SCHEDULER = "scheduler";
    public static String USE_JSP_OUTPUT = "jspoutput";

    private ActionForward outputPacket(ActionMapping mapping, HttpServletRequest request, HttpServletResponse response, String wddxPacket, String parameterName) throws IOException {
        String useJSP = WebUtil.readStrParam((HttpServletRequest)request, (String)USE_JSP_OUTPUT, (boolean)true);
        if (useJSP != null && useJSP.length() >= 0) {
            request.getSession().setAttribute(parameterName, (Object)wddxPacket);
            return mapping.findForward("success");
        }
        PrintWriter writer = response.getWriter();
        writer.println(wddxPacket);
        return null;
    }

    private UserDTO getUser() throws IOException {
        HttpSession ss = SessionManager.getSession();
        UserDTO user = (UserDTO)ss.getAttribute("user");
        if (user != null) {
            return user;
        }
        throw new IOException("Unable to get user. User in session manager is " + user);
    }

    public ActionForward initializeLesson(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        FlashMessage flashMessage = null;
        try {
            String desc;
            String title = WebUtil.readStrParam((HttpServletRequest)request, (String)"lessonName");
            if (title == null) {
                title = "lesson";
            }
            if ((desc = WebUtil.readStrParam((HttpServletRequest)request, (String)"lessonDescription")) == null) {
                desc = "description";
            }
            long ldId = WebUtil.readLongParam((HttpServletRequest)request, (String)"learningDesignID");
            Integer userId = new Integer(WebUtil.readIntParam((HttpServletRequest)request, (String)"userID"));
            Lesson newLesson = this.monitoringService.initializeLesson(title, desc, ldId, userId);
            flashMessage = new FlashMessage("initializeLesson", (Object)newLesson.getLessonId());
        }
        catch (Exception e) {
            flashMessage = new FlashMessage("initializeLesson", (Object)e.getMessage(), 1);
        }
        String message = flashMessage.serializeMessage();
        return this.outputPacket(mapping, request, response, message, "details");
    }

    public ActionForward startLesson(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        long lessonId = WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID");
        FlashMessage flashMessage = null;
        try {
            this.monitoringService.startLesson(lessonId);
            flashMessage = new FlashMessage("startLesson", (Object)Boolean.TRUE);
        }
        catch (Exception e) {
            flashMessage = new FlashMessage("startLesson", (Object)("Invalid lessonID :" + lessonId), 1);
        }
        String message = flashMessage.serializeMessage();
        return this.outputPacket(mapping, request, response, message, "details");
    }

    public ActionForward startOnScheduleLesson(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        long lessonId = WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID");
        String dateStr = WebUtil.readStrParam((HttpServletRequest)request, (String)"lessonStartDate");
        FlashMessage flashMessage = null;
        try {
            Date startDate = DateFormat.getInstance().parse(dateStr);
            this.monitoringService.startLessonOnSchedule(lessonId, startDate);
            flashMessage = new FlashMessage("startOnScheduleLesson", (Object)Boolean.TRUE);
        }
        catch (ParseException e) {
            flashMessage = new FlashMessage("startOnScheduleLesson", (Object)("Invalid lesson start datetime format:" + dateStr), 1);
        }
        catch (Exception e) {
            flashMessage = new FlashMessage("startOnScheduleLesson", (Object)("Invalid lessonID :" + lessonId), 1);
        }
        String message = flashMessage.serializeMessage();
        return this.outputPacket(mapping, request, response, message, "details");
    }

    public ActionForward finishOnScheduleLesson(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        long lessonId = WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID");
        String dateStr = WebUtil.readStrParam((HttpServletRequest)request, (String)"lessonFinishDate");
        FlashMessage flashMessage = null;
        try {
            Date finishDate = DateFormat.getInstance().parse(dateStr);
            this.monitoringService.finishLessonOnSchedule(lessonId, finishDate);
            flashMessage = new FlashMessage("finishOnScheduleLesson", (Object)Boolean.TRUE);
        }
        catch (ParseException e) {
            flashMessage = new FlashMessage("finishOnScheduleLesson", (Object)("Invalid lesson finish datetime format:" + dateStr), 1);
        }
        catch (Exception e) {
            flashMessage = new FlashMessage("finishOnScheduleLesson", (Object)("Invalid lessonID :" + lessonId), 1);
        }
        String message = flashMessage.serializeMessage();
        return this.outputPacket(mapping, request, response, message, "details");
    }

    public ActionForward archiveLesson(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        FlashMessage flashMessage = null;
        this.monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        long lessonId = WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID");
        try {
            this.monitoringService.archiveLesson(lessonId);
            flashMessage = new FlashMessage("archiveLesson", (Object)Boolean.TRUE);
        }
        catch (Exception e) {
            flashMessage = new FlashMessage("archiveLesson", (Object)("Invalid lessonID :" + lessonId), 1);
        }
        String message = flashMessage.serializeMessage();
        return this.outputPacket(mapping, request, response, message, "details");
    }

    public ActionForward suspendLesson(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        FlashMessage flashMessage = null;
        this.monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        long lessonId = WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID");
        try {
            this.monitoringService.suspendLesson(lessonId);
            flashMessage = new FlashMessage("suspendLesson", (Object)Boolean.TRUE);
        }
        catch (Exception e) {
            flashMessage = new FlashMessage("suspendLesson", (Object)("Error occurs :" + e.getMessage()), 1);
        }
        String message = flashMessage.serializeMessage();
        return this.outputPacket(mapping, request, response, message, "details");
    }

    public ActionForward unsuspendLesson(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        FlashMessage flashMessage = null;
        this.monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        long lessonId = WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID");
        try {
            this.monitoringService.unsuspendLesson(lessonId);
            flashMessage = new FlashMessage("unsuspendLesson", (Object)Boolean.TRUE);
        }
        catch (Exception e) {
            flashMessage = new FlashMessage("unsuspendLesson", (Object)("Error occurs :" + e.getMessage()), 1);
        }
        String message = flashMessage.serializeMessage();
        return this.outputPacket(mapping, request, response, message, "details");
    }

    public ActionForward removeLesson(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        FlashMessage flashMessage = null;
        this.monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        long lessonId = WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID");
        try {
            this.monitoringService.removeLesson(lessonId);
            flashMessage = new FlashMessage("removeLesson", (Object)Boolean.TRUE);
        }
        catch (Exception e) {
            flashMessage = new FlashMessage("removeLesson", (Object)("Invalid lessonID :" + lessonId), 1);
        }
        String message = flashMessage.serializeMessage();
        return this.outputPacket(mapping, request, response, message, "details");
    }

    public ActionForward forceComplete(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String message;
        FlashMessage flashMessage = null;
        this.monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        Long activityId = null;
        String actId = request.getParameter("activityID");
        if (actId != null) {
            try {
                activityId = new Long(Long.parseLong(actId));
            }
            catch (Exception e) {
                activityId = null;
            }
        }
        long lessonId = WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID");
        Integer learnerId = new Integer(WebUtil.readIntParam((HttpServletRequest)request, (String)"learnerID"));
        try {
            message = this.monitoringService.forceCompleteLessonByUser(learnerId, lessonId, activityId);
            flashMessage = new FlashMessage("removeLesson", (Object)message);
        }
        catch (Exception e) {
            flashMessage = new FlashMessage("forceComplete", (Object)("Error occurs :" + e.toString()), 1);
        }
        message = flashMessage.serializeMessage();
        return this.outputPacket(mapping, request, response, message, "details");
    }

    public ActionForward getAllLessons(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        String wddxPacket = this.monitoringService.getAllLessonsWDDX();
        return this.outputPacket(mapping, request, response, wddxPacket, "details");
    }

    public ActionForward getLessonDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        Long lessonID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID"));
        String wddxPacket = this.monitoringService.getLessonDetails(lessonID);
        return this.outputPacket(mapping, request, response, wddxPacket, "details");
    }

    public ActionForward getLessonLearners(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        Long lessonID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID"));
        String wddxPacket = this.monitoringService.getLessonLearners(lessonID);
        return this.outputPacket(mapping, request, response, wddxPacket, "details");
    }

    public ActionForward getLearningDesignDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        Long lessonID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID"));
        String wddxPacket = this.monitoringService.getLearningDesignDetails(lessonID);
        return this.outputPacket(mapping, request, response, wddxPacket, "details");
    }

    public ActionForward getAllLearnersProgress(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        Long lessonID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID"));
        String wddxPacket = this.monitoringService.getAllLearnersProgress(lessonID);
        return this.outputPacket(mapping, request, response, wddxPacket, "details");
    }

    public ActionForward getAllContributeActivities(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        Long lessonID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID"));
        String wddxPacket = this.monitoringService.getAllContributeActivities(lessonID);
        return this.outputPacket(mapping, request, response, wddxPacket, "details");
    }

    public ActionForward getLearnerActivityURL(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, LamsToolServiceException {
        this.monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        Integer userID = new Integer(WebUtil.readIntParam((HttpServletRequest)request, (String)"userID"));
        Long activityID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"activityID"));
        String wddxPacket = this.monitoringService.getLearnerActivityURL(activityID, userID);
        return this.outputPacket(mapping, request, response, wddxPacket, "details");
    }

    public ActionForward getActivityContributionURL(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        Long activityID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"activityID"));
        String wddxPacket = this.monitoringService.getActivityContributionURL(activityID);
        return this.outputPacket(mapping, request, response, wddxPacket, "details");
    }

    public ActionForward moveLesson(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        Long lessonID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID"));
        Integer userID = new Integer(WebUtil.readIntParam((HttpServletRequest)request, (String)"userID"));
        Integer targetWorkspaceFolderID = new Integer(WebUtil.readIntParam((HttpServletRequest)request, (String)"folderID"));
        String wddxPacket = this.monitoringService.moveLesson(lessonID, targetWorkspaceFolderID, userID);
        return this.outputPacket(mapping, request, response, wddxPacket, "details");
    }

    public ActionForward renameLesson(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        Long lessonID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID"));
        Integer userID = new Integer(WebUtil.readIntParam((HttpServletRequest)request, (String)"userID"));
        String name = WebUtil.readStrParam((HttpServletRequest)request, (String)"name");
        String wddxPacket = this.monitoringService.renameLesson(lessonID, name, userID);
        return this.outputPacket(mapping, request, response, wddxPacket, "details");
    }

    public ActionForward checkGateStatus(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        Long activityID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"activityID"));
        Long lessonID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID"));
        String wddxPacket = this.monitoringService.checkGateStatus(activityID, lessonID);
        return this.outputPacket(mapping, request, response, wddxPacket, "details");
    }

    public ActionForward releaseGate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        Long activityID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"activityID"));
        String wddxPacket = this.monitoringService.releaseGate(activityID);
        return this.outputPacket(mapping, request, response, wddxPacket, "details");
    }
}

