/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.themes.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.themes.Theme;
import org.lamsfoundation.lams.themes.dao.ICSSThemeDAO;
import org.lamsfoundation.lams.themes.dto.CSSThemeBriefDTO;
import org.lamsfoundation.lams.themes.dto.CSSThemeDTO;
import org.lamsfoundation.lams.themes.exception.ThemeException;
import org.lamsfoundation.lams.themes.service.IThemeService;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.exception.UserException;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;
import org.lamsfoundation.lams.util.MessageService;
import org.lamsfoundation.lams.util.wddx.FlashMessage;
import org.lamsfoundation.lams.util.wddx.WDDXProcessor;

public class ThemeService
implements IThemeService {
    protected Logger log = Logger.getLogger(ThemeService.class);
    protected ICSSThemeDAO themeDAO;
    protected MessageService messageService;
    protected IUserManagementService userManagementService;

    public ICSSThemeDAO getThemeDAO() {
        return this.themeDAO;
    }

    public void setThemeDAO(ICSSThemeDAO themeDAO) {
        this.themeDAO = themeDAO;
    }

    public void setUserManagementService(IUserManagementService userManagementService) {
        this.userManagementService = userManagementService;
    }

    @Override
    public void setMessageService(MessageService messageService) {
        this.messageService = messageService;
    }

    @Override
    public MessageService getMessageService() {
        return this.messageService;
    }

    @Override
    public String storeTheme(String wddxPacket) throws Exception {
        FlashMessage flashMessage = null;
        Hashtable table = (Hashtable)WDDXProcessor.deserialize(wddxPacket);
        CSSThemeDTO themeDTO = new CSSThemeDTO(table);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Converted Theme packet. Packet was \n" + wddxPacket + "\nDTO is\n" + themeDTO));
        }
        Theme dbTheme = null;
        Theme storedTheme = null;
        if (themeDTO.getId() != null) {
            dbTheme = this.themeDAO.getThemeById(themeDTO.getId());
        }
        storedTheme = dbTheme == null ? themeDTO.createCSSThemeVisualElement() : themeDTO.updateCSSTheme(dbTheme);
        this.themeDAO.saveOrUpdateTheme(storedTheme);
        flashMessage = new FlashMessage("storeTheme", storedTheme.getThemeId());
        return flashMessage.serializeMessage();
    }

    @Override
    public String getThemeWDDX(Long themeId) throws IOException {
        FlashMessage flashMessage = null;
        Theme theme = this.getTheme(themeId);
        if (theme == null) {
            flashMessage = FlashMessage.getNoSuchTheme("wddxPacket", themeId);
        } else {
            CSSThemeDTO dto = new CSSThemeDTO(theme);
            flashMessage = new FlashMessage("getTheme", dto);
        }
        return flashMessage.serializeMessage();
    }

    @Override
    public Theme getTheme(Long themeId) {
        return this.themeDAO.getThemeById(themeId);
    }

    @Override
    public Theme getTheme(String themeName) {
        List themes = this.themeDAO.getThemeByName(themeName);
        if (themes != null && themes.size() > 0) {
            return (Theme)themes.get(0);
        }
        return null;
    }

    @Override
    public String getThemes() throws IOException {
        FlashMessage flashMessage = null;
        List themes = this.themeDAO.getAllThemes();
        ArrayList<CSSThemeBriefDTO> themeList = new ArrayList<CSSThemeBriefDTO>();
        Iterator iterator = themes.iterator();
        while (iterator.hasNext()) {
            CSSThemeBriefDTO dto = new CSSThemeBriefDTO((Theme)iterator.next());
            themeList.add(dto);
        }
        flashMessage = new FlashMessage("getThemes", themeList);
        return flashMessage.serializeMessage();
    }

    private FlashMessage setTheme(Integer userId, Long themeId, String type) throws IOException, ThemeException, UserException {
        FlashMessage flashMessage = null;
        User user = (User)this.userManagementService.findById(User.class, userId);
        Theme theme = this.themeDAO.getThemeById(themeId);
        if (theme == null) {
            throw new ThemeException(this.messageService.getMessage("theme.service.setTheme.noSuchTheme"));
        }
        if (user == null) {
            throw new UserException(this.messageService.getMessage("theme.service.setTheme.noSuchUser"));
        }
        if (type == null) {
            user.setHtmlTheme(theme);
            user.setFlashTheme(theme);
        } else if (type.equals("flash")) {
            user.setFlashTheme(theme);
        } else if (type.equals("theme.service.setTheme.saved")) {
            user.setHtmlTheme(theme);
        }
        this.userManagementService.save(user);
        flashMessage = new FlashMessage("setTheme", this.messageService.getMessage("theme.service.setTheme.saved"));
        return flashMessage;
    }

    @Override
    public FlashMessage setTheme(Integer userId, Long themeId) throws IOException, ThemeException, UserException {
        return this.setTheme(userId, themeId, null);
    }

    @Override
    public FlashMessage setHtmlTheme(Integer userId, Long themeId) throws IOException, ThemeException, UserException {
        return this.setTheme(userId, themeId, "theme.service.setTheme.saved");
    }

    @Override
    public FlashMessage setFlashTheme(Integer userId, Long themeId) throws IOException, ThemeException, UserException {
        return this.setTheme(userId, themeId, "flash");
    }

    @Override
    public List<Theme> getAllThemes() {
        return this.themeDAO.getAllThemes();
    }

    @Override
    public void removeTheme(Long themeId) {
        this.themeDAO.deleteThemeById(themeId);
    }

    @Override
    public void saveOrUpdateTheme(Theme theme) {
        this.themeDAO.saveOrUpdateTheme(theme);
    }

    @Override
    public Theme getDefaultCSSTheme() {
        List<Theme> themes = this.getAllThemes();
        String defaultTheme = Configuration.get(ConfigurationKeys.DEFAULT_HTML_THEME);
        for (Theme theme : themes) {
            if (!theme.getName().equals(defaultTheme)) continue;
            return theme;
        }
        return null;
    }

    @Override
    public Theme getDefaultFlashTheme() {
        List<Theme> themes = this.getAllThemes();
        String defaultTheme = Configuration.get(ConfigurationKeys.DEFAULT_FLASH_THEME);
        for (Theme theme : themes) {
            if (!theme.getName().equals(defaultTheme)) continue;
            return theme;
        }
        return null;
    }

    @Override
    public List<Theme> getAllCSSThemes() {
        return this.themeDAO.getAllCSSThemes();
    }

    @Override
    public List<Theme> getAllFlashThemes() {
        return this.themeDAO.getAllFlashThemes();
    }
}

