/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.timezone.dto;

import java.util.Date;
import java.util.TimeZone;

public class TimezoneDTO {
    private String timeZoneId;
    private Date rawOffset;
    private boolean isRawOffsetNegative;
    private int dstOffset;
    private String displayName;
    private boolean selected;

    public static TimezoneDTO createTimezoneDTO(TimeZone timeZone, boolean selected) {
        TimezoneDTO timezoneDTO = new TimezoneDTO();
        timezoneDTO.timeZoneId = timeZone.getID();
        int timeZoneRawOffset = timeZone.getRawOffset();
        timezoneDTO.rawOffset = new Date(Math.abs(timeZoneRawOffset));
        timezoneDTO.isRawOffsetNegative = timeZoneRawOffset < 0;
        timezoneDTO.dstOffset = timeZone.getDSTSavings() / 60000;
        timezoneDTO.displayName = timeZone.getDisplayName();
        timezoneDTO.selected = selected;
        return timezoneDTO;
    }

    public String getTimeZoneId() {
        return this.timeZoneId;
    }

    public void setTimeZoneId(String timeZoneId) {
        this.timeZoneId = timeZoneId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public Date getRawOffset() {
        return this.rawOffset;
    }

    public void setRawOffset(Date rawOffset) {
        this.rawOffset = rawOffset;
    }

    public boolean isRawOffsetNegative() {
        return this.isRawOffsetNegative;
    }

    public void setRawOffsetNegative(boolean isRawOffsetNegative) {
        this.isRawOffsetNegative = isRawOffsetNegative;
    }

    public int getDstOffset() {
        return this.dstOffset;
    }

    public void setDstOffset(int dstOffset) {
        this.dstOffset = dstOffset;
    }
}

