/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.usermanagement.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.PagedResultsControl;
import javax.naming.ldap.PagedResultsResponseControl;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.integration.security.RandomPasswordGenerator;
import org.lamsfoundation.lams.usermanagement.AuthenticationMethod;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.OrganisationState;
import org.lamsfoundation.lams.usermanagement.Role;
import org.lamsfoundation.lams.usermanagement.SupportedLocale;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.dto.BulkUpdateResultDTO;
import org.lamsfoundation.lams.usermanagement.service.ILdapService;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;
import org.lamsfoundation.lams.util.HashUtil;
import org.lamsfoundation.lams.util.LanguageUtil;

public class LdapService
implements ILdapService {
    private Logger log = Logger.getLogger(LdapService.class);
    private IUserManagementService service;
    private static final int BULK_UPDATE_CREATED = 0;
    private static final int BULK_UPDATE_UPDATED = 1;
    private static final int BULK_UPDATE_DISABLED = 2;

    public IUserManagementService getService() {
        return this.service;
    }

    public void setService(IUserManagementService service) {
        this.service = service;
    }

    @Override
    public void updateLDAPUser(User user, Attributes attrs) {
        HashMap<String, String> map = this.getLDAPUserAttributes(attrs);
        user.setLogin(map.get("login"));
        user.setFirstName(map.get("fname"));
        user.setLastName(map.get("lname"));
        user.setEmail(map.get("email"));
        user.setAddressLine1(map.get("address1"));
        user.setAddressLine2(map.get("address2"));
        user.setAddressLine3(map.get("address3"));
        user.setCity(map.get("city"));
        user.setState(map.get("state"));
        user.setPostcode(map.get("postcode"));
        user.setCountry(map.get("country"));
        user.setDayPhone(map.get("dayphone"));
        user.setEveningPhone(map.get("eveningphone"));
        user.setFax(map.get("fax"));
        user.setMobilePhone(map.get("mobile"));
        user.setLocale(this.getLocale(map.get("locale")));
        user.setDisabledFlag(this.getDisabledBoolean(attrs));
        this.getService().save(user);
    }

    private SupportedLocale getLocale(String attribute) {
        if (attribute != null && attribute.trim().length() > 0) {
            int index = attribute.indexOf("_");
            if (index > 0) {
                String language = attribute.substring(0, index);
                String country = attribute.substring(index);
                return LanguageUtil.getSupportedLocale(language, country);
            }
            return LanguageUtil.getSupportedLocale(attribute);
        }
        return LanguageUtil.getDefaultLocale();
    }

    @Override
    public boolean createLDAPUser(Attributes attrs) {
        User user = new User();
        try {
            HashMap<String, String> map = this.getLDAPUserAttributes(attrs);
            if (map.get("login") != null && map.get("login").trim().length() > 0) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("===> using LDAP attributes: " + map.get("login") + "," + map.get("fname") + "," + map.get("lname") + "," + map.get("email") + "," + map.get("address1") + "," + map.get("address2") + "," + map.get("address3") + "," + map.get("city") + "," + map.get("state") + "," + map.get("postcode") + "," + map.get("country") + "," + map.get("dayphone") + "," + map.get("eveningphone") + "," + map.get("fax") + "," + map.get("mobile") + "," + map.get("locale")));
                }
                user.setLogin(map.get("login"));
                user.setPassword(HashUtil.sha1(RandomPasswordGenerator.nextPassword(10)));
                user.setFirstName(map.get("fname"));
                user.setLastName(map.get("lname"));
                user.setEmail(map.get("email"));
                user.setAddressLine1(map.get("address1"));
                user.setAddressLine2(map.get("address2"));
                user.setAddressLine3(map.get("address3"));
                user.setCity(map.get("city"));
                user.setState(map.get("state"));
                user.setPostcode(map.get("postcode"));
                user.setCountry(map.get("country"));
                user.setDayPhone(map.get("dayphone"));
                user.setEveningPhone(map.get("eveningphone"));
                user.setFax(map.get("fax"));
                user.setMobilePhone(map.get("mobile"));
                user.setAuthenticationMethod((AuthenticationMethod)this.service.findById(AuthenticationMethod.class, AuthenticationMethod.LDAP));
                user.setFlashTheme(this.service.getDefaultFlashTheme());
                user.setHtmlTheme(this.service.getDefaultHtmlTheme());
                user.setDisabledFlag(this.getDisabledBoolean(attrs));
                user.setCreateDate(new Date());
                user.setLocale(this.getLocale(map.get("locale")));
                user.setTimeZone(user.getTimeZone());
                user.setTutorialsDisabled(false);
                user.setFirstLogin(true);
                this.service.save(user);
                this.service.auditUserCreated(user, "common");
                return true;
            }
            this.log.error((Object)"===> Login name from LDAP is empty - user not created.");
        }
        catch (Exception e) {
            this.log.error((Object)"===> Exception occurred while creating LDAP user: ", (Throwable)e);
        }
        return false;
    }

    private HashMap<String, String> getLDAPUserAttributes(Attributes attrs) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            map.put("login", this.getSingleAttributeString(attrs.get(Configuration.get(ConfigurationKeys.LDAP_LOGIN_ATTR))));
            map.put("fname", this.getSingleAttributeString(attrs.get(Configuration.get(ConfigurationKeys.LDAP_FIRST_NAME_ATTR))));
            map.put("lname", this.getSingleAttributeString(attrs.get(Configuration.get(ConfigurationKeys.LDAP_LAST_NAME_ATTR))));
            map.put("email", this.getSingleAttributeString(attrs.get(Configuration.get(ConfigurationKeys.LDAP_EMAIL_ATTR))));
            map.put("address1", this.getSingleAttributeString(attrs.get(Configuration.get(ConfigurationKeys.LDAP_ADDR1_ATTR))));
            map.put("address2", this.getSingleAttributeString(attrs.get(Configuration.get(ConfigurationKeys.LDAP_ADDR2_ATTR))));
            map.put("address3", this.getSingleAttributeString(attrs.get(Configuration.get(ConfigurationKeys.LDAP_ADDR3_ATTR))));
            map.put("city", this.getSingleAttributeString(attrs.get(Configuration.get(ConfigurationKeys.LDAP_CITY_ATTR))));
            map.put("state", this.getSingleAttributeString(attrs.get(Configuration.get(ConfigurationKeys.LDAP_STATE_ATTR))));
            map.put("postcode", this.getSingleAttributeString(attrs.get(Configuration.get(ConfigurationKeys.LDAP_POSTCODE_ATTR))));
            map.put("country", this.getSingleAttributeString(attrs.get(Configuration.get(ConfigurationKeys.LDAP_COUNTRY_ATTR))));
            map.put("dayphone", this.getSingleAttributeString(attrs.get(Configuration.get(ConfigurationKeys.LDAP_DAY_PHONE_ATTR))));
            map.put("eveningphone", this.getSingleAttributeString(attrs.get(Configuration.get(ConfigurationKeys.LDAP_EVENING_PHONE_ATTR))));
            map.put("fax", this.getSingleAttributeString(attrs.get(Configuration.get(ConfigurationKeys.LDAP_FAX_ATTR))));
            map.put("mobile", this.getSingleAttributeString(attrs.get(Configuration.get(ConfigurationKeys.LDAP_MOBILE_ATTR))));
            map.put("locale", this.getSingleAttributeString(attrs.get(Configuration.get(ConfigurationKeys.LDAP_LOCALE_ATTR))));
            map.put("disabled", this.getSingleAttributeString(attrs.get(this.getLdapAttr(Configuration.get(ConfigurationKeys.LDAP_DISABLED_ATTR)))));
        }
        catch (Exception e) {
            this.log.error((Object)"===> Exception occurred while getting LDAP user attributes: ", (Throwable)e);
        }
        if (map.get("login") != null && ((String)map.get("login")).trim().length() > 255) {
            map.put("login", ((String)map.get("login")).substring(0, 255));
        }
        if (map.get("fname") != null && ((String)map.get("fname")).trim().length() > 128) {
            map.put("fname", ((String)map.get("fname")).substring(0, 128));
        }
        if (map.get("lname") != null && ((String)map.get("lname")).trim().length() > 128) {
            map.put("lname", ((String)map.get("lname")).substring(0, 128));
        }
        if (map.get("email") != null && ((String)map.get("email")).trim().length() > 128) {
            map.put("email", ((String)map.get("email")).substring(0, 128));
        }
        if (map.get("address1") != null && ((String)map.get("address1")).trim().length() > 64) {
            map.put("address1", ((String)map.get("address1")).substring(0, 64));
        }
        if (map.get("address2") != null && ((String)map.get("address2")).trim().length() > 64) {
            map.put("address2", ((String)map.get("address2")).substring(0, 64));
        }
        if (map.get("address3") != null && ((String)map.get("address3")).trim().length() > 64) {
            map.put("address3", ((String)map.get("address3")).substring(0, 64));
        }
        if (map.get("city") != null && ((String)map.get("city")).trim().length() > 64) {
            map.put("city", ((String)map.get("city")).substring(0, 64));
        }
        if (map.get("state") != null && ((String)map.get("state")).trim().length() > 64) {
            map.put("state", ((String)map.get("state")).substring(0, 64));
        }
        if (map.get("postcode") != null && ((String)map.get("postcode")).trim().length() > 10) {
            map.put("postcode", ((String)map.get("postcode")).substring(0, 10));
        }
        if (map.get("country") != null && ((String)map.get("country")).trim().length() > 64) {
            map.put("country", ((String)map.get("country")).substring(0, 64));
        }
        if (map.get("dayphone") != null && ((String)map.get("dayphone")).trim().length() > 64) {
            map.put("dayphone", ((String)map.get("dayphone")).substring(0, 64));
        }
        if (map.get("eveningphone") != null && ((String)map.get("eveningphone")).trim().length() > 64) {
            map.put("eveningphone", map.get("eveningphone").substring(0, 64));
        }
        if (map.get("fax") != null && ((String)map.get("fax")).trim().length() > 64) {
            map.put("fax", map.get("fax").substring(0, 64));
        }
        if (map.get("mobile") != null && map.get("mobile").trim().length() > 64) {
            map.put("mobile", map.get("mobile").substring(0, 64));
        }
        return map;
    }

    @Override
    public String getLdapAttr(String ldapAttr) {
        if (ldapAttr != null) {
            return ldapAttr.startsWith("!") ? ldapAttr.substring(1) : ldapAttr;
        }
        return ldapAttr;
    }

    private Boolean getAsBoolean(Attribute attr) {
        String attrString = this.getSingleAttributeString(attr);
        if (attrString != null) {
            if (attrString.equals("1") || attrString.equals("true")) {
                return true;
            }
            if (attrString.equals("0") || attrString.equals("false")) {
                return false;
            }
        }
        return null;
    }

    @Override
    public boolean getDisabledBoolean(Attributes attrs) {
        String ldapDisabledAttrStr = Configuration.get(ConfigurationKeys.LDAP_DISABLED_ATTR);
        if (ldapDisabledAttrStr.startsWith("!")) {
            Attribute ldapDisabledAttr = attrs.get(ldapDisabledAttrStr = ldapDisabledAttrStr.substring(1));
            Boolean booleanValue = this.getAsBoolean(ldapDisabledAttr);
            if (booleanValue != null) {
                return booleanValue == false;
            }
            return false;
        }
        return this.getAsBoolean(attrs.get(ldapDisabledAttrStr));
    }

    @Override
    public boolean addLDAPUser(Attributes attrs, Integer userId) {
        User user = (User)this.service.findById(User.class, userId);
        List<String> ldapOrgs = this.getAttributeStrings(attrs.get(Configuration.get(ConfigurationKeys.LDAP_ORG_ATTR)));
        List<String> ldapRoles = this.getAttributeStrings(attrs.get(Configuration.get(ConfigurationKeys.LDAP_ROLES_ATTR)));
        String orgField = Configuration.get(ConfigurationKeys.LDAP_ORG_FIELD);
        boolean isAddingUserSuccessful = true;
        if (ldapOrgs != null && ldapRoles != null && orgField != null) {
            for (String ldapOrg : ldapOrgs) {
                this.log.debug((Object)"Looking for organisation to add ldap user to...");
                List orgList = this.service.findByProperty(Organisation.class, orgField, ldapOrg);
                if (orgList != null && !orgList.isEmpty()) {
                    Organisation org = null;
                    if (orgList.size() == 1) {
                        org = (Organisation)orgList.get(0);
                    } else if (orgList.size() > 1) {
                        HashMap<String, Object> properties = new HashMap<String, Object>();
                        properties.put(orgField, ldapOrg);
                        properties.put("organisationState.organisationStateId", OrganisationState.ACTIVE);
                        orgList = this.service.findByProperties(Organisation.class, properties);
                        if (orgList.size() == 1) {
                            org = (Organisation)orgList.get(0);
                        } else {
                            this.log.warn((Object)("More than one LAMS organisation found with the " + orgField + ": " + ldapOrg));
                            isAddingUserSuccessful = false;
                            break;
                        }
                    }
                    List<String> roleIds = this.getRoleIds(ldapRoles);
                    if (roleIds != null && !roleIds.isEmpty()) {
                        this.service.setRolesForUserOrganisation(user, org.getOrganisationId(), roleIds);
                    } else {
                        this.log.warn((Object)("Couldn't map any roles from attribute: " + Configuration.get(ConfigurationKeys.LDAP_ROLES_ATTR)));
                        isAddingUserSuccessful = false;
                    }
                    if (!Configuration.getAsBoolean(ConfigurationKeys.LDAP_ONLY_ONE_ORG)) continue;
                    this.service.removeUserFromOtherGroups(userId, org.getOrganisationId());
                    break;
                }
                this.log.warn((Object)("No LAMS organisations found with the " + orgField + ": " + ldapOrg));
                isAddingUserSuccessful = false;
            }
        }
        return isAddingUserSuccessful;
    }

    private List<String> getRoleIds(List<String> ldapRoles) {
        if (ldapRoles != null) {
            ArrayList<String> roleIds = new ArrayList<String>();
            for (String role : ldapRoles) {
                if (this.isRoleInList(Configuration.get(ConfigurationKeys.LDAP_LEARNER_MAP), role) && !roleIds.contains(Role.ROLE_LEARNER.toString())) {
                    roleIds.add(Role.ROLE_LEARNER.toString());
                }
                if (this.isRoleInList(Configuration.get(ConfigurationKeys.LDAP_MONITOR_MAP), role) && !roleIds.contains(Role.ROLE_MONITOR.toString())) {
                    roleIds.add(Role.ROLE_MONITOR.toString());
                }
                if (this.isRoleInList(Configuration.get(ConfigurationKeys.LDAP_AUTHOR_MAP), role) && !roleIds.contains(Role.ROLE_AUTHOR.toString())) {
                    roleIds.add(Role.ROLE_AUTHOR.toString());
                }
                if (this.isRoleInList(Configuration.get(ConfigurationKeys.LDAP_GROUP_ADMIN_MAP), role) && !roleIds.contains(Role.ROLE_GROUP_ADMIN.toString())) {
                    roleIds.add(Role.ROLE_GROUP_ADMIN.toString());
                }
                if (!this.isRoleInList(Configuration.get(ConfigurationKeys.LDAP_GROUP_MANAGER_MAP), role) || roleIds.contains(Role.ROLE_GROUP_MANAGER.toString())) continue;
                roleIds.add(Role.ROLE_GROUP_MANAGER.toString());
            }
            return roleIds;
        }
        return null;
    }

    private boolean isRoleInList(String list, String role) {
        if (list != null && role != null) {
            String[] array;
            for (String s : array = list.split(";")) {
                if (!role.contains(s)) continue;
                return true;
            }
        }
        return false;
    }

    private List<String> getAttributeStrings(Attribute attr) {
        try {
            ArrayList<String> attrValues = new ArrayList<String>();
            if (attr != null) {
                NamingEnumeration<?> attrEnum = attr.getAll();
                while (attrEnum.hasMore()) {
                    Object attrValue = attrEnum.next();
                    if (attrValue == null) continue;
                    attrValues.add(attrValue.toString());
                }
                return attrValues;
            }
        }
        catch (NamingException e) {
            this.log.error((Object)("===> Naming exception occurred: " + e.getMessage()));
        }
        return null;
    }

    public String getSingleAttributeString(Attribute attr) {
        try {
            Object attrValue;
            if (attr != null && (attrValue = attr.get()) != null) {
                return attrValue.toString();
            }
        }
        catch (NamingException e) {
            this.log.error((Object)("===> Naming exception occurred: " + e.getMessage()));
        }
        return null;
    }

    @Override
    public BulkUpdateResultDTO bulkUpdate() {
        Properties env = new Properties();
        env.setProperty("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.setProperty("java.naming.security.authentication", Configuration.get(ConfigurationKeys.LDAP_SECURITY_AUTHENTICATION));
        env.setProperty("java.naming.batchsize", "10");
        env.setProperty("java.naming.provider.url", Configuration.get(ConfigurationKeys.LDAP_PROVIDER_URL));
        String securityProtocol = Configuration.get(ConfigurationKeys.LDAP_SECURITY_PROTOCOL);
        if (StringUtils.equals((String)"ssl", (String)securityProtocol)) {
            env.setProperty("java.naming.security.protocol", securityProtocol);
        }
        if (StringUtils.isNotBlank((String)Configuration.get(ConfigurationKeys.LDAP_BIND_USER_DN))) {
            env.setProperty("java.naming.security.principal", Configuration.get(ConfigurationKeys.LDAP_BIND_USER_DN));
            env.setProperty("java.naming.security.credentials", Configuration.get(ConfigurationKeys.LDAP_BIND_USER_PASSWORD));
        }
        String baseDN = Configuration.get(ConfigurationKeys.LDAP_BASE_DN);
        String filter = Configuration.get(ConfigurationKeys.LDAP_SEARCH_FILTER);
        filter = filter.replaceAll("\\{0\\}", "*");
        int pageSize = 100;
        try {
            pageSize = new Integer(Configuration.get(ConfigurationKeys.LDAP_SEARCH_RESULTS_PAGE_SIZE));
        }
        catch (Exception e) {
            this.log.error((Object)("Couldn't read " + ConfigurationKeys.LDAP_SEARCH_RESULTS_PAGE_SIZE + ", using default page size of 100."));
        }
        int totalResults = 0;
        int createdUsers = 0;
        int updatedUsers = 0;
        int disabledUsers = 0;
        ArrayList<String> messages = new ArrayList<String>();
        int contextResults = 0;
        try {
            InitialLdapContext ctx = null;
            try {
                ctx = new InitialLdapContext(env, null);
                ctx.setRequestControls(new Control[]{new PagedResultsControl(pageSize, false)});
            }
            catch (Exception e) {
                messages.add("Error creating control: " + e.getMessage());
                this.log.error((Object)e, (Throwable)e);
            }
            this.log.info((Object)("Searching " + baseDN + " using filter " + filter));
            byte[] cookie = null;
            do {
                SearchControls ctrl = new SearchControls();
                ctrl.setSearchScope(2);
                NamingEnumeration<SearchResult> results = ctx.search(baseDN, filter, ctrl);
                while (results.hasMore()) {
                    try {
                        SearchResult result = results.next();
                        Attributes attrs = result.getAttributes();
                        boolean disabled = this.getDisabledBoolean(attrs);
                        String login = this.getSingleAttributeString(attrs.get(Configuration.get(ConfigurationKeys.LDAP_LOGIN_ATTR)));
                        if (login != null && login.trim().length() > 0) {
                            int code = this.bulkUpdateLDAPUser(login, attrs, disabled);
                            switch (code) {
                                case 0: {
                                    ++createdUsers;
                                    break;
                                }
                                case 1: {
                                    ++updatedUsers;
                                    break;
                                }
                                case 2: {
                                    ++disabledUsers;
                                }
                            }
                        } else {
                            this.log.error((Object)("Couldn't find login attribute for user using attribute name: " + Configuration.get(ConfigurationKeys.LDAP_LOGIN_ATTR) + ".  Dumping attributes..."));
                            NamingEnumeration<? extends Attribute> enumAttrs = attrs.getAll();
                            while (enumAttrs.hasMoreElements()) {
                                this.log.error((Object)enumAttrs.next());
                            }
                        }
                    }
                    catch (Exception e) {
                        messages.add("Error processing context result number " + contextResults + ": " + e.getMessage());
                    }
                    ++contextResults;
                }
                cookie = this.getPagedResponseCookie(ctx.getResponseControls());
                ctx.setRequestControls(new Control[]{new PagedResultsControl(pageSize, cookie, false)});
            } while (cookie != null);
            this.log.info((Object)("Ldap context " + baseDN + " returned " + contextResults + " users."));
            ctx.close();
        }
        catch (NamingException e) {
            messages.add("Error while processing " + baseDN + ": " + e.getMessage());
            this.log.error((Object)e, (Throwable)e);
        }
        catch (IOException e) {
            messages.add("Error setting response cookie to continue paged ldap search results: " + e.getMessage());
            this.log.error((Object)e, (Throwable)e);
        }
        catch (Exception e) {
            messages.add("Unknown error: " + e.getMessage());
            this.log.error((Object)e, (Throwable)e);
        }
        BulkUpdateResultDTO dto = new BulkUpdateResultDTO(totalResults += contextResults, createdUsers, updatedUsers, disabledUsers, messages);
        this.log.info((Object)("Ldap returned " + totalResults + " users."));
        this.log.info((Object)(createdUsers + " were created, " + updatedUsers + " were updated/existed, and " + disabledUsers + " were disabled."));
        return dto;
    }

    private int bulkUpdateLDAPUser(String login, Attributes attrs, boolean disabled) {
        int returnCode = -1;
        User user = this.getService().getUserByLogin(login);
        if (!disabled) {
            if (user == null) {
                this.log.info((Object)("Creating new user for LDAP username: " + login));
                if (this.createLDAPUser(attrs)) {
                    user = this.getService().getUserByLogin(login);
                    returnCode = 0;
                } else {
                    this.log.error((Object)("Couldn't create new user for LDAP username: " + login));
                }
            } else {
                this.updateLDAPUser(user, attrs);
                returnCode = 1;
            }
            if (!this.addLDAPUser(attrs, user.getUserId())) {
                this.log.error((Object)("Couldn't add LDAP user: " + login + " to organisation."));
            }
        } else if (user != null) {
            this.getService().disableUser(user.getUserId());
            returnCode = 2;
        }
        return returnCode;
    }

    private byte[] getPagedResponseCookie(Control[] controls) {
        if (controls != null) {
            for (Control control : controls) {
                if (!(control instanceof PagedResultsResponseControl)) continue;
                PagedResultsResponseControl prrc = (PagedResultsResponseControl)control;
                return prrc.getCookie();
            }
        }
        return null;
    }
}

