/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.util;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.servlet.http.Cookie;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;

public class HttpUrlConnectionUtil {
    private static Logger log = Logger.getLogger(HttpUrlConnectionUtil.class);
    public static final int STATUS_OK = 1;
    public static final int STATUS_ERROR = -1;
    public static final String JBOSS_BIND_ADDRESS_KEY = "jboss.bind.address";
    public static final String LAMS_PORT_KEY = "lams.port";
    private static boolean defaultTrustManagerSet = false;
    private static String lamsLocalAddress;

    public static int writeResponseToStream(String urlToConnectTo, OutputStream outStream, Cookie[] cookies) throws MalformedURLException, FileNotFoundException, IOException {
        int statusCode;
        int status;
        HttpURLConnection con = HttpUrlConnectionUtil.getConnection(urlToConnectTo);
        con.setRequestProperty("Cookie", HttpUrlConnectionUtil.getCookieString(cookies));
        if (log.isDebugEnabled()) {
            log.debug((Object)("A connection has been established with " + urlToConnectTo));
        }
        if ((status = HttpUrlConnectionUtil.getStatus(statusCode = con.getResponseCode())) == 1) {
            InputStream inputStream = con.getInputStream();
            int c = -1;
            while ((c = inputStream.read()) != -1) {
                outStream.write(c);
            }
            inputStream.close();
            if (log.isDebugEnabled()) {
                log.debug((Object)("A connection to " + urlToConnectTo + " has been closed"));
            }
        } else {
            log.error((Object)("URL Connection Error: A problem has occurred while connecting to this url " + urlToConnectTo));
        }
        return status;
    }

    public static int writeResponseToFile(String urlToConnectTo, String directoryToStoreFile, String filename, Cookie[] cookies) throws MalformedURLException, FileNotFoundException, IOException {
        int statusCode;
        int status;
        String absoluteFilePath = directoryToStoreFile + File.separator + filename;
        HttpURLConnection con = HttpUrlConnectionUtil.getConnection(urlToConnectTo);
        con.setRequestProperty("Cookie", HttpUrlConnectionUtil.getCookieString(cookies));
        if (log.isDebugEnabled()) {
            log.debug((Object)("A connection has been established with " + urlToConnectTo));
        }
        if ((status = HttpUrlConnectionUtil.getStatus(statusCode = con.getResponseCode())) == 1) {
            InputStream inputStream = con.getInputStream();
            BufferedOutputStream outStream = new BufferedOutputStream(new FileOutputStream(absoluteFilePath));
            IOUtils.copy((InputStream)inputStream, (OutputStream)outStream);
            inputStream.close();
            ((OutputStream)outStream).close();
            if (log.isDebugEnabled()) {
                log.debug((Object)("A connection to " + urlToConnectTo + " has been closed"));
            }
        } else {
            log.error((Object)("URL Connection Error: A problem has occurred while connecting to this url " + urlToConnectTo));
        }
        return status;
    }

    public static String connectToToolExportURL(String toolsExportUrl, Cookie[] cookies) throws MalformedURLException, FileNotFoundException, IOException {
        String mainFileName = null;
        HttpURLConnection con = HttpUrlConnectionUtil.getConnection(toolsExportUrl);
        con.setRequestProperty("Cookie", HttpUrlConnectionUtil.getCookieString(cookies));
        int statusCode = con.getResponseCode();
        int status = HttpUrlConnectionUtil.getStatus(statusCode);
        if (status == 1) {
            InputStream inputStream = con.getInputStream();
            BufferedReader input = new BufferedReader(new InputStreamReader(inputStream));
            mainFileName = input.readLine();
            input.close();
            return mainFileName;
        }
        String errorMsg = "A problem has occurred while connecting to the tools export url " + toolsExportUrl;
        log.error((Object)errorMsg);
        return null;
    }

    private static int getStatus(int statusCode) {
        int status = -1;
        switch (statusCode) {
            case 200: {
                status = 1;
                break;
            }
            case 500: {
                status = -1;
                break;
            }
            case 404: {
                status = -1;
            }
        }
        return status;
    }

    private static String getCookieString(Cookie[] cookies) {
        StringBuffer cookieString = new StringBuffer();
        for (int i = 0; i < cookies.length; ++i) {
            cookieString.append(cookies[i].getName()).append("=").append(cookies[i].getValue());
            if (i == cookies.length - 1) continue;
            cookieString.append(";");
        }
        return cookieString.toString();
    }

    private static HttpURLConnection getConnection(String urlToConnectTo) throws IOException {
        URL url = new URL(urlToConnectTo);
        HttpURLConnection con = null;
        if (urlToConnectTo.toLowerCase().startsWith("https") && urlToConnectTo.startsWith(Configuration.get(ConfigurationKeys.SERVER_URL))) {
            if (!defaultTrustManagerSet) {
                X509TrustManager defaultTrustManager = new X509TrustManager(){

                    @Override
                    public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                    }

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }
                };
                try {
                    SSLContext ctx = SSLContext.getInstance("TLS");
                    ctx.init(new KeyManager[0], new TrustManager[]{defaultTrustManager}, new SecureRandom());
                    SSLContext.setDefault(ctx);
                    defaultTrustManagerSet = true;
                }
                catch (NoSuchAlgorithmException e) {
                    log.error((Object)e);
                }
                catch (KeyManagementException e) {
                    log.error((Object)e);
                }
            }
            HttpsURLConnection httpsCon = (HttpsURLConnection)url.openConnection();
            httpsCon.setHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String arg0, SSLSession arg1) {
                    return true;
                }
            });
            con = httpsCon;
        } else {
            con = (HttpURLConnection)url.openConnection();
        }
        return con;
    }

    public static String getLamsLocalAddress() {
        if (lamsLocalAddress == null) {
            String port = System.getProperty(LAMS_PORT_KEY);
            lamsLocalAddress = port == null ? Configuration.get(ConfigurationKeys.SERVER_URL) : "http://" + System.getProperty(JBOSS_BIND_ADDRESS_KEY) + ":" + port + "/" + Configuration.get(ConfigurationKeys.SERVER_URL_CONTEXT_PATH);
        }
        return lamsLocalAddress;
    }
}

