/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.deploy;

import java.util.ArrayList;
import java.util.LinkedList;
import org.lamsfoundation.lams.tool.deploy.AddWebAppToApplicationXmlTask;
import org.lamsfoundation.lams.tool.deploy.DeployFilesTask;
import org.lamsfoundation.lams.tool.deploy.DeployLanguageFilesTask;
import org.lamsfoundation.lams.tool.deploy.DeployToolConfig;
import org.lamsfoundation.lams.tool.deploy.InsertToolContextClasspathTask;
import org.lamsfoundation.lams.tool.deploy.ToolDBDeployTask;
import org.lamsfoundation.lams.tool.deploy.ToolDBRemoveToolEntriesTask;
import org.lamsfoundation.lams.tool.deploy.ToolDBUpdater;

public class Deploy {
    public static void main(String[] args) throws Exception {
        if (args.length < 1 || args[0] == null) {
            throw new IllegalArgumentException("Usage: Deployer <properties_file_path> <forceDB>. n\nforceDB deletes the old database entries before creating the new entries.\nSo it should be set to false for production and true for development");
        }
        Boolean forceDB = Boolean.FALSE;
        if (args.length == 2 && args[1] != null) {
            forceDB = new Boolean(args[1]);
        }
        System.out.println("Starting Tool Deploy");
        try {
            DeployLanguageFilesTask deployLanguageFilesTask;
            ArrayList<String> files;
            DeployFilesTask deployFilesTask;
            ToolDBDeployTask dbDeployTask;
            System.out.println("Reading Configuration File " + args[0]);
            DeployToolConfig config = new DeployToolConfig(null, args[0]);
            String toolSignature = config.getToolSignature();
            String toolVersionStr = config.getToolVersion();
            ToolDBUpdater dbUpdater = new ToolDBUpdater();
            dbUpdater.setDbUsername(config.getDbUsername());
            dbUpdater.setDbPassword(config.getDbPassword());
            dbUpdater.setDbDriverClass(config.getDbDriverClass());
            dbUpdater.setDbDriverUrl(config.getDbDriverUrl());
            dbUpdater.setToolSignature(config.getToolSignature());
            dbUpdater.setToolVersion(config.getToolVersion());
            dbUpdater.setToolCompatibleVersion(config.getMinServerVersionNumber());
            dbUpdater.checkInstalledVersion();
            if (dbUpdater.getToolExists() && !forceDB.booleanValue()) {
                if (dbUpdater.getToolNewer()) {
                    System.out.println("Updating tool: " + toolSignature + " with version " + toolVersionStr);
                    System.out.println("Disabling tool for update, valid flags set to 0.");
                    dbUpdater.activateTool(toolSignature, 0);
                    dbUpdater.execute();
                    dbDeployTask = new ToolDBDeployTask();
                    dbDeployTask.setDbUsername(config.getDbUsername());
                    dbDeployTask.setDbPassword(config.getDbPassword());
                    dbDeployTask.setDbDriverClass(config.getDbDriverClass());
                    dbDeployTask.setDbDriverUrl(config.getDbDriverUrl());
                    dbDeployTask.setToolUpdateScriptPath(config.getToolUpdateScriptPath());
                    dbDeployTask.runToolUpdateScript(config.getToolUpdateScriptPath());
                    System.out.println("Deploying files to ear");
                    deployFilesTask = new DeployFilesTask();
                    deployFilesTask.setLamsEarPath(config.getLamsEarPath());
                    deployFilesTask.setDeployFiles(config.getDeployFiles());
                    deployFilesTask.execute();
                    files = config.getLanguageFiles();
                    if (files != null && files.size() > 0) {
                        deployLanguageFilesTask = new DeployLanguageFilesTask();
                        deployLanguageFilesTask.setLamsEarPath(config.getLamsEarPath());
                        deployLanguageFilesTask.setDictionaryPacket(config.getLanguageFilesPackage());
                        deployLanguageFilesTask.setDeployFiles(config.getLanguageFiles());
                        deployLanguageFilesTask.execute();
                    }
                    if (!config.getHideTool()) {
                        System.out.println("Enabling Tool, valid flags set to 1");
                        dbUpdater.activateTool(toolSignature, 1);
                    } else {
                        System.out.println("Hiding Tool, valid flags set to 0");
                        dbUpdater.hideTool(toolSignature);
                    }
                    System.out.println("Tool update completed");
                    System.exit(0);
                } else {
                    System.out.println("The tool to be installed: " + toolSignature + " " + toolVersionStr + " is already up to date.");
                    System.exit(0);
                }
            } else {
                System.out.println("The tool to be installed: " + toolSignature + " does not exist in database");
                System.out.println("Continuing with full install");
            }
            if (forceDB.booleanValue()) {
                System.out.println("Removing old tool entries from database");
                ToolDBRemoveToolEntriesTask dbRemoveTask = new ToolDBRemoveToolEntriesTask();
                dbRemoveTask.setDbUsername(config.getDbUsername());
                dbRemoveTask.setDbPassword(config.getDbPassword());
                dbRemoveTask.setDbDriverClass(config.getDbDriverClass());
                dbRemoveTask.setDbDriverUrl(config.getDbDriverUrl());
                dbRemoveTask.setToolSignature(config.getToolSignature());
                dbRemoveTask.setToolTablesDeleteScriptPath(config.getToolTablesDeleteScriptPath());
                dbRemoveTask.execute();
            }
            System.out.println("Running Tool DB Deploy");
            dbDeployTask = new ToolDBDeployTask();
            dbDeployTask.setDbUsername(config.getDbUsername());
            dbDeployTask.setDbPassword(config.getDbPassword());
            dbDeployTask.setDbDriverClass(config.getDbDriverClass());
            dbDeployTask.setDbDriverUrl(config.getDbDriverUrl());
            dbDeployTask.setToolInsertScriptPath(config.getToolInsertScriptPath());
            dbDeployTask.setToolLibraryInsertScriptPath(config.getToolLibraryInsertScriptPath());
            dbDeployTask.setToolActivityInsertScriptPath(config.getToolActivityInsertScriptPath());
            dbDeployTask.setToolTablesScriptPath(config.getToolTablesScriptPath());
            dbDeployTask.execute();
            System.out.println("Deploying files to ear");
            deployFilesTask = new DeployFilesTask();
            deployFilesTask.setLamsEarPath(config.getLamsEarPath());
            deployFilesTask.setDeployFiles(config.getDeployFiles());
            deployFilesTask.execute();
            files = config.getLanguageFiles();
            if (files != null && files.size() > 0) {
                deployLanguageFilesTask = new DeployLanguageFilesTask();
                deployLanguageFilesTask.setLamsEarPath(config.getLamsEarPath());
                deployLanguageFilesTask.setDictionaryPacket(config.getLanguageFilesPackage());
                deployLanguageFilesTask.setDeployFiles(config.getLanguageFiles());
                deployLanguageFilesTask.execute();
            }
            AddWebAppToApplicationXmlTask addWebAppTask = new AddWebAppToApplicationXmlTask();
            addWebAppTask.setLamsEarPath(config.getLamsEarPath());
            addWebAppTask.setContextRoot(config.getToolContext());
            addWebAppTask.setWebUri(config.getToolWebUri());
            addWebAppTask.execute();
            LinkedList<String> warFiles = new LinkedList<String>();
            warFiles.add("lams-central.war");
            warFiles.add("lams-learning.war");
            warFiles.add("lams-monitoring.war");
            InsertToolContextClasspathTask updateWebXmlTask = new InsertToolContextClasspathTask();
            updateWebXmlTask.setLamsEarPath(config.getLamsEarPath());
            updateWebXmlTask.setArchivesToUpdate(warFiles);
            updateWebXmlTask.setApplicationContextPath(config.getToolApplicationContextPath());
            updateWebXmlTask.setJarFileName(config.getToolJarFileName());
            updateWebXmlTask.execute();
            if (!config.getHideTool()) {
                System.out.println("Activating Tool: " + config.getToolSignature());
                dbUpdater.activateTool(config.getToolSignature(), 1);
            } else {
                System.out.println("Hiding tool: " + config.getToolSignature());
                dbUpdater.hideTool(config.getToolSignature());
            }
            System.out.println("Tool Deployed");
        }
        catch (Exception ex) {
            System.out.println("TOOL DEPLOY FAILED");
            ex.printStackTrace();
        }
    }
}

