/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.deploy;

import java.io.IOException;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import org.lamsfoundation.lams.tool.deploy.DeployConfig;
import org.lamsfoundation.lams.tool.deploy.DeployException;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeployToolConfig
extends DeployConfig {
    private static final String TOOL_WEB_URI = "toolWebUri";
    private static final String TOOL_CONTEXT = "toolContext";
    private static final String TOOL_INSERT_SCRIPT_PATH = "toolInsertScriptPath";
    private static final String TOOL_LIBRARY_INSERT_SCRIPT_PATH = "toolLibraryInsertScriptPath";
    private static final String TOOL_TABLES_SCRIPT_PATH = "toolTablesScriptPath";
    private static final String TOOL_TABLES_DELETE_SCRIPT_PATH = "toolTablesDeleteScriptPath";
    private static final String TOOL_APP_CONTEXT_FILE_PATH = "toolApplicationContextPath";
    private static final String TOOL_JAR_FILE_NAME = "toolJarFileName";
    private static final String DEPLOY_FILES = "deployFiles";
    private static final String MIN_SERVER_VERSION_NUMBER = "minServerVersionNumber";
    private static final String GENERATE_XML_FOR_INSTALLERS = "generateForInstallers";
    protected static final String LANGUAGE_FILES = "languageFiles";
    private String toolSignature;
    private String toolWebUri;
    private String toolContext;
    private String toolUpdateScriptPath;
    private String toolInsertScriptPath;
    private String toolLibraryInsertScriptPath;
    private boolean hideTool;
    private String toolActivityInsertScriptPath;
    private String toolTablesScriptPath;
    private String toolTablesDeleteScriptPath;
    private String toolApplicationContextPath;
    private String toolJarFileName;
    private String minServerVersionNumber;
    private ArrayList<String> deployFiles;
    private ArrayList<String> languageFiles;

    public DeployToolConfig(String outputPath) {
        super(outputPath);
        this.xstream.alias("Deploy", DeployToolConfig.class);
    }

    public DeployToolConfig(String outputPath, String configurationFilePath) throws ParserConfigurationException, IOException, SAXException {
        super(outputPath);
        this.xstream.alias("Deploy", DeployToolConfig.class);
        this.updateConfigurationProperties(configurationFilePath);
    }

    @Override
    public void updateConfigurationProperties(String configFilePath) throws ParserConfigurationException, IOException, SAXException {
        String xml = this.readFile(configFilePath);
        DeployToolConfig config = (DeployToolConfig)this.deserialiseXML(xml);
        this.copyProperties(config);
        this.printObjectProperties();
    }

    @Override
    protected void setProperty(String key, String value) throws DeployException {
        if (key == null) {
            throw new DeployException("Invalid parameter: Key is null. ");
        }
        super.setProperty(key, value);
        if (key.equalsIgnoreCase(GENERATE_XML_FOR_INSTALLERS)) {
            this.generateForInstallers = Boolean.parseBoolean(value);
            System.out.print(GENERATE_XML_FOR_INSTALLERS + this.generateForInstallers);
        }
        if (key.equalsIgnoreCase("toolSignature")) {
            this.toolSignature = value;
        }
        if (key.equalsIgnoreCase("toolVersion")) {
            this.toolVersion = value;
        }
        if (key.equalsIgnoreCase("hideTool")) {
            this.hideTool = Boolean.parseBoolean(value);
        }
        if (key.equalsIgnoreCase(TOOL_WEB_URI)) {
            this.toolWebUri = value;
        }
        if (key.equalsIgnoreCase(TOOL_CONTEXT)) {
            this.toolContext = value;
        }
        if (key.equalsIgnoreCase("toolUpdateScriptPath")) {
            this.toolUpdateScriptPath = value;
        }
        if (key.equalsIgnoreCase(TOOL_INSERT_SCRIPT_PATH)) {
            this.toolInsertScriptPath = value;
        }
        if (key.equalsIgnoreCase(TOOL_LIBRARY_INSERT_SCRIPT_PATH)) {
            this.toolLibraryInsertScriptPath = value;
        }
        if (key.equalsIgnoreCase("toolActivityInsertScriptPath")) {
            this.toolActivityInsertScriptPath = value;
        }
        if (key.equalsIgnoreCase(TOOL_TABLES_SCRIPT_PATH)) {
            this.toolTablesScriptPath = value;
        }
        if (key.equalsIgnoreCase(TOOL_TABLES_DELETE_SCRIPT_PATH)) {
            this.toolTablesDeleteScriptPath = value;
        }
        if (key.equalsIgnoreCase(TOOL_APP_CONTEXT_FILE_PATH)) {
            this.toolApplicationContextPath = value;
        }
        if (key.equalsIgnoreCase(TOOL_JAR_FILE_NAME)) {
            this.toolJarFileName = value;
        }
        if (key.equalsIgnoreCase(MIN_SERVER_VERSION_NUMBER)) {
            this.minServerVersionNumber = value;
        }
        if (key.equalsIgnoreCase(DEPLOY_FILES)) {
            this.deployFiles = this.convertList(value);
        }
    }

    @Override
    protected void setFilenames(String key, ArrayList<String> filenames) throws DeployException {
        if (key == null) {
            throw new DeployException("Invalid parameter: Key is null. ");
        }
        super.setFilenames(key, filenames);
        if (key.equalsIgnoreCase(LANGUAGE_FILES)) {
            this.setLanguageFiles(filenames);
        }
    }

    protected ArrayList<String> convertList(String input) throws DeployException {
        String[] strings = input.split(",");
        ArrayList<String> list = new ArrayList<String>(strings.length);
        for (String value : strings) {
            list.add(value);
        }
        return list;
    }

    @Override
    public void validateProperties() throws DeployException {
        this.validationError = "";
        boolean valid = this.validateStringProperty(this.toolWebUri, TOOL_WEB_URI);
        valid = valid && this.validateStringProperty(this.toolContext, TOOL_CONTEXT);
        valid = valid && this.validateStringProperty(this.getLamsEarPath(), "lamsEarPath");
        valid = valid && this.validateListProperty(this.getLanguageFiles(), LANGUAGE_FILES);
        valid = valid && this.validateStringProperty(this.toolUpdateScriptPath, "toolUpdateScriptPath");
        valid = valid && this.validateStringProperty(this.toolInsertScriptPath, TOOL_INSERT_SCRIPT_PATH);
        valid = valid && this.validateStringProperty(this.toolLibraryInsertScriptPath, TOOL_LIBRARY_INSERT_SCRIPT_PATH);
        valid = valid && this.validateStringProperty(this.toolActivityInsertScriptPath, "toolActivityInsertScriptPath");
        valid = valid && this.validateStringProperty(this.toolWebUri, TOOL_TABLES_SCRIPT_PATH);
        valid = valid && this.validateStringProperty(this.toolApplicationContextPath, TOOL_APP_CONTEXT_FILE_PATH);
        valid = valid && this.validateStringProperty(this.toolJarFileName, TOOL_JAR_FILE_NAME);
        valid = valid && this.validateStringProperty(this.minServerVersionNumber, MIN_SERVER_VERSION_NUMBER);
        valid = valid && this.validateStringProperty(this.getDbUsername(), "dbUsername");
        valid = valid && this.validateStringProperty(this.getDbPassword(), "dbPassword");
        valid = valid && this.validateStringProperty(this.getDbDriverClass(), "dbPassword");
        valid = valid && this.validateStringProperty(this.getDbDriverUrl(), "dbDriverUrl");
        boolean bl = valid = valid && this.validateListProperty(this.deployFiles, DEPLOY_FILES);
        if (!valid) {
            throw new DeployException("Invalid deployment properties: " + this.validationError);
        }
    }

    protected void copyProperties(DeployToolConfig config) {
        super.copyProperties(config);
        if (config.getToolSignature() != null) {
            this.toolSignature = config.getToolSignature();
        }
        if (config.getToolVersion() != null) {
            this.toolVersion = config.getToolVersion();
        }
        this.hideTool = config.getHideTool();
        if (config.getToolWebUri() != null) {
            this.toolWebUri = config.getToolWebUri();
        }
        if (config.getToolContext() != null) {
            this.toolContext = config.getToolContext();
        }
        if (config.getToolInsertScriptPath() != null) {
            this.toolUpdateScriptPath = config.getToolUpdateScriptPath();
        }
        if (config.getToolInsertScriptPath() != null) {
            this.toolInsertScriptPath = config.getToolInsertScriptPath();
        }
        if (config.getToolLibraryInsertScriptPath() != null) {
            this.toolLibraryInsertScriptPath = config.getToolLibraryInsertScriptPath();
        }
        if (config.getToolActivityInsertScriptPath() != null) {
            this.toolActivityInsertScriptPath = config.getToolActivityInsertScriptPath();
        }
        if (config.getToolTablesScriptPath() != null) {
            this.toolTablesScriptPath = config.getToolTablesScriptPath();
        }
        if (config.getToolTablesDeleteScriptPath() != null) {
            this.toolTablesDeleteScriptPath = config.getToolTablesDeleteScriptPath();
        }
        if (config.getToolApplicationContextPath() != null) {
            this.toolApplicationContextPath = config.getToolApplicationContextPath();
        }
        if (config.getToolJarFileName() != null) {
            this.toolJarFileName = config.getToolJarFileName();
        }
        if (config.getMinServerVersionNumber() != null) {
            this.minServerVersionNumber = config.getMinServerVersionNumber();
        }
        if (config.getDeployFiles() != null) {
            this.deployFiles = config.getDeployFiles();
        }
        if (config.getLanguageFiles() != null) {
            this.setLanguageFiles(config.getLanguageFiles());
        }
    }

    @Override
    public void printObjectProperties() {
        int i;
        super.printObjectProperties();
        System.out.println("Tool Signature: " + this.toolSignature);
        System.out.println("Tool Version: " + this.toolVersion);
        System.out.println("Hide Tool: " + this.hideTool);
        System.out.println("ToolWebUri: " + this.toolWebUri);
        System.out.println("ToolContext: " + this.toolContext);
        System.out.println("ToolUpdateScriptPath: " + this.toolUpdateScriptPath);
        System.out.println("ToolInsertScriptPath: " + this.toolInsertScriptPath);
        System.out.println("ToolLibraryInsertScriptPath: " + this.toolLibraryInsertScriptPath);
        System.out.println("ToolActivityInsertScriptPath: " + this.toolActivityInsertScriptPath);
        System.out.println("ToolTableScriptPath: " + this.toolTablesScriptPath);
        System.out.println("ToolTableDeleteScriptPath: " + this.toolTablesDeleteScriptPath);
        System.out.println("ToolApplicationContextPath: " + this.toolApplicationContextPath);
        System.out.println("ToolJarFileName: " + this.toolJarFileName);
        System.out.println("MinServerVersionNumber: " + this.minServerVersionNumber);
        ArrayList<String> list = this.deployFiles;
        for (i = 0; i < list.size(); ++i) {
            System.out.println("DeployFiles: " + list.get(i));
        }
        list = this.getLanguageFiles();
        for (i = 0; i < list.size(); ++i) {
            System.out.println("LanguageFiles: " + list.get(i));
        }
    }

    public ArrayList<String> getDeployFiles() {
        return this.deployFiles;
    }

    public void setDeployFiles(ArrayList<String> deployFiles) {
        this.deployFiles = deployFiles;
    }

    public String getToolActivityInsertScriptPath() {
        return this.toolActivityInsertScriptPath;
    }

    public void setToolActivityInsertScriptPath(String toolActivityInsertScriptPath) {
        this.toolActivityInsertScriptPath = toolActivityInsertScriptPath;
    }

    public String getToolContext() {
        return this.toolContext;
    }

    public void setToolContext(String toolContextRoot) {
        this.toolContext = toolContextRoot;
    }

    public boolean getHideTool() {
        return this.hideTool;
    }

    public void setHideTool(boolean hideTool) {
        this.hideTool = hideTool;
    }

    public String getToolUpdateScriptPath() {
        return this.toolUpdateScriptPath;
    }

    public void setToolUpdateScriptPath(String toolUpdateScriptPath) {
        this.toolUpdateScriptPath = toolUpdateScriptPath;
    }

    public String getToolInsertScriptPath() {
        return this.toolInsertScriptPath;
    }

    public void setToolInsertScriptPath(String toolInsertScriptPath) {
        this.toolInsertScriptPath = toolInsertScriptPath;
    }

    public String getToolLibraryInsertScriptPath() {
        return this.toolLibraryInsertScriptPath;
    }

    public void setToolLibraryInsertScriptPath(String toolLibraryInsertScriptPath) {
        this.toolLibraryInsertScriptPath = toolLibraryInsertScriptPath;
    }

    public String getToolSignature() {
        return this.toolSignature;
    }

    public void setToolSignature(String toolSignature) {
        this.toolSignature = toolSignature;
    }

    public void setToolVersion(String toolVersion) {
        this.toolVersion = toolVersion;
    }

    public String getToolTablesDeleteScriptPath() {
        return this.toolTablesDeleteScriptPath;
    }

    public void setToolTablesDeleteScriptPath(String toolTablesDeleteScriptPath) {
        this.toolTablesDeleteScriptPath = toolTablesDeleteScriptPath;
    }

    public String getToolTablesScriptPath() {
        return this.toolTablesScriptPath;
    }

    public void setToolTablesScriptPath(String toolTablesScriptPath) {
        this.toolTablesScriptPath = toolTablesScriptPath;
    }

    public String getToolWebUri() {
        return this.toolWebUri;
    }

    public void setToolWebUri(String toolWebUri) {
        this.toolWebUri = toolWebUri;
    }

    public ArrayList<String> getLanguageFiles() {
        return this.languageFiles;
    }

    public void setLanguageFiles(ArrayList<String> languageFiles) {
        this.languageFiles = languageFiles;
    }

    public String getToolApplicationContextPath() {
        return this.toolApplicationContextPath;
    }

    public void setToolApplicationContextPath(String applicationContextPath) {
        this.toolApplicationContextPath = applicationContextPath;
    }

    public String getMinServerVersionNumber() {
        return this.minServerVersionNumber;
    }

    public void setMinServerVersionNumber(String minServerVersionNumber) {
        this.minServerVersionNumber = minServerVersionNumber;
    }

    public String getToolJarFileName() {
        return this.toolJarFileName;
    }

    public void setToolJarFileName(String toolJarFileName) {
        this.toolJarFileName = toolJarFileName;
    }

    @Override
    public void convertForInstallers() {
        if (this.isGenerateForInstallers()) {
            System.out.println("Stripping paths output path " + this.outputPath);
            int lengthOfPath = this.outputPath.length();
            this.toolUpdateScriptPath = this.stripPath(this.toolUpdateScriptPath, this.outputPath, lengthOfPath);
            this.toolInsertScriptPath = this.stripPath(this.toolInsertScriptPath, this.outputPath, lengthOfPath);
            this.toolLibraryInsertScriptPath = this.stripPath(this.toolLibraryInsertScriptPath, this.outputPath, lengthOfPath);
            this.toolActivityInsertScriptPath = this.stripPath(this.toolActivityInsertScriptPath, this.outputPath, lengthOfPath);
            this.toolTablesScriptPath = this.stripPath(this.toolTablesScriptPath, this.outputPath, lengthOfPath);
            this.toolTablesDeleteScriptPath = this.stripPath(this.toolTablesDeleteScriptPath, this.outputPath, lengthOfPath);
            ArrayList<String> newLanguageFiles = new ArrayList<String>(this.languageFiles.size());
            for (String file : this.languageFiles) {
                newLanguageFiles.add(this.stripPath(file, this.outputPath, lengthOfPath));
            }
            this.languageFiles = newLanguageFiles;
            ArrayList<String> newDeployFiles = new ArrayList<String>(this.deployFiles.size());
            for (String file : this.deployFiles) {
                newDeployFiles.add(this.stripPath(file, this.outputPath, lengthOfPath));
            }
            this.deployFiles = newDeployFiles;
            this.setDbDriverClass("@dbDriverClass@");
            this.setDbDriverUrl("@dbDriverUrl@");
            this.setDbUsername("@dbUsername@");
            this.setDbPassword("@dbPassword@");
            this.setLamsEarPath("@lamsear@");
        }
    }

    private String stripPath(String path, String outputPath, int lengthOfPath) {
        System.out.println("script path " + path + " index of " + path.indexOf(outputPath));
        if (path.indexOf(outputPath) == 0) {
            return "@toolDeployPackageDir@" + path.substring(lengthOfPath);
        }
        String convertedPath = path.replace('/', '\\');
        if (convertedPath.indexOf(outputPath) == 0) {
            return "@toolDeployPackageDir@" + convertedPath.substring(lengthOfPath);
        }
        return path;
    }
}

