/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.deploy;

import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import org.apache.commons.dbutils.DbUtils;
import org.lamsfoundation.lams.tool.deploy.DBTask;
import org.lamsfoundation.lams.tool.deploy.DeployException;
import org.lamsfoundation.lams.tool.deploy.FileTokenReplacer;
import org.lamsfoundation.lams.tool.deploy.ScriptRunner;

public class ToolDBDeployTask
extends DBTask {
    private String toolInsertScriptPath;
    private String toolLibraryInsertScriptPath;
    private String toolTablesScriptPath;
    private String toolUpdateScriptPath;
    private long toolId;
    private long learningLibraryId;
    private String toolActivityInsertScriptPath;
    private long defaultContentId;
    private File toolInsertScript;
    private File toolActivityInsertScript;
    private File toolLibraryInsertScript;
    private File toolTablesScript;

    public void setToolUpdateScriptPath(String toolUpdateScriptPath) {
        this.toolUpdateScriptPath = toolUpdateScriptPath;
    }

    public void setToolInsertScriptPath(String toolInsertScriptPath) {
        this.toolInsertScriptPath = toolInsertScriptPath;
    }

    public void setToolLibraryInsertScriptPath(String toolLibraryInsertScriptPath) {
        this.toolLibraryInsertScriptPath = toolLibraryInsertScriptPath;
    }

    public void setToolTablesScriptPath(String toolTablesScriptPath) {
        this.toolTablesScriptPath = toolTablesScriptPath;
    }

    public void execute() throws DeployException {
        this.toolInsertScript = new File(this.toolInsertScriptPath);
        this.toolLibraryInsertScript = new File(this.toolLibraryInsertScriptPath);
        this.toolActivityInsertScript = new File(this.toolActivityInsertScriptPath);
        this.toolTablesScript = new File(this.toolTablesScriptPath);
        Connection conn = this.getConnection();
        try {
            conn.setAutoCommit(false);
            this.toolId = this.runToolInsertScript(this.readFile(this.toolInsertScript), conn);
            this.defaultContentId = this.getNewToolContentId(this.toolId, conn);
            this.updateToolDefaultContentId(this.toolId, this.defaultContentId, conn);
            this.learningLibraryId = this.runLibraryScript(this.readFile(this.toolLibraryInsertScript), conn);
            this.updateToolLibraryId(this.toolId, this.learningLibraryId, conn);
            HashMap<String, String> replacementMap = new HashMap<String, String>(1);
            replacementMap.put("tool_id", Long.toString(this.toolId));
            replacementMap.put("learning_library_id", Long.toString(this.learningLibraryId));
            FileTokenReplacer activityScriptReplacer = new FileTokenReplacer(this.toolActivityInsertScript, replacementMap);
            String activityScriptSQL = activityScriptReplacer.replace();
            this.runScript(activityScriptSQL, conn);
            replacementMap = new HashMap(1);
            replacementMap.put("tool_id", Long.toString(this.toolId));
            replacementMap.put("default_content_id", Long.toString(this.defaultContentId));
            FileTokenReplacer toolTablesScriptReplacer = new FileTokenReplacer(this.toolTablesScript, replacementMap);
            String toolTablesScriptSQL = toolTablesScriptReplacer.replace();
            this.runScript(toolTablesScriptSQL, conn);
            conn.commit();
        }
        catch (SQLException sqlex) {
            try {
                DbUtils.rollback((Connection)conn);
            }
            catch (SQLException sqlex2) {
                throw new DeployException("Attempted to rollback because of " + sqlex + " but failed - cleanup maybe required (see root cause)", sqlex2);
            }
            throw new DeployException("Execute failed", sqlex);
        }
        catch (DeployException dex) {
            try {
                DbUtils.rollback((Connection)conn);
            }
            catch (SQLException sqlex) {
                throw new DeployException("Attempted to rollback because of " + dex + " but failed - cleanup maybe required (see root cause)", sqlex);
            }
            throw dex;
        }
        finally {
            DbUtils.closeQuietly((Connection)conn);
        }
    }

    public long getToolId() {
        return this.toolId;
    }

    public long getLearningLibraryId() {
        return this.learningLibraryId;
    }

    public void setToolActivityInsertScriptPath(String toolActivityInsertScriptPath) {
        this.toolActivityInsertScriptPath = toolActivityInsertScriptPath;
    }

    private long getNewToolContentId(long newToolId, Connection conn) throws DeployException {
        ResultSet results;
        PreparedStatement stmt;
        block5: {
            stmt = null;
            results = null;
            stmt = conn.prepareStatement("INSERT INTO lams_tool_content (tool_id) VALUES (?)");
            stmt.setLong(1, newToolId);
            stmt.execute();
            stmt = conn.prepareStatement("SELECT LAST_INSERT_ID() FROM lams_tool_content");
            results = stmt.executeQuery();
            if (!results.next()) break block5;
            long l = results.getLong("LAST_INSERT_ID()");
            DbUtils.closeQuietly((Statement)stmt);
            DbUtils.closeQuietly((ResultSet)results);
            return l;
        }
        try {
            try {
                throw new DeployException("No tool content id found");
            }
            catch (SQLException sqlex) {
                throw new DeployException("Could not get new tool content id", sqlex);
            }
        }
        catch (Throwable throwable) {
            DbUtils.closeQuietly((Statement)stmt);
            DbUtils.closeQuietly(results);
            throw throwable;
        }
    }

    private void updateToolDefaultContentId(long toolId, long defaultContentId, Connection conn) throws DeployException {
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement("UPDATE lams_tool SET default_tool_content_id = ? WHERE tool_id = ?");
            stmt.setLong(1, defaultContentId);
            stmt.setLong(2, toolId);
            stmt.execute();
        }
        catch (SQLException sqlex) {
            throw new DeployException("Could not update default content id into tool", sqlex);
        }
        finally {
            DbUtils.closeQuietly((Statement)stmt);
        }
    }

    private void updateToolLibraryId(long newToolId, long libraryId, Connection conn) throws DeployException {
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement("UPDATE lams_tool SET learning_library_id = ? WHERE tool_id = ?");
            stmt.setLong(1, libraryId);
            stmt.setLong(2, newToolId);
            stmt.execute();
        }
        catch (SQLException sqlex) {
            throw new DeployException("Could not update library id into tool", sqlex);
        }
        finally {
            DbUtils.closeQuietly((Statement)stmt);
        }
    }

    private void runScript(String scriptSQL, Connection conn) throws DeployException {
        ScriptRunner runner = new ScriptRunner(scriptSQL, conn);
        runner.run();
    }

    private long runLibraryScript(String scriptSQL, Connection conn) throws DeployException {
        ResultSet results;
        PreparedStatement stmt;
        block5: {
            this.runScript(scriptSQL, conn);
            stmt = null;
            results = null;
            stmt = conn.prepareStatement("SELECT LAST_INSERT_ID() FROM lams_learning_library");
            results = stmt.executeQuery();
            if (!results.next()) break block5;
            long l = results.getLong("LAST_INSERT_ID()");
            DbUtils.closeQuietly((Statement)stmt);
            DbUtils.closeQuietly((ResultSet)results);
            return l;
        }
        try {
            try {
                throw new DeployException("Could not get learning_library_id");
            }
            catch (SQLException sqlex) {
                throw new DeployException("Failed to run learning library script", sqlex);
            }
        }
        catch (Throwable throwable) {
            DbUtils.closeQuietly((Statement)stmt);
            DbUtils.closeQuietly(results);
            throw throwable;
        }
    }

    private long runToolInsertScript(String scriptSQL, Connection conn) throws DeployException {
        ResultSet results;
        PreparedStatement stmt;
        block5: {
            this.runScript(scriptSQL, conn);
            stmt = null;
            results = null;
            stmt = conn.prepareStatement("SELECT LAST_INSERT_ID() FROM lams_tool");
            results = stmt.executeQuery();
            if (!results.next()) break block5;
            long l = results.getLong("LAST_INSERT_ID()");
            DbUtils.closeQuietly((Statement)stmt);
            DbUtils.closeQuietly((ResultSet)results);
            return l;
        }
        try {
            try {
                throw new DeployException("Could not get learning_library_id");
            }
            catch (SQLException sqlex) {
                throw new DeployException("Failed to run tool insert script", sqlex);
            }
        }
        catch (Throwable throwable) {
            DbUtils.closeQuietly((Statement)stmt);
            DbUtils.closeQuietly(results);
            throw throwable;
        }
    }

    public void runToolUpdateScript(String scriptSQL) {
        try {
            File updateScript = new File(scriptSQL);
            if (updateScript.exists()) {
                System.out.println("Updating database with script: " + scriptSQL);
                Connection conn = this.getConnection();
                this.runScript(this.readFile(updateScript), conn);
                conn.close();
                System.out.println("Database updated");
            } else {
                System.out.println("No update file found at " + scriptSQL + ", continuing install without database update script.");
            }
        }
        catch (SQLException se) {
            throw new DeployException("Failed to execute update script: " + scriptSQL);
        }
    }

    public long getDefaultContentId() {
        return this.defaultContentId;
    }
}

