/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.deploy;

import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.dbutils.DbUtils;
import org.lamsfoundation.lams.tool.deploy.DBTask;
import org.lamsfoundation.lams.tool.deploy.DeployException;
import org.lamsfoundation.lams.tool.deploy.ScriptRunner;

public class ToolDBRemoveToolEntriesTask
extends DBTask {
    private String toolTablesDeleteScriptPath;
    private File toolTablesDeleteScript;
    private String toolSignature;

    public void setToolTablesDeleteScriptPath(String toolTablesDeleteScriptPath) {
        this.toolTablesDeleteScriptPath = toolTablesDeleteScriptPath;
    }

    public void setToolSignature(String toolSignature) {
        this.toolSignature = toolSignature;
    }

    public void execute() throws DeployException {
        long toolId = 0L;
        long libId = 0L;
        this.toolTablesDeleteScript = new File(this.toolTablesDeleteScriptPath);
        Connection conn = this.getConnection();
        try {
            conn.setAutoCommit(false);
            toolId = this.getToolId(conn);
            if (toolId != 0L) {
                libId = this.getLearningLibraryId(toolId, conn);
                System.out.println("Deleting rows where toolId = " + toolId + " and learningLibraryId = " + libId);
                this.cleanupToolTables(toolId, libId, conn);
                if (this.toolTablesDeleteScriptPath == null || this.toolTablesDeleteScriptPath.length() == 0) {
                    System.err.println("Unable to run tool delete script as not specified. Later calls may fail.");
                } else {
                    ScriptRunner runner = new ScriptRunner(this.readFile(this.toolTablesDeleteScript), conn);
                    runner.run();
                }
            }
            conn.commit();
        }
        catch (SQLException sqlex) {
            try {
                DbUtils.rollback((Connection)conn);
            }
            catch (SQLException sqlex2) {
                throw new DeployException("Attempted to rollback because of " + sqlex + " but failed - cleanup maybe required (see root cause)", sqlex2);
            }
            throw new DeployException("Execute failed", sqlex);
        }
        catch (DeployException dex) {
            try {
                DbUtils.rollback((Connection)conn);
            }
            catch (SQLException sqlex) {
                throw new DeployException("Attempted to rollback because of " + dex + " but failed - cleanup maybe required (see root cause)", sqlex);
            }
            throw dex;
        }
        finally {
            DbUtils.closeQuietly((Connection)conn);
        }
    }

    private void cleanupToolTables(long toolId, long libraryId, Connection conn) throws DeployException {
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement("DELETE FROM lams_learning_activity WHERE tool_id = ?");
            stmt.setLong(1, toolId);
            stmt.execute();
            stmt = conn.prepareStatement("DELETE FROM lams_tool_content WHERE tool_id = ?");
            stmt.setLong(1, toolId);
            stmt.execute();
            stmt = conn.prepareStatement("DELETE FROM lams_tool WHERE tool_id = ?");
            stmt.setLong(1, toolId);
            stmt.execute();
            stmt = conn.prepareStatement("DELETE FROM lams_learning_library WHERE learning_library_id = ?");
            stmt.setLong(1, libraryId);
            stmt.execute();
        }
        catch (SQLException sqlex) {
            throw new DeployException("Could not remove tool entries from core tool tables.", sqlex);
        }
        finally {
            DbUtils.closeQuietly((Statement)stmt);
        }
    }

    private long getToolId(Connection conn) throws DeployException {
        ResultSet results;
        PreparedStatement stmt;
        block4: {
            long l;
            stmt = null;
            results = null;
            try {
                stmt = conn.prepareStatement("SELECT tool_id FROM lams_tool where tool_signature = ?");
                stmt.setString(1, this.toolSignature);
                results = stmt.executeQuery();
                if (!results.next()) break block4;
                l = results.getLong("tool_id");
            }
            catch (SQLException sqlex) {
                try {
                    throw new DeployException("Failed to run tool insert script", sqlex);
                }
                catch (Throwable throwable) {
                    DbUtils.closeQuietly((Statement)stmt);
                    DbUtils.closeQuietly(results);
                    throw throwable;
                }
            }
            DbUtils.closeQuietly((Statement)stmt);
            DbUtils.closeQuietly((ResultSet)results);
            return l;
        }
        DbUtils.closeQuietly((Statement)stmt);
        DbUtils.closeQuietly((ResultSet)results);
        return 0L;
    }

    private long getLearningLibraryId(long toolId, Connection conn) throws DeployException {
        ResultSet results;
        PreparedStatement stmt;
        block4: {
            long l;
            stmt = null;
            results = null;
            try {
                stmt = conn.prepareStatement("SELECT learning_library_id FROM lams_learning_activity where tool_id = ?");
                stmt.setLong(1, toolId);
                results = stmt.executeQuery();
                if (!results.next()) break block4;
                l = results.getLong("learning_library_id");
            }
            catch (SQLException sqlex) {
                try {
                    throw new DeployException("Failed to run tool insert script", sqlex);
                }
                catch (Throwable throwable) {
                    DbUtils.closeQuietly((Statement)stmt);
                    DbUtils.closeQuietly(results);
                    throw throwable;
                }
            }
            DbUtils.closeQuietly((Statement)stmt);
            DbUtils.closeQuietly((ResultSet)results);
            return l;
        }
        DbUtils.closeQuietly((Statement)stmt);
        DbUtils.closeQuietly((ResultSet)results);
        return 0L;
    }
}

