/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.deploy.libraryActivity;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.lamsfoundation.lams.tool.deploy.DeployLanguageFilesTask;
import org.lamsfoundation.lams.tool.deploy.libraryActivity.ActivityDBLanguageUpdateTask;
import org.lamsfoundation.lams.tool.deploy.libraryActivity.DeployLibraryConfig;
import org.lamsfoundation.lams.tool.deploy.libraryActivity.LearningLibrary;
import org.lamsfoundation.lams.tool.deploy.libraryActivity.LibraryDBActivateTask;
import org.lamsfoundation.lams.tool.deploy.libraryActivity.LibraryDBDeployTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeployLibrary {
    public static void main(String[] args) {
        if (args.length < 1 || args[0] == null) {
            throw new IllegalArgumentException("Usage: Deployer <properties_file_path> <language file directory>.");
        }
        System.out.println("Starting Library Deploy");
        try {
            DeployLibraryConfig config = new DeployLibraryConfig(args[0], null);
            LibraryDBDeployTask dbDeployTask = new LibraryDBDeployTask(config);
            dbDeployTask.execute();
            System.out.println("Inserted activities into database");
            ArrayList libraries = dbDeployTask.getLearningLibraries();
            for (LearningLibrary lib : libraries) {
                String languageFileDirectory = lib.getLanguageFileDirectory();
                if (languageFileDirectory != null) {
                    String packagePath = "org.lamsfoundation.lams.library.llid" + lib.getLearningLibraryId();
                    DeployLanguageFilesTask deployLanguageFilesTask = new DeployLanguageFilesTask();
                    deployLanguageFilesTask.setLamsEarPath(config.getLamsEarPath());
                    deployLanguageFilesTask.setDictionaryPacket(packagePath);
                    deployLanguageFilesTask.setDeployFiles(DeployLibrary.createLanguageFilesList(languageFileDirectory));
                    deployLanguageFilesTask.execute();
                    System.out.println("Updating activity with the language file path");
                    ActivityDBLanguageUpdateTask activityDBTask = new ActivityDBLanguageUpdateTask();
                    activityDBTask.setDbUsername(config.getDbUsername());
                    activityDBTask.setDbPassword(config.getDbPassword());
                    activityDBTask.setDbDriverClass(config.getDbDriverClass());
                    activityDBTask.setDbDriverUrl(config.getDbDriverUrl());
                    activityDBTask.setActivityId(lib.getParentActivityId());
                    activityDBTask.setLanguageFilename(packagePath + '.' + lib.getLanguageFileRoot());
                    activityDBTask.execute();
                }
                System.out.println("Activating learning library " + lib.getLearningLibraryId());
                LibraryDBActivateTask libActivateTask = new LibraryDBActivateTask();
                libActivateTask.setDbUsername(config.getDbUsername());
                libActivateTask.setDbPassword(config.getDbPassword());
                libActivateTask.setDbDriverClass(config.getDbDriverClass());
                libActivateTask.setDbDriverUrl(config.getDbDriverUrl());
                libActivateTask.setLearningLibraryId(lib.getLearningLibraryId());
                libActivateTask.execute();
            }
            System.out.println("Library Deployed");
        }
        catch (Exception ex) {
            System.out.println("TOOL DEPLOY FAILED");
            ex.printStackTrace();
        }
    }

    private static List<String> createLanguageFilesList(String path) {
        ArrayList<String> deployFiles = new ArrayList<String>();
        if (path != null) {
            File dir = new File(path);
            if (!(dir.exists() && dir.isDirectory() && dir.canRead())) {
                System.err.println("Unable to copy language files - path is invalid: " + path);
            } else {
                for (String filename : dir.list()) {
                    deployFiles.add(path + File.separator + filename);
                }
            }
        }
        return deployFiles;
    }
}

