/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.deploy;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.lamsfoundation.lams.tool.deploy.DeployException;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DeployConfig {
    public static final String ROOT_ELEMENT = "Deploy";
    public static final String DB_USERNAME = "dbUsername";
    public static final String DB_PASSWORD = "dbPassword";
    public static final String DB_DRIVER_CLASS = "dbDriverClass";
    public static final String DB_DRIVER_URL = "dbDriverUrl";
    public static final String TOOL_SIGNATURE = "toolSignature";
    public static final String TOOL_VERSION = "toolVersion";
    public static final String HIDE_TOOL = "hideTool";
    public static final String TOOL_UPDATE_SCRIPT_PATH = "toolUpdateScriptPath";
    public static final String TOOL_ACTIVITY_INSERT_SCRIPT_PATH = "toolActivityInsertScriptPath";
    public static final String LAMS_EAR_PATH = "lamsEarPath";
    public static final String I8N_LANGUAGE_FILES_PACKAGE = "languageFilesPackage";
    protected transient String validationError = "";
    protected transient XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver());
    protected String toolVersion;
    private String dbDriverClass;
    private String dbDriverUrl;
    private String dbUsername;
    private String dbPassword;
    private String lamsEarPath;
    private String languageFilesPackage;

    public abstract void updateConfigurationProperties(String var1) throws ParserConfigurationException, IOException, SAXException;

    public abstract void validateProperties() throws DeployException;

    protected boolean validateStringProperty(String property, String key) {
        if (property == null || property.length() < 1) {
            this.validationError = this.validationError + "Property " + key + " is missing or has no value.";
            return false;
        }
        return true;
    }

    protected boolean validateListProperty(List property, String key) {
        if (property == null || property.isEmpty()) {
            this.validationError = this.validationError + "Property " + key + " is missing or has no value.";
            return false;
        }
        return true;
    }

    protected String readFile(String configFilePath) {
        StringBuffer tempStrBuf;
        try {
            BufferedReader in = new BufferedReader(new FileReader(configFilePath));
            tempStrBuf = new StringBuffer();
            String tempStr = in.readLine();
            while (tempStr != null) {
                tempStrBuf.append(tempStr);
                tempStr = in.readLine();
            }
        }
        catch (IOException e) {
            throw new DeployException("An error has occurred while trying to read file " + configFilePath);
        }
        return tempStrBuf.toString();
    }

    protected Object deserialiseXML(String xml) {
        return this.xstream.fromXML(xml);
    }

    protected void setProperty(String key, String value) throws DeployException {
        if (key == null) {
            throw new DeployException("Invalid parameter: Key is null. ");
        }
        if (key.equalsIgnoreCase(DB_USERNAME)) {
            this.setDbUsername(value);
        }
        if (key.equalsIgnoreCase(DB_PASSWORD)) {
            this.setDbPassword(value);
        }
        if (key.equalsIgnoreCase(DB_DRIVER_CLASS)) {
            this.setDbDriverClass(value);
        }
        if (key.equalsIgnoreCase(DB_DRIVER_URL)) {
            this.setDbDriverUrl(value);
        }
        if (key.equalsIgnoreCase(I8N_LANGUAGE_FILES_PACKAGE)) {
            this.setLanguageFilesPackage(value);
        }
        if (key.equalsIgnoreCase(LAMS_EAR_PATH)) {
            this.setLamsEarPath(value);
        }
    }

    protected void setFilenames(String key, ArrayList<String> filenames) throws DeployException {
        if (key == null) {
            throw new DeployException("Invalid parameter: Key is null. ");
        }
    }

    protected void writePropertiesToFile(Writer writer) {
        this.xstream.toXML((Object)this, writer);
    }

    public String getDbDriverClass() {
        return this.dbDriverClass;
    }

    public void setDbDriverClass(String dbDriverClass) {
        this.dbDriverClass = dbDriverClass;
    }

    public String getDbDriverUrl() {
        return this.dbDriverUrl;
    }

    public void setDbDriverUrl(String dbDriverUrl) {
        this.dbDriverUrl = dbDriverUrl;
    }

    public String getDbPassword() {
        return this.dbPassword;
    }

    public void setDbPassword(String dbPassword) {
        this.dbPassword = dbPassword;
    }

    public String getDbUsername() {
        return this.dbUsername;
    }

    public void setDbUsername(String dbUsername) {
        this.dbUsername = dbUsername;
    }

    public String getLanguageFilesPackage() {
        return this.languageFilesPackage;
    }

    public void setLanguageFilesPackage(String languageFilesPackage) {
        this.languageFilesPackage = languageFilesPackage;
    }

    public String getLamsEarPath() {
        return this.lamsEarPath;
    }

    public void setLamsEarPath(String lamsEarPath) {
        this.lamsEarPath = lamsEarPath;
    }

    public String getToolVersion() {
        return this.toolVersion;
    }

    public void printObjectProperties() {
        System.out.println("========Object Properties=======");
        System.out.println("DbUsername: " + this.getDbUsername());
        System.out.println("DbPassword: " + this.getDbPassword());
        System.out.println("DbDriverClass: " + this.getDbDriverClass());
        System.out.println("DbDriverUrl: " + this.getDbDriverUrl());
        System.out.println("LanguageFilesPackage: " + this.getLanguageFilesPackage());
        System.out.println("LamsEarPath: " + this.getLamsEarPath());
    }

    protected void copyProperties(DeployConfig config) {
        if (config.getDbUsername() != null) {
            this.setDbUsername(config.getDbUsername());
        }
        if (config.getDbPassword() != null) {
            this.setDbPassword(config.getDbPassword());
        }
        if (config.getDbDriverUrl() != null) {
            this.setDbDriverUrl(config.getDbDriverUrl());
        }
        if (config.getDbDriverClass() != null) {
            this.setDbDriverClass(config.getDbDriverClass());
        }
        if (config.getLanguageFilesPackage() != null) {
            this.setLanguageFilesPackage(config.getLanguageFilesPackage());
        }
        if (config.getLamsEarPath() != null) {
            this.setLamsEarPath(config.getLamsEarPath());
        }
    }
}

