/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.deploy;

import java.util.LinkedList;
import org.lamsfoundation.lams.tool.deploy.DeployToolConfig;
import org.lamsfoundation.lams.tool.deploy.InsertToolContextClasspathTask;
import org.lamsfoundation.lams.tool.deploy.ToolDBUpdater;

public class UpdateToolContextPath {
    public static void main(String[] args) throws Exception {
        if (args.length < 1 || args[0] == null) {
            throw new IllegalArgumentException("Usage: UpdateToolContextPath <deploy.xml path>");
        }
        try {
            DeployToolConfig config = new DeployToolConfig(args[0]);
            String toolSig = config.getToolSignature();
            ToolDBUpdater dbUpdater = new ToolDBUpdater();
            dbUpdater.setDbUsername(config.getDbUsername());
            dbUpdater.setDbPassword(config.getDbPassword());
            dbUpdater.setDbDriverClass(config.getDbDriverClass());
            dbUpdater.setDbDriverUrl(config.getDbDriverUrl());
            dbUpdater.setToolSignature(toolSig);
            String lamsEar = config.getLamsEarPath();
            String appContextPath = dbUpdater.queryTool(toolSig, "context_file");
            String jarFileName = dbUpdater.queryTool(toolSig, "classpath_addition");
            if (appContextPath.equals("ERROR") || jarFileName.equals("ERROR")) {
                throw new Exception("Could not read context details from lams_tool");
            }
            System.out.println("appContextpath: " + appContextPath);
            System.out.println("jarFileName: " + jarFileName);
            LinkedList<String> warFiles = new LinkedList<String>();
            warFiles.add("lams-central.war");
            warFiles.add("lams-learning.war");
            warFiles.add("lams-monitoring.war");
            InsertToolContextClasspathTask updateWebXmlTask = new InsertToolContextClasspathTask();
            updateWebXmlTask.setLamsEarPath(lamsEar);
            updateWebXmlTask.setArchivesToUpdate(warFiles);
            updateWebXmlTask.setApplicationContextPath(appContextPath);
            updateWebXmlTask.setJarFileName(jarFileName);
            updateWebXmlTask.execute();
        }
        catch (Exception e) {
            System.out.println("Unable to read deploy.xml: " + e.getMessage());
        }
    }
}

