/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.deploy.libraryActivity;

import java.io.IOException;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import org.lamsfoundation.lams.tool.deploy.DeployConfig;
import org.lamsfoundation.lams.tool.deploy.DeployException;
import org.lamsfoundation.lams.tool.deploy.libraryActivity.LearningLibrary;
import org.lamsfoundation.lams.tool.deploy.libraryActivity.ToolActivity;
import org.xml.sax.SAXException;

public class DeployLibraryConfig
extends DeployConfig {
    private static final String LEARNING_LIBRARY = "learningLibrary";
    private static final String LIBRARY_INSERT_SCRIPT = "libraryInsertScriptPath";
    private static final String TEMPLATE_ACTIVITY_INSERT_SCRIPT = "templateActivityInsertScriptPath";
    private static final String TOOL_ACTIVITY = "toolActivity";
    private static final String LEARNING_LIBRARY_LIST = "learningLibraryList";
    private static final String TOOL_ACTIVITY_LIST = "toolActivityList";
    private ArrayList learningLibraryList;

    public DeployLibraryConfig() {
        this.xstream.alias("Deploy", DeployLibraryConfig.class);
        this.xstream.alias(LEARNING_LIBRARY, LearningLibrary.class);
        this.xstream.alias(TOOL_ACTIVITY, ToolActivity.class);
    }

    public DeployLibraryConfig(String dbUsername, String dbPassword, String dbDriverClass, String dbDriverUrl, ArrayList learningLibraries) {
        this.setDbUsername(dbUsername);
        this.setDbPassword(dbPassword);
        this.setDbDriverClass(dbDriverClass);
        this.setDbDriverUrl(dbDriverUrl);
        this.learningLibraryList = learningLibraries;
        this.xstream.alias("Deploy", DeployLibraryConfig.class);
        this.xstream.alias(LEARNING_LIBRARY, LearningLibrary.class);
        this.xstream.alias(TOOL_ACTIVITY, ToolActivity.class);
    }

    public DeployLibraryConfig(String configurationFilePath) throws ParserConfigurationException, IOException, SAXException {
        this.xstream.alias("Deploy", DeployLibraryConfig.class);
        this.xstream.alias(LEARNING_LIBRARY, LearningLibrary.class);
        this.xstream.alias(TOOL_ACTIVITY, ToolActivity.class);
        this.updateConfigurationProperties(configurationFilePath);
    }

    public void updateConfigurationProperties(String configFilePath) throws ParserConfigurationException, IOException, SAXException {
        String xml = this.readFile(configFilePath);
        DeployLibraryConfig config = (DeployLibraryConfig)this.deserialiseXML(xml);
        this.copyProperties(config);
    }

    protected void copyProperties(DeployLibraryConfig config) {
        super.copyProperties(config);
        if (config.getLearningLibraryList() != null) {
            this.setLearningLibraryList(config.getLearningLibraryList());
        }
    }

    public void printObjectProperties() {
        super.printObjectProperties();
        ArrayList learningLibraries = this.getLearningLibraryList();
        for (int j = 0; j < learningLibraries.size(); ++j) {
            LearningLibrary libraryActivity = (LearningLibrary)learningLibraries.get(j);
            System.out.println("\t Learning Library " + j + "-> libraryInsertScriptPath: " + libraryActivity.getLibraryInsertScriptPath());
            System.out.println("\t Learning Library " + j + "-> templateActivityInsertScriptPath: " + libraryActivity.getTemplateActivityInsertScriptPath());
            ArrayList list = libraryActivity.getToolActivityList();
            for (int i = 0; i < list.size(); ++i) {
                ToolActivity a = (ToolActivity)list.get(i);
                System.out.println("\t\tToolActivity " + i + "-> ToolSignature: " + a.getToolSignature());
                System.out.println("\t\tToolActivity " + i + "-> ToolActivityScriptPath: " + a.getToolActivityInsertScriptPath());
            }
        }
    }

    public void validateProperties() throws DeployException {
        this.validationError = "";
        boolean valid = this.validateStringProperty(this.getDbUsername(), "dbUsername");
        valid = valid && this.validateStringProperty(this.getDbPassword(), "dbPassword");
        valid = valid && this.validateStringProperty(this.getDbDriverClass(), "dbPassword");
        valid = valid && this.validateStringProperty(this.getDbDriverUrl(), "dbDriverUrl");
        valid = valid && this.validateStringProperty(this.getLamsEarPath(), "lamsEarPath");
        ArrayList learningLibraries = this.getLearningLibraryList();
        if (learningLibraries != null) {
            for (LearningLibrary learningLibrary : learningLibraries) {
                valid = valid && this.validateStringProperty(learningLibrary.getLibraryInsertScriptPath(), LIBRARY_INSERT_SCRIPT);
                valid = valid && this.validateStringProperty(learningLibrary.getTemplateActivityInsertScriptPath(), TEMPLATE_ACTIVITY_INSERT_SCRIPT);
                ArrayList toolActivities = learningLibrary.getToolActivityList();
                boolean bl = valid = valid && this.validateListProperty(toolActivities, TOOL_ACTIVITY_LIST);
                if (toolActivities == null) continue;
                for (ToolActivity toolActivity : toolActivities) {
                    valid = valid && this.validateStringProperty(toolActivity.getToolActivityInsertScriptPath(), "toolActivityInsertScriptPath");
                    valid = valid && this.validateStringProperty(toolActivity.getToolSignature(), "toolSignature");
                }
            }
        }
        if (!valid) {
            throw new DeployException("Invalid deployment properties: " + this.validationError);
        }
    }

    public ArrayList getLearningLibraryList() {
        return this.learningLibraryList;
    }

    public void setLearningLibraryList(ArrayList learningLibraryList) {
        this.learningLibraryList = learningLibraryList;
    }
}

