/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.modules.mockobjects;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import xdoclet.DocletContext;
import xdoclet.DocletTask;
import xdoclet.XDocletException;
import xdoclet.modules.mockobjects.MockObjectSubTask;
import xdoclet.modules.mockobjects.util.CodeUtils;
import xdoclet.tagshandler.PackageTagsHandler;
import xdoclet.tagshandler.ParameterTagsHandler;
import xdoclet.util.LogUtil;
import xdoclet.util.TypeConversionUtil;
import xjavadoc.XClass;
import xjavadoc.XMember;
import xjavadoc.XMethod;
import xjavadoc.XPackage;
import xjavadoc.XParameter;

public class MockObjectTagsHandler
extends ParameterTagsHandler {
    static final Properties DUMMY = new Properties();
    static final Comparator methodComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            XMember m1 = (XMember)o1;
            XMember m2 = (XMember)o2;
            return m1.getName().compareTo(m2.getName());
        }

        public boolean equals(Object obj) {
            return obj == this;
        }
    };
    static /* synthetic */ Class class$xdoclet$modules$mockobjects$MockObjectTagsHandler;
    static /* synthetic */ Class class$xdoclet$modules$mockobjects$MockObjectSubTask;

    public static String getMockClassFor(XClass clazz) throws XDocletException {
        Log log = LogUtil.getLog((Class)(class$xdoclet$modules$mockobjects$MockObjectTagsHandler == null ? (class$xdoclet$modules$mockobjects$MockObjectTagsHandler = MockObjectTagsHandler.class$("xdoclet.modules.mockobjects.MockObjectTagsHandler")) : class$xdoclet$modules$mockobjects$MockObjectTagsHandler), (String)"getMockClassFor");
        String packageName = PackageTagsHandler.getPackageNameFor((XPackage)clazz.getContainingPackage(), (boolean)true);
        String mockClassName = clazz.getDoc().getTagAttributeValue("mock.generate", "class", false);
        if (log.isDebugEnabled()) {
            log.debug((Object)("MockObject for " + clazz.getQualifiedName()));
        }
        if (mockClassName == null) {
            Object packagePattern = null;
            String mockClassPattern = MockObjectTagsHandler.getMockClassPattern();
            if (mockClassPattern.indexOf("{0}") != -1) {
                String className = clazz.getName();
                if (className.length() >= 2 && className.charAt(0) == 'I' && Character.isUpperCase(className.charAt(1))) {
                    className = className.substring(1);
                }
                mockClassName = MessageFormat.format(mockClassPattern, className);
            } else {
                mockClassName = mockClassPattern;
            }
        }
        if (mockClassName.indexOf(46) == -1 && packageName.length() > 0) {
            mockClassName = packageName + "." + mockClassName;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("clazz.getName()=" + clazz.getName()));
            log.debug((Object)("clazz.getQualifiedName()=" + clazz.getQualifiedName()));
            log.debug((Object)("mockClassName=" + mockClassName));
        }
        return mockClassName;
    }

    protected static String getMockClassPattern() {
        MockObjectSubTask mockST = (MockObjectSubTask)DocletContext.getInstance().getSubTaskBy(DocletTask.getSubTaskName((Class)(class$xdoclet$modules$mockobjects$MockObjectSubTask == null ? (class$xdoclet$modules$mockobjects$MockObjectSubTask = MockObjectTagsHandler.class$("xdoclet.modules.mockobjects.MockObjectSubTask")) : class$xdoclet$modules$mockobjects$MockObjectSubTask)));
        if (mockST != null) {
            return mockST.getMockClassPattern();
        }
        return MockObjectSubTask.DEFAULT_MOCKCLASS_PATTERN;
    }

    public String parameterTypeList(Properties attributes) throws XDocletException {
        StringBuffer sbuf = new StringBuffer();
        boolean constr = TypeConversionUtil.stringToBoolean((String)attributes.getProperty("forConstructor"), (boolean)false);
        List parameters = constr ? MockObjectTagsHandler.getCurrentConstructor().getParameters() : MockObjectTagsHandler.getCurrentMethod().getParameters();
        Iterator iter = parameters.iterator();
        while (iter.hasNext()) {
            XParameter parameter = (XParameter)iter.next();
            XClass type = parameter.getType();
            if (type == null) {
                throw new XDocletException("FATAL: " + parameter);
            }
            sbuf.append(CodeUtils.capitalize(type.getName()));
            for (int cnt = parameter.getDimension(); cnt > 0; --cnt) {
                sbuf.append("Array");
            }
        }
        String result = sbuf.toString();
        if (result.indexOf("null") != -1) {
            throw new XDocletException("FATAL: " + result);
        }
        return result;
    }

    public String wrap(Properties props) {
        String name = props.getProperty("name");
        String type = props.getProperty("type");
        return CodeUtils.wrapValue(name, type);
    }

    public String unwrap(Properties props) {
        String name = props.getProperty("name");
        String type = props.getProperty("type");
        return CodeUtils.unwrapValue(name, type);
    }

    public String mockClass() throws XDocletException {
        return MockObjectTagsHandler.getMockClassFor(MockObjectTagsHandler.getCurrentClass());
    }

    public String uniqueMethodName(Properties attributes) throws XDocletException {
        StringBuffer result = new StringBuffer();
        String template = attributes.getProperty("template");
        if (null == template) {
            template = "{0}{1}";
        }
        Object[] args = new Object[]{CodeUtils.capitalize(MockObjectTagsHandler.getCurrentMethod().getName()), this.parameterTypeList(DUMMY)};
        return MessageFormat.format(template, args);
    }

    public String uniqueMethodNameAndParam(Properties attributes) throws XDocletException {
        StringBuffer result = new StringBuffer();
        String template = attributes.getProperty("template");
        if (null == template) {
            template = "{0}{1}{3}";
        }
        Object[] args = new Object[]{CodeUtils.capitalize(MockObjectTagsHandler.getCurrentMethod().getName()), this.parameterTypeList(DUMMY), CodeUtils.capitalize(currentMethodParameter.getName())};
        return MessageFormat.format(template, args);
    }

    public void forAllExceptions(String template, Properties attributes) throws XDocletException {
        XMethod executableMember = MockObjectTagsHandler.getCurrentMethod();
        ArrayList exceptions = executableMember == null ? new ArrayList() : executableMember.getThrownExceptions();
        Iterator iter = exceptions.iterator();
        while (iter.hasNext()) {
            MockObjectTagsHandler.pushCurrentClass((XClass)((XClass)iter.next()));
            this.generate(template);
            MockObjectTagsHandler.popCurrentClass();
        }
    }

    public String currentException(Properties attributes) throws XDocletException {
        return MockObjectTagsHandler.getCurrentClass() == null ? "" : MockObjectTagsHandler.getCurrentClass().getQualifiedName();
    }

    public void ifThrowsException(String template, Properties attributes) throws XDocletException {
        XMethod executableMember = MockObjectTagsHandler.getCurrentMethod();
        ArrayList exceptions = executableMember == null ? new ArrayList() : executableMember.getThrownExceptions();
        if (exceptions != null && exceptions.size() > 0) {
            this.generate(template);
        }
    }

    protected String getTagParam(String tagName, String paramName, String defaultValue) throws XDocletException {
        Properties p = new Properties();
        p.setProperty("tagName", tagName);
        p.setProperty("paramName", paramName);
        p.setProperty("default", defaultValue);
        return MockObjectTagsHandler.getTagValue((Properties)p, (int)0);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

