/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign.service;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.contentrepository.InvalidParameterException;
import org.lamsfoundation.lams.contentrepository.ItemNotFoundException;
import org.lamsfoundation.lams.contentrepository.NodeKey;
import org.lamsfoundation.lams.contentrepository.RepositoryCheckedException;
import org.lamsfoundation.lams.contentrepository.client.IToolContentHandler;
import org.lamsfoundation.lams.dao.IBaseDAO;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.ActivityOrderComparator;
import org.lamsfoundation.lams.learningdesign.ChosenGrouping;
import org.lamsfoundation.lams.learningdesign.ComplexActivity;
import org.lamsfoundation.lams.learningdesign.Grouping;
import org.lamsfoundation.lams.learningdesign.GroupingActivity;
import org.lamsfoundation.lams.learningdesign.LearningDesign;
import org.lamsfoundation.lams.learningdesign.License;
import org.lamsfoundation.lams.learningdesign.OptionsActivity;
import org.lamsfoundation.lams.learningdesign.ParallelActivity;
import org.lamsfoundation.lams.learningdesign.PermissionGateActivity;
import org.lamsfoundation.lams.learningdesign.RandomGrouping;
import org.lamsfoundation.lams.learningdesign.ScheduleGateActivity;
import org.lamsfoundation.lams.learningdesign.SequenceActivity;
import org.lamsfoundation.lams.learningdesign.SynchGateActivity;
import org.lamsfoundation.lams.learningdesign.ToolActivity;
import org.lamsfoundation.lams.learningdesign.Transition;
import org.lamsfoundation.lams.learningdesign.dao.IActivityDAO;
import org.lamsfoundation.lams.learningdesign.dao.IGroupingDAO;
import org.lamsfoundation.lams.learningdesign.dao.ILearningDesignDAO;
import org.lamsfoundation.lams.learningdesign.dao.ILearningLibraryDAO;
import org.lamsfoundation.lams.learningdesign.dao.ILicenseDAO;
import org.lamsfoundation.lams.learningdesign.dao.ITransitionDAO;
import org.lamsfoundation.lams.learningdesign.dto.AuthoringActivityDTO;
import org.lamsfoundation.lams.learningdesign.dto.GroupingDTO;
import org.lamsfoundation.lams.learningdesign.dto.LearningDesignDTO;
import org.lamsfoundation.lams.learningdesign.dto.TransitionDTO;
import org.lamsfoundation.lams.learningdesign.dto.ValidationErrorDTO;
import org.lamsfoundation.lams.learningdesign.service.ExportToolContentException;
import org.lamsfoundation.lams.learningdesign.service.IExportToolContentService;
import org.lamsfoundation.lams.learningdesign.service.ILearningDesignService;
import org.lamsfoundation.lams.learningdesign.service.ImportExportUtil;
import org.lamsfoundation.lams.learningdesign.service.ImportToolContentException;
import org.lamsfoundation.lams.learningdesign.service.LD102Importer;
import org.lamsfoundation.lams.lesson.LessonClass;
import org.lamsfoundation.lams.tool.SystemTool;
import org.lamsfoundation.lams.tool.Tool;
import org.lamsfoundation.lams.tool.ToolContent;
import org.lamsfoundation.lams.tool.ToolContentManager;
import org.lamsfoundation.lams.tool.dao.ISystemToolDAO;
import org.lamsfoundation.lams.tool.dao.IToolContentDAO;
import org.lamsfoundation.lams.tool.dao.IToolDAO;
import org.lamsfoundation.lams.tool.dao.IToolImportSupportDAO;
import org.lamsfoundation.lams.tool.exception.ToolException;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.WorkspaceFolder;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;
import org.lamsfoundation.lams.util.FileUtil;
import org.lamsfoundation.lams.util.FileUtilException;
import org.lamsfoundation.lams.util.zipfile.ZipFileUtil;
import org.lamsfoundation.lams.util.zipfile.ZipFileUtilException;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportToolContentService
implements IExportToolContentService,
ApplicationContextAware {
    public static final String LEARNING_DESIGN_SERVICE_BEAN_NAME = "learningDesignService";
    public static final String LD102IMPORTER_BEAN_NAME = "ld102Importer";
    public static final String EXPORT_TOOLCONTNET_ZIP_PREFIX = "lams_toolcontent_";
    public static final String EXPORT_LDCONTENT_ZIP_PREFIX = "lams_ldcontent_";
    public static final String EXPORT_TOOLCONTNET_FOLDER_SUFFIX = "export_toolcontent";
    public static final String EXPORT_TOOLCONTNET_ZIP_SUFFIX = ".zip";
    public static final String EXPORT_LDCONTENT_ZIP_SUFFIX = ".zip";
    public static final String LEARNING_DESIGN_FILE_NAME = "learning_design.xml";
    public static final String TOOL_FILE_NAME = "tool.xml";
    public static final String TOOL_FAILED_FILE_NAME = "export_failed.xml";
    private Logger log = Logger.getLogger(ExportToolContentService.class);
    private ApplicationContext applicationContext;
    private List<NameInfo> fileHandleClassList = new ArrayList<NameInfo>();
    private IActivityDAO activityDAO;
    private IToolDAO toolDAO;
    private IToolContentDAO toolContentDAO;
    private ISystemToolDAO systemToolDAO;
    private IBaseDAO baseDAO;
    private ILicenseDAO licenseDAO;
    private IGroupingDAO groupingDAO;
    private ITransitionDAO transitionDAO;
    private ILearningDesignDAO learningDesignDAO;
    private ILearningLibraryDAO learningLibraryDAO;
    private IToolImportSupportDAO toolImportSupportDAO;

    @Override
    public String exportLearningDesign(Long learningDesignId, List<String> toolsErrorMsgs) throws ExportToolContentException {
        try {
            String targetZipFileName = null;
            String rootDir = FileUtil.createTempDirectory(EXPORT_TOOLCONTNET_FOLDER_SUFFIX);
            String contentDir = FileUtil.getFullPath(rootDir, "content");
            FileUtil.createDirectory(contentDir);
            String ldFileName = FileUtil.getFullPath(contentDir, LEARNING_DESIGN_FILE_NAME);
            OutputStreamWriter ldFile = new OutputStreamWriter((OutputStream)new FileOutputStream(ldFileName), "UTF-8");
            ILearningDesignService service = this.getLearningDesignService();
            LearningDesignDTO ldDto = service.getLearningDesignDTO(learningDesignId);
            XStream designXml = new XStream();
            designXml.toXML((Object)ldDto, (Writer)ldFile);
            this.log.debug((Object)"Learning design xml export success");
            ArrayList activities = ldDto.getActivities();
            for (AuthoringActivityDTO activity : activities) {
                if (activity.getActivityTypeID() != 1) continue;
                ToolContentManager contentManager = (ToolContentManager)this.findToolService(this.toolDAO.getToolByID(activity.getToolID()));
                this.log.debug((Object)("Tool export content : " + activity.getActivityTitle() + " by contentID :" + activity.getToolContentID()));
                try {
                    contentManager.exportToolContent(activity.getToolContentID(), contentDir);
                }
                catch (Exception e) {
                    String msg = activity.getToolDisplayName() + " export tool content failed:" + e.toString();
                    this.log.error((Object)msg);
                    String toolPath = FileUtil.getFullPath(contentDir, activity.getToolContentID().toString());
                    String toolFileName = FileUtil.getFullPath(toolPath, TOOL_FILE_NAME);
                    File toolFile = new File(toolFileName);
                    if (toolFile.exists()) {
                        toolFile.delete();
                    }
                    this.writeErrorToToolFile(contentDir, activity.getToolContentID(), msg);
                    toolsErrorMsgs.add(msg);
                }
            }
            try {
                String targetContentZipFileName = EXPORT_LDCONTENT_ZIP_PREFIX + ldDto.getContentFolderID() + ".zip";
                String secureDir = Configuration.get(ConfigurationKeys.LAMS_EAR_DIR) + File.separator + "lams-www.war" + File.separator + "secure";
                String ldContentDir = FileUtil.getFullPath(secureDir, ldDto.getContentFolderID());
                if (FileUtil.directoryExist(ldContentDir)) {
                    this.log.debug((Object)("Create export Learning Design content target zip file. File name is " + targetContentZipFileName));
                    ZipFileUtil.createZipFile(targetContentZipFileName, ldContentDir, contentDir);
                } else {
                    this.log.error((Object)("No such directory:" + ldContentDir));
                }
            }
            catch (Exception e) {
                this.log.error((Object)("Exception:" + e.toString()));
                throw new ExportToolContentException(e);
            }
            targetZipFileName = URLEncoder.encode(ldDto.getTitle() + ".zip", "UTF-8");
            this.log.debug((Object)("Create export content target zip file. File name is " + targetZipFileName));
            return ZipFileUtil.createZipFile(targetZipFileName, contentDir, rootDir);
        }
        catch (FileUtilException e) {
            this.log.error((Object)("FileUtilExcpetion:" + e.toString()));
            throw new ExportToolContentException(e);
        }
        catch (ZipFileUtilException e) {
            this.log.error((Object)("ZipFileUtilException:" + e.toString()));
            throw new ExportToolContentException(e);
        }
        catch (IOException e) {
            this.log.error((Object)("IOException:" + e.toString()));
            throw new ExportToolContentException(e);
        }
    }

    @Override
    public void exportToolContent(Long toolContentId, Object toolContentObj, IToolContentHandler toolContentHandler, String rootPath) throws ExportToolContentException {
        try {
            String toolPath = FileUtil.getFullPath(rootPath, toolContentId.toString());
            FileUtil.createDirectory(toolPath);
            String toolFileName = FileUtil.getFullPath(toolPath, TOOL_FILE_NAME);
            OutputStreamWriter toolFile = new OutputStreamWriter((OutputStream)new FileOutputStream(toolFileName), "UTF-8");
            XStream toolXml = new XStream();
            Converter c = toolXml.getConverterLookup().defaultConverter();
            FileInvocationHandler handler = null;
            if (!this.fileHandleClassList.isEmpty()) {
                handler = new FileInvocationHandler(c);
                handler.setFileHandleClassList(this.fileHandleClassList);
                Converter myc = (Converter)Proxy.newProxyInstance(c.getClass().getClassLoader(), new Class[]{Converter.class}, (InvocationHandler)handler);
                toolXml.registerConverter(myc);
            }
            toolXml.toXML(toolContentObj, (Writer)toolFile);
            ((Writer)toolFile).flush();
            ((Writer)toolFile).close();
            if (handler != null) {
                List<ValueInfo> list = handler.getFileNodes();
                for (ValueInfo fileNode : list) {
                    this.log.debug((Object)("Tool attachement file is going to save : " + fileNode.fileUuid));
                    toolContentHandler.saveFile(fileNode.fileUuid, FileUtil.getFullPath(toolPath, fileNode.fileUuid.toString()));
                }
                list.clear();
            }
        }
        catch (ItemNotFoundException e) {
            throw new ExportToolContentException(e);
        }
        catch (RepositoryCheckedException e) {
            throw new ExportToolContentException(e);
        }
        catch (IOException e) {
            throw new ExportToolContentException(e);
        }
        catch (FileUtilException e) {
            throw new ExportToolContentException(e);
        }
        finally {
            if (this.fileHandleClassList != null) {
                this.fileHandleClassList.clear();
            }
        }
    }

    @Override
    public void registerFileClassForExport(String fileNodeClassName, String fileUuidFieldName, String fileVersionFieldName) {
        this.fileHandleClassList.add(new NameInfo(fileNodeClassName, fileUuidFieldName, fileVersionFieldName));
    }

    @Override
    public void registerFileClassForImport(String fileNodeClassName, String fileUuidFieldName, String fileVersionFieldName, String fileNameFieldName, String filePropertyFieldName, String mimeTypeFieldName, String initialItemFieldName) {
        this.fileHandleClassList.add(new NameInfo(fileNodeClassName, fileUuidFieldName, fileVersionFieldName, fileNameFieldName, filePropertyFieldName, mimeTypeFieldName, initialItemFieldName));
    }

    @Override
    public Long importLearningDesign102(String ldWddxPacket, User importer, Integer workspaceFolderUid, List<String> toolsErrorMsgs) throws ImportToolContentException {
        WorkspaceFolder folder = this.getWorkspaceFolderForDesign(importer, workspaceFolderUid);
        LD102Importer oldImporter = this.getLD102Importer();
        return oldImporter.storeLDDataWDDX(ldWddxPacket, importer, folder, toolsErrorMsgs);
    }

    @Override
    public Long importLearningDesign(String learningDesignPath, User importer, Integer workspaceFolderUid, List<String> toolsErrorMsgs) throws ImportToolContentException {
        try {
            InputStreamReader ldFile = new InputStreamReader((InputStream)new FileInputStream(FileUtil.getFullPath(learningDesignPath, LEARNING_DESIGN_FILE_NAME)), "UTF-8");
            XStream designXml = new XStream();
            LearningDesignDTO ldDto = (LearningDesignDTO)designXml.fromXML((Reader)ldFile);
            this.log.debug((Object)"Learning design xml deserialize to LearingDesignDTO success.");
            HashMap<Long, ToolContent> toolMapper = new HashMap<Long, ToolContent>();
            ArrayList activities = ldDto.getActivities();
            for (AuthoringActivityDTO activity : activities) {
                if (activity.getActivityTypeID() != 1) continue;
                String toolPath = FileUtil.getFullPath(learningDesignPath, activity.getToolContentID().toString());
                Tool newTool = new ToolCompatibleStrategy().getTool(activity.getToolSignature());
                ToolContent newContent = new ToolContent(newTool);
                this.toolContentDAO.saveToolContent(newContent);
                toolMapper.put(activity.getToolContentID(), newContent);
                try {
                    ToolContentManager contentManager = (ToolContentManager)this.findToolService(newTool);
                    this.log.debug((Object)("Tool begin to import content : " + activity.getActivityTitle() + " by contentID :" + activity.getToolContentID()));
                    contentManager.importToolContent(newContent.getToolContentId(), importer.getUserId(), toolPath);
                    this.log.debug((Object)"Tool content import success.");
                }
                catch (Exception e) {
                    String error = "Unable to import tool content for tool " + newTool.getToolDisplayName() + ". Cause by " + e.toString();
                    this.log.error((Object)error);
                    toolsErrorMsgs.add(error);
                }
            }
            try {
                String contentZipFileName = EXPORT_LDCONTENT_ZIP_PREFIX + ldDto.getContentFolderID() + ".zip";
                String secureDir = Configuration.get(ConfigurationKeys.LAMS_EAR_DIR) + File.separator + "lams-www.war" + File.separator + "secure" + File.separator + ldDto.getContentFolderID();
                File contentZipFile = new File(FileUtil.getFullPath(learningDesignPath, contentZipFileName));
                if (contentZipFile.exists()) {
                    FileInputStream is = new FileInputStream(contentZipFile);
                    ZipFileUtil.expandZipToFolder(is, secureDir);
                }
            }
            catch (Exception e) {
                throw new ImportToolContentException(e);
            }
            WorkspaceFolder folder = this.getWorkspaceFolderForDesign(importer, workspaceFolderUid);
            return this.saveLearningDesign(ldDto, importer, folder, toolMapper);
        }
        catch (ToolException e) {
            throw new ImportToolContentException(e);
        }
        catch (FileNotFoundException e) {
            throw new ImportToolContentException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new ImportToolContentException(e);
        }
    }

    private WorkspaceFolder getWorkspaceFolderForDesign(User importer, Integer workspaceFolderUid) throws ImportToolContentException {
        WorkspaceFolder folder = null;
        if (workspaceFolderUid != null) {
            folder = (WorkspaceFolder)this.baseDAO.find(WorkspaceFolder.class, workspaceFolderUid);
        }
        if (folder == null && importer.getWorkspace() != null) {
            folder = importer.getWorkspace().getDefaultFolder();
        }
        if (folder == null) {
            String error = "Unable to save design in a folder - folder not found. Input folder uid=" + workspaceFolderUid + " user's default folder " + importer.getWorkspace();
            this.log.error((Object)error);
            throw new ImportToolContentException(error);
        }
        return folder;
    }

    @Override
    public Object importToolContent(String toolContentPath, IToolContentHandler toolContentHandler) throws ImportToolContentException {
        Object toolPOJO;
        block26: {
            toolPOJO = null;
            XStream toolXml = new XStream();
            Converter c = toolXml.getConverterLookup().defaultConverter();
            FileInvocationHandler handler = null;
            if (!this.fileHandleClassList.isEmpty()) {
                handler = new FileInvocationHandler(c);
                handler.setFileHandleClassList(this.fileHandleClassList);
                Converter myc = (Converter)Proxy.newProxyInstance(c.getClass().getClassLoader(), new Class[]{Converter.class}, (InvocationHandler)handler);
                toolXml.registerConverter(myc);
            }
            List<ValueInfo> valueList = null;
            try {
                InputStreamReader toolFile = new InputStreamReader((InputStream)new FileInputStream(FileUtil.getFullPath(toolContentPath, TOOL_FILE_NAME)), "UTF-8");
                toolPOJO = toolXml.fromXML((Reader)toolFile);
                if (handler == null) break block26;
                valueList = handler.getFileNodes();
                for (ValueInfo fileNode : valueList) {
                    NodeKey key;
                    Long uuid = NumberUtils.createLong((String)BeanUtils.getProperty((Object)fileNode.instance, (String)fileNode.name.uuidFieldName));
                    if (uuid == null) continue;
                    Long version = null;
                    try {
                        version = NumberUtils.createLong((String)BeanUtils.getProperty((Object)fileNode.instance, (String)fileNode.name.versionFieldName));
                    }
                    catch (Exception e) {
                        this.log.debug((Object)("No method for version:" + fileNode.instance));
                    }
                    String realFileName = uuid.toString();
                    String fullFileName = FileUtil.getFullPath(toolContentPath, realFileName);
                    this.log.debug((Object)("Tool attachement files/packages are going to upload to repository " + fullFileName));
                    File file = new File(fullFileName);
                    boolean isPackage = false;
                    if (!file.exists()) {
                        file = new File(fullFileName + ".zip");
                        realFileName = realFileName + ".zip";
                        isPackage = true;
                        if (!file.exists()) {
                            throw new ImportToolContentException("Content attached file/package can not be found: " + fullFileName + "(.zip)");
                        }
                    }
                    String fileName = BeanUtils.getProperty((Object)fileNode.instance, (String)fileNode.name.fileNameFieldName);
                    String fileProperty = BeanUtils.getProperty((Object)fileNode.instance, (String)fileNode.name.filePropertyFieldName);
                    String mimeType = null;
                    try {
                        mimeType = BeanUtils.getProperty((Object)fileNode.instance, (String)fileNode.name.mimeTypeFieldName);
                    }
                    catch (Exception e) {
                        this.log.debug((Object)("No method for mimeType:" + fileNode.instance));
                    }
                    String initalItem = null;
                    try {
                        initalItem = BeanUtils.getProperty((Object)fileNode.instance, (String)fileNode.name.initalItemFieldName);
                    }
                    catch (Exception e) {
                        this.log.debug((Object)("No method for initial item:" + fileNode.instance));
                    }
                    FileInputStream is = new FileInputStream(file);
                    if (!isPackage) {
                        key = toolContentHandler.uploadFile((InputStream)is, fileName, mimeType, fileProperty);
                    } else {
                        String packageDirectory = ZipFileUtil.expandZip(is, realFileName);
                        key = toolContentHandler.uploadPackage(packageDirectory, initalItem);
                    }
                    BeanUtils.setProperty((Object)fileNode.instance, (String)fileNode.name.uuidFieldName, (Object)key.getUuid());
                    if (fileNode.name.versionFieldName == null) continue;
                    BeanUtils.setProperty((Object)fileNode.instance, (String)fileNode.name.versionFieldName, (Object)key.getVersion());
                }
            }
            catch (FileNotFoundException e) {
                throw new ImportToolContentException(e);
            }
            catch (InvalidParameterException e) {
                throw new ImportToolContentException(e);
            }
            catch (RepositoryCheckedException e) {
                throw new ImportToolContentException(e);
            }
            catch (ZipFileUtilException e) {
                throw new ImportToolContentException(e);
            }
            catch (IllegalAccessException e) {
                throw new ImportToolContentException(e);
            }
            catch (InvocationTargetException e) {
                throw new ImportToolContentException(e);
            }
            catch (NoSuchMethodException e) {
                throw new ImportToolContentException(e);
            }
            catch (UnsupportedEncodingException e) {
                throw new ImportToolContentException(e);
            }
            finally {
                if (this.fileHandleClassList != null) {
                    this.fileHandleClassList.clear();
                }
                if (valueList != null) {
                    valueList.clear();
                }
            }
        }
        return toolPOJO;
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.applicationContext = context;
    }

    private void writeErrorToToolFile(String rootPath, Long toolContentId, String msg) {
        try {
            String toolPath = FileUtil.getFullPath(rootPath, toolContentId.toString());
            FileUtil.createDirectory(toolPath);
            String toolFileName = FileUtil.getFullPath(toolPath, TOOL_FAILED_FILE_NAME);
            FileWriter toolFile = new FileWriter(new File(toolFileName));
            toolFile.write(msg);
            ((Writer)toolFile).flush();
            ((Writer)toolFile).close();
        }
        catch (FileUtilException e) {
            this.log.warn((Object)("Export error file write error:" + e.toString()));
        }
        catch (IOException e) {
            this.log.warn((Object)("Export error file write error:" + e.toString()));
        }
    }

    private ILearningDesignService getLearningDesignService() {
        return (ILearningDesignService)this.applicationContext.getBean(LEARNING_DESIGN_SERVICE_BEAN_NAME);
    }

    private LD102Importer getLD102Importer() {
        return (LD102Importer)this.applicationContext.getBean(LD102IMPORTER_BEAN_NAME);
    }

    private Object findToolService(Tool tool) throws NoSuchBeanDefinitionException {
        return this.applicationContext.getBean(tool.getServiceName());
    }

    private Long saveLearningDesign(LearningDesignDTO dto, User importer, WorkspaceFolder folder, Map<Long, ToolContent> toolMapper) throws ImportToolContentException {
        Activity act;
        ArrayList groupingDtoList = dto.getGroupings();
        HashMap<Long, Grouping> groupingMapper = new HashMap<Long, Grouping>();
        for (GroupingDTO groupingDto : groupingDtoList) {
            Grouping grouping = this.getGrouping(groupingDto);
            groupingMapper.put(grouping.getGroupingId(), grouping);
            grouping.setGroupingId(null);
            this.groupingDAO.insert(grouping);
        }
        TreeSet<AuthoringActivityDTO> actDtoList = new TreeSet<AuthoringActivityDTO>(new ActDTOParentComparator());
        actDtoList.addAll(dto.getActivities());
        TreeSet<Activity> actList = new TreeSet<Activity>(new ActivityOrderComparator());
        HashMap<Long, Activity> activityMapper = new HashMap<Long, Activity>();
        for (AuthoringActivityDTO actDto : actDtoList) {
            act = this.getActivity(actDto, groupingMapper, toolMapper);
            activityMapper.put(act.getActivityId(), act);
            actList.add(act);
        }
        for (AuthoringActivityDTO actDto : actDtoList) {
            act = (Activity)activityMapper.get(actDto.getActivityID());
            if (actDto.getParentActivityID() != null) {
                Activity parent = (Activity)activityMapper.get(actDto.getParentActivityID());
                act.setParentActivity(parent);
                if (this.isComplexActivity(parent)) {
                    TreeSet<Activity> set = ((ComplexActivity)parent).getActivities();
                    if (set == null) {
                        set = new TreeSet<Activity>(new ActivityOrderComparator());
                        ((ComplexActivity)parent).setActivities(set);
                    }
                    set.add(act);
                }
            }
            act.setActivityId(null);
            this.activityDAO.insert(act);
        }
        ArrayList transDtoList = dto.getTransitions();
        HashSet<Transition> transList = new HashSet<Transition>();
        for (TransitionDTO transDto : transDtoList) {
            Transition trans = this.getTransition(transDto, activityMapper);
            transList.add(trans);
            trans.setTransitionId(null);
        }
        LearningDesign ld = this.getLearningDesign(dto, importer, folder, actList, transList, activityMapper);
        Vector<ValidationErrorDTO> listOfValidationErrorDTOs = this.getLearningDesignService().validateLearningDesign(ld);
        if (listOfValidationErrorDTOs.size() > 0) {
            ld.setValidDesign(false);
            this.log.error(listOfValidationErrorDTOs);
        } else {
            ld.setValidDesign(true);
        }
        ld.setTitle(ImportExportUtil.generateUniqueLDTitle(folder, ld.getTitle(), this.learningDesignDAO));
        this.learningDesignDAO.insert(ld);
        return ld.getLearningDesignId();
    }

    private LearningDesign getLearningDesign(LearningDesignDTO dto, User importer, WorkspaceFolder folder, Set<Activity> actList, Set<Transition> transList, Map<Long, Activity> activityMapper) throws ImportToolContentException {
        LearningDesign ld = new LearningDesign();
        if (dto == null) {
            return ld;
        }
        ld.setLearningDesignId(dto.getLearningDesignID());
        ld.setLearningDesignUIID(dto.getLearningDesignUIID());
        ld.setDescription(dto.getDescription());
        ld.setTitle(dto.getTitle());
        Integer actUiid = dto.getFirstActivityUIID();
        if (actUiid != null) {
            for (Activity act : activityMapper.values()) {
                if (!actUiid.equals(act.getActivityUIID())) continue;
                ld.setFirstActivity(act);
                break;
            }
        }
        ld.setMaxID(dto.getMaxID());
        ld.setValidDesign(dto.getValidDesign());
        ld.setReadOnly(dto.getReadOnly());
        ld.setDateReadOnly(dto.getDateReadOnly());
        ld.setOfflineInstructions(dto.getOfflineInstructions());
        ld.setOnlineInstructions(dto.getOnlineInstructions());
        ld.setHelpText(dto.getHelpText());
        ld.setCopyTypeID(1);
        ld.setCreateDateTime(dto.getCreateDateTime());
        ld.setVersion(dto.getVersion());
        if (folder != null) {
            ld.setWorkspaceFolder(folder);
        }
        ld.setDuration(dto.getDuration());
        ld.setLicenseText(dto.getLicenseText());
        Long licenseId = dto.getLicenseID();
        if (licenseId != null) {
            License license = this.licenseDAO.getLicenseByID(licenseId);
            if (license == null) {
                throw new ImportToolContentException("Import failed: License [" + dto.getLicenseText() + "] does not exist in target database");
            }
            ld.setLicense(this.licenseDAO.getLicenseByID(licenseId));
            ld.setLicenseText(dto.getLicenseText());
        }
        ld.setLastModifiedDateTime(dto.getLastModifiedDateTime());
        ld.setContentFolderID(dto.getContentFolderID());
        for (Transition trans : transList) {
            trans.setLearningDesign(ld);
        }
        ld.setTransitions(transList);
        for (Activity act : actList) {
            act.setLearningDesign(ld);
        }
        ld.setActivities(actList);
        ld.setCreateDateTime(new Date());
        ld.setLastModifiedDateTime(new Date());
        ld.setUser(importer);
        return ld;
    }

    private Grouping getGrouping(GroupingDTO groupingDto) {
        Grouping grouping = null;
        if (groupingDto == null) {
            return grouping;
        }
        Integer type = groupingDto.getGroupingTypeID();
        if (Grouping.CHOSEN_GROUPING_TYPE.equals(type)) {
            grouping = new ChosenGrouping();
        } else if (Grouping.RANDOM_GROUPING_TYPE.equals(type)) {
            grouping = new RandomGrouping();
            ((RandomGrouping)grouping).setLearnersPerGroup(groupingDto.getLearnersPerGroup());
            ((RandomGrouping)grouping).setNumberOfGroups(groupingDto.getNumberOfGroups());
        } else if (Grouping.CLASS_GROUPING_TYPE.equals(type)) {
            grouping = new LessonClass();
        }
        grouping.setGroupingId(groupingDto.getGroupingID());
        grouping.setGroupingUIID(groupingDto.getGroupingUIID());
        grouping.setMaxNumberOfGroups(groupingDto.getMaxNumberOfGroups());
        return grouping;
    }

    private Transition getTransition(TransitionDTO transDto, Map<Long, Activity> activityMapper) {
        Transition trans = new Transition();
        if (transDto == null) {
            return trans;
        }
        trans.setDescription(transDto.getDescription());
        Activity fromAct = activityMapper.get(transDto.getFromActivityID());
        trans.setFromActivity(fromAct);
        trans.setFromUIID(fromAct.getActivityUIID());
        fromAct.setTransitionTo(trans);
        trans.setTitle(transDto.getTitle());
        Activity toAct = activityMapper.get(transDto.getToActivityID());
        trans.setToActivity(toAct);
        trans.setToUIID(toAct.getActivityUIID());
        toAct.setTransitionFrom(trans);
        trans.setTransitionId(transDto.getTransitionID());
        trans.setTransitionUIID(transDto.getTransitionUIID());
        trans.setCreateDateTime(new Date());
        return trans;
    }

    private Activity getActivity(AuthoringActivityDTO actDto, Map<Long, Grouping> groupingList, Map<Long, ToolContent> toolMapper) {
        Grouping newGrouping;
        Activity act = null;
        if (actDto == null) {
            return act;
        }
        int type = actDto.getActivityTypeID();
        switch (type) {
            case 1: {
                act = new ToolActivity();
                ToolContent content = toolMapper.get(actDto.getToolContentID());
                ((ToolActivity)act).setTool(content.getTool());
                ((ToolActivity)act).setToolContentId(content.getToolContentId());
                ((ToolActivity)act).setToolSessions(null);
                break;
            }
            case 2: {
                act = new GroupingActivity();
                newGrouping = groupingList.get(actDto.getCreateGroupingID());
                ((GroupingActivity)act).setCreateGrouping(newGrouping);
                ((GroupingActivity)act).setCreateGroupingUIID(newGrouping.getGroupingUIID());
                break;
            }
            case 3: {
                act = new SynchGateActivity();
                ((SynchGateActivity)act).setGateActivityLevelId(actDto.getGateActivityLevelID());
                ((SynchGateActivity)act).setGateOpen(false);
                ((SynchGateActivity)act).setWaitingLearners(null);
                ((SynchGateActivity)act).setSystemTool(this.systemToolDAO.getSystemToolByID(SystemTool.SYNC_GATE));
                break;
            }
            case 4: {
                act = new ScheduleGateActivity();
                ((ScheduleGateActivity)act).setGateActivityLevelId(actDto.getGateActivityLevelID());
                ((ScheduleGateActivity)act).setWaitingLearners(null);
                ((ScheduleGateActivity)act).setGateOpen(false);
                ((ScheduleGateActivity)act).setGateEndDateTime(actDto.getGateEndDateTime());
                ((ScheduleGateActivity)act).setGateStartDateTime(actDto.getGateStartDateTime());
                ((ScheduleGateActivity)act).setGateStartTimeOffset(actDto.getGateStartTimeOffset());
                ((ScheduleGateActivity)act).setGateEndTimeOffset(actDto.getGateEndTimeOffset());
                ((ScheduleGateActivity)act).setSystemTool(this.systemToolDAO.getSystemToolByID(SystemTool.SCHEDULE_GATE));
                break;
            }
            case 5: {
                act = new PermissionGateActivity();
                ((PermissionGateActivity)act).setGateActivityLevelId(actDto.getGateActivityLevelID());
                ((PermissionGateActivity)act).setGateOpen(false);
                ((PermissionGateActivity)act).setWaitingLearners(null);
                ((PermissionGateActivity)act).setSystemTool(this.systemToolDAO.getSystemToolByID(SystemTool.PERMISSION_GATE));
                break;
            }
            case 6: {
                act = new ParallelActivity();
                break;
            }
            case 7: {
                act = new OptionsActivity();
                ((OptionsActivity)act).setMaxNumberOfOptions(actDto.getMaxOptions());
                ((OptionsActivity)act).setMinNumberOfOptions(actDto.getMinOptions());
                ((OptionsActivity)act).setOptionsInstructions(actDto.getOptionsInstructions());
                break;
            }
            case 8: {
                act = new SequenceActivity();
            }
        }
        act.setGroupingSupportType(actDto.getGroupingSupportType());
        act.setActivityUIID(actDto.getActivityUIID());
        act.setActivityCategoryID(actDto.getActivityCategoryID());
        act.setActivityId(actDto.getActivityID());
        act.setActivityTypeId(actDto.getActivityTypeID());
        act.setApplyGrouping(actDto.getApplyGrouping());
        act.setDefineLater(actDto.getDefineLater());
        act.setDescription(actDto.getDescription());
        act.setHelpText(actDto.getHelpText());
        act.setLanguageFile(actDto.getLanguageFile());
        act.setLibraryActivityUiImage(actDto.getLibraryActivityUIImage());
        act.setOrderId(actDto.getOrderID());
        act.setParentActivity(null);
        act.setParentUIID(actDto.getParentUIID());
        act.setRunOffline(actDto.getRunOffline());
        act.setTitle(actDto.getActivityTitle());
        act.setXcoord(actDto.getxCoord());
        act.setYcoord(actDto.getyCoord());
        newGrouping = groupingList.get(actDto.getGroupingID());
        act.setGrouping(newGrouping);
        if (newGrouping != null) {
            act.setGroupingUIID(newGrouping.getGroupingUIID());
        }
        act.setCreateDateTime(new Date());
        return act;
    }

    public IActivityDAO getActivityDAO() {
        return this.activityDAO;
    }

    public void setActivityDAO(IActivityDAO activityDAO) {
        this.activityDAO = activityDAO;
    }

    public IGroupingDAO getGroupingDAO() {
        return this.groupingDAO;
    }

    public void setGroupingDAO(IGroupingDAO groupingDAO) {
        this.groupingDAO = groupingDAO;
    }

    public ILearningDesignDAO getLearningDesignDAO() {
        return this.learningDesignDAO;
    }

    public void setLearningDesignDAO(ILearningDesignDAO learningDesignDAO) {
        this.learningDesignDAO = learningDesignDAO;
    }

    public ILicenseDAO getLicenseDAO() {
        return this.licenseDAO;
    }

    public void setBaseDAO(IBaseDAO baseDAO) {
        this.baseDAO = baseDAO;
    }

    public void setLicenseDAO(ILicenseDAO licenseDAO) {
        this.licenseDAO = licenseDAO;
    }

    public IToolContentDAO getToolContentDAO() {
        return this.toolContentDAO;
    }

    public void setToolContentDAO(IToolContentDAO toolContentDAO) {
        this.toolContentDAO = toolContentDAO;
    }

    public IToolDAO getToolDAO() {
        return this.toolDAO;
    }

    public void setToolDAO(IToolDAO toolDAO) {
        this.toolDAO = toolDAO;
    }

    public ITransitionDAO getTransitionDAO() {
        return this.transitionDAO;
    }

    public void setTransitionDAO(ITransitionDAO transitionDAO) {
        this.transitionDAO = transitionDAO;
    }

    private boolean isComplexActivity(Activity act) {
        return act.getActivityTypeId() == 8 || act.getActivityTypeId() == 6 || act.getActivityTypeId() == 7;
    }

    public void setToolImportSupportDAO(IToolImportSupportDAO toolImportSupportDAO) {
        this.toolImportSupportDAO = toolImportSupportDAO;
    }

    public void setLearningLibraryDAO(ILearningLibraryDAO learningLibraryDAO) {
        this.learningLibraryDAO = learningLibraryDAO;
    }

    public void setSystemToolDAO(ISystemToolDAO systemToolDAO) {
        this.systemToolDAO = systemToolDAO;
    }

    public class ToolCompatibleStrategy {
        public Tool getTool(String toolSignature) {
            return ExportToolContentService.this.toolDAO.getToolBySignature(toolSignature);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FileInvocationHandler
    implements InvocationHandler {
        private Object obj;
        private List<ValueInfo> fileNodes;
        private List<NameInfo> fileHandleClassList;

        public FileInvocationHandler(Object obj) {
            this.obj = obj;
            this.fileNodes = new ArrayList<ValueInfo>();
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object result;
            block8: {
                try {
                    if (StringUtils.equals((String)method.getName(), (String)"marshal")) {
                        for (NameInfo name : this.fileHandleClassList) {
                            Long uuid;
                            if (args[0] == null || !name.className.equals(args[0].getClass().getName()) || (uuid = NumberUtils.createLong((String)BeanUtils.getProperty((Object)args[0], (String)name.uuidFieldName))) == null) continue;
                            Long version = null;
                            if (name.versionFieldName != null) {
                                version = NumberUtils.createLong((String)BeanUtils.getProperty((Object)args[0], (String)name.versionFieldName));
                            }
                            ExportToolContentService.this.log.debug((Object)("XStream get file node [" + uuid + "," + version + "]."));
                            ExportToolContentService exportToolContentService = ExportToolContentService.this;
                            exportToolContentService.getClass();
                            this.fileNodes.add(exportToolContentService.new ValueInfo(uuid, version));
                        }
                    }
                    if (StringUtils.equals((String)method.getName(), (String)"canConvert")) {
                        boolean canConvert = false;
                        for (NameInfo info : this.fileHandleClassList) {
                            if (args[0] == null || !info.className.equals(((Class)args[0]).getName())) continue;
                            ExportToolContentService.this.log.debug((Object)("XStream will handle [" + info.className + "] as file node class."));
                            canConvert = true;
                            break;
                        }
                        return canConvert;
                    }
                    result = method.invoke(this.obj, args);
                    if (!StringUtils.equals((String)method.getName(), (String)"unmarshal") || result == null) break block8;
                    for (NameInfo name : this.fileHandleClassList) {
                        if (!name.className.equals(result.getClass().getName())) continue;
                        ExportToolContentService exportToolContentService = ExportToolContentService.this;
                        exportToolContentService.getClass();
                        this.fileNodes.add(exportToolContentService.new ValueInfo(name, result));
                        break;
                    }
                }
                catch (InvocationTargetException e) {
                    throw e.getTargetException();
                }
            }
            return result;
        }

        public List<ValueInfo> getFileNodes() {
            return this.fileNodes;
        }

        public List<NameInfo> getFileHandleClassList() {
            return this.fileHandleClassList;
        }

        public void setFileHandleClassList(List<NameInfo> fileHandleClassList) {
            this.fileHandleClassList = fileHandleClassList;
        }
    }

    private class ValueInfo {
        public NameInfo name;
        public Object instance;
        public Long fileUuid;
        public Long fileVersionId;

        public ValueInfo(NameInfo name, Object instance) {
            this.name = name;
            this.instance = instance;
        }

        public ValueInfo(Long uuid, Long versionId) {
            this.fileUuid = uuid;
            this.fileVersionId = versionId;
        }
    }

    private class NameInfo {
        public String className;
        public String uuidFieldName;
        public String versionFieldName;
        public String fileNameFieldName;
        public String mimeTypeFieldName;
        public String filePropertyFieldName;
        public String initalItemFieldName;

        public NameInfo(String className, String uuidFieldName, String versionFieldName) {
            this.className = className;
            this.uuidFieldName = uuidFieldName;
            this.versionFieldName = versionFieldName;
        }

        public NameInfo(String className, String uuidFieldName, String versionFieldName, String fileNameFieldName, String filePropertyFieldName, String mimeTypeFieldName, String initalItemFieldName) {
            this.className = className;
            this.uuidFieldName = uuidFieldName;
            this.versionFieldName = versionFieldName;
            this.fileNameFieldName = fileNameFieldName;
            this.filePropertyFieldName = filePropertyFieldName;
            this.mimeTypeFieldName = mimeTypeFieldName;
            this.initalItemFieldName = initalItemFieldName;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ActDTOParentComparator
    implements Comparator<AuthoringActivityDTO> {
        private ActDTOParentComparator() {
        }

        @Override
        public int compare(AuthoringActivityDTO a1, AuthoringActivityDTO a2) {
            if (a1.getActivityID().equals(a2.getParentActivityID())) {
                return -1;
            }
            return 1;
        }
    }
}

