/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.lesson;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.learningdesign.Group;
import org.lamsfoundation.lams.learningdesign.Grouping;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.User;

public class LessonClass
extends Grouping {
    private static Logger log = Logger.getLogger(LessonClass.class);
    private Group staffGroup;
    private Lesson lesson;

    public LessonClass() {
    }

    public LessonClass(Long groupingId, Set groups, Set activities, Group staffGroup, Lesson lesson) {
        super(groupingId, groups, activities, null);
        this.staffGroup = staffGroup;
        this.lesson = lesson;
    }

    public Group getStaffGroup() {
        return this.staffGroup;
    }

    public void setStaffGroup(Group staffGroup) {
        this.staffGroup = staffGroup;
    }

    public Lesson getLesson() {
        return this.lesson;
    }

    public void setLesson(Lesson lesson) {
        this.lesson = lesson;
    }

    public boolean isLearnerGroup(Group group) {
        if (group.getGroupId() == null || this.staffGroup.getGroupId() == null) {
            return false;
        }
        return this.staffGroup.getGroupId() != group.getGroupId();
    }

    public Grouping createCopy() {
        LessonClass lessonClass = new LessonClass();
        lessonClass.staffGroup = this.staffGroup;
        lessonClass.lesson = this.lesson;
        return lessonClass;
    }

    public boolean isStaffMember(User user) {
        if (user == null) {
            return false;
        }
        Group staff = this.getStaffGroup();
        return staff != null && staff.hasLearner(user);
    }

    public boolean addLearner(User user) {
        if (user == null) {
            return false;
        }
        Group learnersGroup = null;
        Iterator iter = this.getGroups().iterator();
        if (iter.hasNext()) {
            learnersGroup = (Group)iter.next();
        }
        if (learnersGroup == null) {
            Organisation lessonOrganisation;
            Organisation organisation = lessonOrganisation = this.getLesson() != null ? this.getLesson().getOrganisation() : null;
            if (lessonOrganisation == null) {
                log.warn((Object)"Adding a learner to a lesson class with no related organisation. Learner group name will be 'learners'.");
            }
            String learnerGroupName = lessonOrganisation != null ? lessonOrganisation.getName() : "";
            learnerGroupName = learnerGroupName + "learners";
            HashSet<User> users = new HashSet<User>();
            users.add(user);
            this.getGroups().add(Group.createLearnerGroup(this, learnerGroupName, users));
        }
        if (!learnersGroup.hasLearner(user)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Adding learner " + user.getLogin() + " to LessonClass " + this.getGroupingId()));
            }
            learnersGroup.getUsers().add(user);
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Not adding learner " + user.getLogin() + " to LessonClass " + this.getGroupingId() + ". User is already a learner."));
        }
        return false;
    }

    public boolean addStaffMember(User user) {
        if (user == null) {
            return false;
        }
        Group staffGroup = this.getStaffGroup();
        if (staffGroup == null) {
            Organisation lessonOrganisation;
            Organisation organisation = lessonOrganisation = this.getLesson() != null ? this.getLesson().getOrganisation() : null;
            if (lessonOrganisation == null) {
                log.warn((Object)"Adding a staff member to a lesson class with no related organisation. Staff group name will be 'staff'.");
            }
            String staffGroupName = lessonOrganisation != null ? lessonOrganisation.getName() : "";
            staffGroupName = staffGroupName + "staff";
            HashSet<User> users = new HashSet<User>();
            users.add(user);
            this.setStaffGroup(Group.createStaffGroup(this, staffGroupName, users));
            staffGroup = this.getStaffGroup();
        }
        if (!staffGroup.hasLearner(user)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Adding staff member " + user.getLogin() + " to LessonClass " + this.getGroupingId()));
            }
            staffGroup.getUsers().add(user);
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Not adding staff member " + user.getLogin() + " to LessonClass " + this.getGroupingId() + ". User is already a staff member."));
        }
        return false;
    }
}

