/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.lesson.dto;

import java.util.Date;
import java.util.Set;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.util.wddx.WDDXTAGS;

public class LessonDetailsDTO {
    private Long lessonID;
    private String lessonName;
    private String lessonDescription;
    private Integer lessonStateID;
    private Date createDateTime;
    private Date startDateTime;
    private String startDateTimeStr;
    private Date scheduleStartDate;
    private String scheduleStartDateStr;
    private Date scheduleEndDate;
    private Long duration;
    private Integer organisationID;
    private String organisationName;
    private String organisationDescription;
    private Integer workspaceFolderID;
    private String contentFolderID;
    private Long licenseID;
    private String licenseText;
    private Long learningDesignID;
    private Integer numberPossibleLearners;
    private Integer numberStartedLearners;

    public LessonDetailsDTO(Lesson lesson) {
        this.lessonID = lesson.getLessonId();
        this.lessonName = lesson.getLessonName();
        this.lessonDescription = lesson.getLessonDescription();
        this.lessonStateID = lesson.getLessonStateId();
        this.createDateTime = lesson.getCreateDateTime();
        this.startDateTime = lesson.getStartDateTime();
        this.startDateTimeStr = null;
        this.scheduleStartDate = lesson.getScheduleStartDate();
        this.scheduleStartDateStr = null;
        this.scheduleEndDate = lesson.getScheduleEndDate();
        this.duration = lesson.getLearningDesign().getDuration();
        this.organisationID = lesson.getOrganisation() != null ? lesson.getOrganisation().getOrganisationId() : WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER;
        this.organisationName = lesson.getOrganisation() != null ? lesson.getOrganisation().getName() : "string_null_value";
        this.organisationDescription = lesson.getOrganisation() != null ? lesson.getOrganisation().getDescription() : "string_null_value";
        this.workspaceFolderID = lesson.getLearningDesign().getWorkspaceFolder() != null ? lesson.getLearningDesign().getWorkspaceFolder().getWorkspaceFolderId() : WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER;
        this.contentFolderID = lesson.getLearningDesign().getContentFolderID() != null ? lesson.getLearningDesign().getContentFolderID() : "string_null_value";
        this.licenseID = lesson.getLearningDesign().getLicense() != null ? lesson.getLearningDesign().getLicense().getLicenseID() : WDDXTAGS.NUMERIC_NULL_VALUE_LONG;
        this.licenseText = lesson.getLearningDesign().getLicenseText() != null ? lesson.getLearningDesign().getLicenseText() : "string_null_value";
        this.learningDesignID = lesson.getLearningDesign().getLearningDesignId();
        Set allLearners = lesson.getAllLearners();
        this.numberPossibleLearners = new Integer(allLearners != null ? allLearners.size() : 0);
        this.numberStartedLearners = new Integer(0);
    }

    public Date getScheduleEndDate() {
        return this.scheduleEndDate;
    }

    public Date getScheduleStartDate() {
        return this.scheduleStartDate;
    }

    public String getScheduleStartDateStr() {
        return this.scheduleStartDateStr;
    }

    public void setScheduleStartDateStr(String scheduleStartDateStr) {
        this.scheduleStartDateStr = scheduleStartDateStr;
    }

    public Date getCreateDateTime() {
        return this.createDateTime != null ? this.createDateTime : WDDXTAGS.DATE_NULL_VALUE;
    }

    public Long getDuration() {
        return this.duration != null ? this.duration : WDDXTAGS.NUMERIC_NULL_VALUE_LONG;
    }

    public Long getLearningDesignID() {
        return this.learningDesignID != null ? this.learningDesignID : WDDXTAGS.NUMERIC_NULL_VALUE_LONG;
    }

    public Long getLessonID() {
        return this.lessonID != null ? this.lessonID : WDDXTAGS.NUMERIC_NULL_VALUE_LONG;
    }

    public Integer getLessonStateID() {
        return this.lessonStateID != null ? this.lessonStateID : WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER;
    }

    public Long getLicenseID() {
        return this.licenseID != null ? this.licenseID : WDDXTAGS.NUMERIC_NULL_VALUE_LONG;
    }

    public String getLicenseText() {
        return this.licenseText != null ? this.licenseText : "string_null_value";
    }

    public String getOrganisationDescription() {
        return this.organisationDescription != null ? this.organisationDescription : "string_null_value";
    }

    public Integer getOrganisationID() {
        return this.organisationID != null ? this.organisationID : WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER;
    }

    public String getOrganisationName() {
        return this.organisationName != null ? this.organisationName : "string_null_value";
    }

    public Date getStartDateTime() {
        return this.startDateTime != null ? this.startDateTime : WDDXTAGS.DATE_NULL_VALUE;
    }

    public String getStartDateTimeStr() {
        return this.startDateTimeStr != null ? this.startDateTimeStr : "string_null_value";
    }

    public void setStartDateTimeStr(String startDateTimeStr) {
        this.startDateTimeStr = startDateTimeStr;
    }

    public Integer getWorkspaceFolderID() {
        return this.workspaceFolderID != null ? this.workspaceFolderID : WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER;
    }

    public String getContentFolderID() {
        return this.contentFolderID != null ? this.contentFolderID : "string_null_value";
    }

    public Integer getNumberStartedLearners() {
        return this.numberStartedLearners;
    }

    public void setNumberStartedLearners(Integer numberStartedLearners) {
        this.numberStartedLearners = numberStartedLearners;
    }

    public String getLessonDescription() {
        return this.lessonDescription;
    }

    public String getLessonName() {
        return this.lessonName;
    }

    public Integer getNumberPossibleLearners() {
        return this.numberPossibleLearners;
    }
}

