/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.lesson.service;

import java.util.List;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.learningdesign.Grouper;
import org.lamsfoundation.lams.learningdesign.Grouping;
import org.lamsfoundation.lams.learningdesign.GroupingActivity;
import org.lamsfoundation.lams.learningdesign.dao.IGroupingDAO;
import org.lamsfoundation.lams.learningdesign.exception.GroupingException;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.lesson.LessonClass;
import org.lamsfoundation.lams.lesson.dao.ILessonClassDAO;
import org.lamsfoundation.lams.lesson.dao.ILessonDAO;
import org.lamsfoundation.lams.lesson.dto.LessonDTO;
import org.lamsfoundation.lams.lesson.dto.LessonDetailsDTO;
import org.lamsfoundation.lams.lesson.service.ILessonService;
import org.lamsfoundation.lams.lesson.service.LessonServiceException;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.util.MessageService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LessonService
implements ILessonService {
    private static Logger log = Logger.getLogger(LessonService.class);
    private ILessonDAO lessonDAO;
    private ILessonClassDAO lessonClassDAO;
    private IGroupingDAO groupingDAO;
    private MessageService messageService;

    public void setLessonDAO(ILessonDAO lessonDAO) {
        this.lessonDAO = lessonDAO;
    }

    public void setLessonClassDAO(ILessonClassDAO lessonClassDAO) {
        this.lessonClassDAO = lessonClassDAO;
    }

    public void setGroupingDAO(IGroupingDAO groupingDAO) {
        this.groupingDAO = groupingDAO;
    }

    public void setMessageService(MessageService messageService) {
        this.messageService = messageService;
    }

    @Override
    public List getActiveLessonLearners(Long lessonId) {
        return this.lessonDAO.getActiveLearnerByLesson(lessonId);
    }

    @Override
    public Integer getCountActiveLessonLearners(Long lessonId) {
        return this.lessonDAO.getCountActiveLearnerByLesson(lessonId);
    }

    @Override
    public LessonDetailsDTO getLessonDetails(Long lessonId) {
        Lesson lesson = this.lessonDAO.getLesson(lessonId);
        LessonDetailsDTO dto = null;
        if (lesson != null) {
            dto = lesson.getLessonDetails();
            Integer active = this.getCountActiveLessonLearners(lessonId);
            dto.setNumberStartedLearners(active != null ? active : new Integer(0));
        }
        return dto;
    }

    @Override
    public LessonDTO getLessonData(Long lessonId) {
        Lesson lesson = this.lessonDAO.getLesson(lessonId);
        LessonDTO dto = null;
        if (lesson != null) {
            dto = lesson.getLessonData();
        }
        return dto;
    }

    @Override
    public void performGrouping(Long lessonId, GroupingActivity groupingActivity, User learner) throws LessonServiceException {
        Grouping grouping = groupingActivity.getCreateGrouping();
        if (grouping != null && grouping.isRandomGrouping()) {
            Grouper grouper = (grouping = this.groupingDAO.getGroupingById(grouping.getGroupingId())).getGrouper();
            if (grouper != null) {
                grouper.setCommonMessageService(this.messageService);
                try {
                    if (grouping.getGroups().size() == 0) {
                        List usersInLesson = this.getActiveLessonLearners(lessonId);
                        grouper.doGrouping(grouping, (String)null, usersInLesson);
                    } else if (!grouping.doesLearnerExist(learner)) {
                        grouper.doGrouping(grouping, null, learner);
                    }
                }
                catch (GroupingException e) {
                    throw new LessonServiceException(e);
                }
                this.groupingDAO.update(grouping);
            }
        } else {
            String error = "The method performGrouping supports only grouping methods where the grouper decides the groups (currently only RandomGrouping). Called with a groupingActivity with the wrong grouper " + groupingActivity.getActivityId();
            log.error((Object)error);
            throw new LessonServiceException(error);
        }
    }

    @Override
    public void performGrouping(GroupingActivity groupingActivity, String groupName, List learners) throws LessonServiceException {
        Grouping grouping = groupingActivity.getCreateGrouping();
        if (grouping != null && grouping.isChosenGrouping()) {
            Grouper grouper = grouping.getGrouper();
            if (grouper != null) {
                grouper.setCommonMessageService(this.messageService);
                try {
                    grouper.doGrouping(grouping, groupName, learners);
                }
                catch (GroupingException e) {
                    throw new LessonServiceException(e);
                }
                this.groupingDAO.update(grouping);
            }
        } else {
            String error = "The method performChosenGrouping supports only grouping methods where the supplied list should be used as a single group (currently only ChosenGrouping). Called with a groupingActivity with the wrong grouper " + groupingActivity.getActivityId();
            log.error((Object)error);
            throw new LessonServiceException(error);
        }
    }

    @Override
    public void performGrouping(GroupingActivity groupingActivity, Long groupId, List learners) throws LessonServiceException {
        Grouping grouping = groupingActivity.getCreateGrouping();
        if (grouping != null && grouping.isChosenGrouping()) {
            Grouper grouper = grouping.getGrouper();
            if (grouper != null) {
                grouper.setCommonMessageService(this.messageService);
                try {
                    grouper.doGrouping(grouping, groupId, learners);
                }
                catch (GroupingException e) {
                    throw new LessonServiceException(e);
                }
                this.groupingDAO.update(grouping);
            }
        } else {
            String error = "The method performChosenGrouping supports only grouping methods where the supplied list should be used as a single group (currently only ChosenGrouping). Called with a groupingActivity with the wrong grouper " + groupingActivity.getActivityId();
            log.error((Object)error);
            throw new LessonServiceException(error);
        }
    }

    @Override
    public void removeLearnersFromGroup(GroupingActivity groupingActivity, Long groupID, List<User> learners) throws LessonServiceException {
        Grouping grouping = groupingActivity.getCreateGrouping();
        if (grouping != null) {
            Grouper grouper = (grouping = this.groupingDAO.getGroupingById(grouping.getGroupingId())).getGrouper();
            if (grouper != null) {
                try {
                    grouper.removeLearnersFromGroup(grouping, groupID, learners);
                }
                catch (GroupingException e) {
                    throw new LessonServiceException(e);
                }
            }
            this.groupingDAO.update(grouping);
        }
    }

    @Override
    public void createGroup(GroupingActivity groupingActivity, String name) throws LessonServiceException {
        Grouping grouping = groupingActivity.getCreateGrouping();
        if (grouping != null) {
            Grouper grouper = (grouping = this.groupingDAO.getGroupingById(grouping.getGroupingId())).getGrouper();
            if (grouper != null) {
                try {
                    grouper.createGroup(grouping, name);
                }
                catch (GroupingException e) {
                    throw new LessonServiceException(e);
                }
            }
            this.groupingDAO.update(grouping);
        }
    }

    @Override
    public void removeGroup(GroupingActivity groupingActivity, Long groupID) throws LessonServiceException {
        Grouping grouping = groupingActivity.getCreateGrouping();
        if (grouping != null) {
            Grouper grouper = (grouping = this.groupingDAO.getGroupingById(grouping.getGroupingId())).getGrouper();
            if (grouper != null) {
                try {
                    grouper.removeGroup(grouping, groupID);
                }
                catch (GroupingException e) {
                    throw new LessonServiceException(e);
                }
            }
            this.groupingDAO.update(grouping);
        }
    }

    @Override
    public boolean addLearner(Long lessonId, User user) throws LessonServiceException {
        Lesson lesson = this.lessonDAO.getLesson(lessonId);
        if (lesson == null) {
            throw new LessonServiceException("Lesson " + lessonId + " does not exist. Unable to add learner to lesson.");
        }
        LessonClass lessonClass = lesson.getLessonClass();
        if (lessonClass == null) {
            throw new LessonServiceException("Lesson class for " + lessonId + " does not exist. Unable to add learner to lesson.");
        }
        boolean ret = lessonClass.addLearner(user);
        if (ret) {
            this.lessonClassDAO.updateLessonClass(lessonClass);
        }
        return ret;
    }

    @Override
    public boolean addStaffMember(Long lessonId, User user) {
        Lesson lesson = this.lessonDAO.getLesson(lessonId);
        if (lesson == null) {
            throw new LessonServiceException("Lesson " + lessonId + " does not exist. Unable to add staff member to lesson.");
        }
        LessonClass lessonClass = lesson.getLessonClass();
        if (lessonClass == null) {
            throw new LessonServiceException("Lesson class for " + lessonId + " does not exist. Unable to add staff member to lesson.");
        }
        boolean ret = lessonClass.addStaffMember(user);
        if (ret) {
            this.lessonClassDAO.updateLessonClass(lessonClass);
        }
        return ret;
    }
}

