/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.dbupdates;

import com.tacitknowledge.util.migration.MigrationContext;
import com.tacitknowledge.util.migration.MigrationException;
import com.tacitknowledge.util.migration.MigrationTaskSupport;
import com.tacitknowledge.util.migration.jdbc.DataSourceMigrationContext;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Locale;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.util.MessageService;
import org.springframework.context.MessageSource;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class Patch0012FixWorkspaceNames
extends MigrationTaskSupport {
    private static Logger log = Logger.getLogger(Patch0012FixWorkspaceNames.class);
    private static final Integer LEVEL = new Integer(12);
    private static final String NAME = "FixRunSeqFolders";
    private String updateWorkspaceName = "UPDATE lams_workspace w, lams_organisation o SET w.name=o.name WHERE o.workspace_id=w.workspace_id";
    private String updateFolderName = "UPDATE lams_workspace_folder wf, lams_workspace w, lams_organisation o SET wf.name=o.name WHERE o.workspace_id=w.workspace_id AND w.default_fld_id=wf.workspace_folder_id";
    private String updateRunSeqFolderName = "UPDATE lams_workspace_folder wf, lams_workspace w, lams_organisation o SET wf.name=concat(o.name, ?) WHERE o.workspace_id=w.workspace_id AND w.def_run_seq_fld_id=wf.workspace_folder_id";

    public Patch0012FixWorkspaceNames() {
        this.setLevel(LEVEL);
        this.setName(NAME);
    }

    public void migrate(MigrationContext context) throws MigrationException {
        DataSourceMigrationContext ctx = (DataSourceMigrationContext)context;
        Connection conn = null;
        try {
            conn = ctx.getConnection();
            conn.setAutoCommit(false);
            PreparedStatement query = conn.prepareStatement(this.updateWorkspaceName);
            int numUpdatedWorkspaces = query.executeUpdate();
            log.info((Object)("Updated " + numUpdatedWorkspaces + " workspace names."));
            query = conn.prepareStatement(this.updateFolderName);
            int numUpdatedFolderNames = query.executeUpdate();
            log.info((Object)("Updated " + numUpdatedFolderNames + " workspace folder names."));
            String i18nMessage = this.getI18nMessage(conn);
            query = conn.prepareStatement(this.updateRunSeqFolderName);
            query.setString(1, i18nMessage);
            int numUpdatedRunSeqFolderNames = query.executeUpdate();
            log.info((Object)("Updated " + numUpdatedRunSeqFolderNames + " run sequences workspace folder names."));
            ctx.commit();
        }
        catch (Exception e) {
            ctx.rollback();
            throw new MigrationException("Problem running update; ", (Throwable)e);
        }
    }

    private String getI18nMessage(Connection conn) throws MigrationException {
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("org/lamsfoundation/lams/messageContext.xml");
        MessageService messageService = (MessageService)context.getBean("commonMessageService");
        String defaultLocale = "en_AU";
        String getDefaultLocaleStmt = "select config_value from lams_configuration where config_key='ServerLanguage'";
        try {
            PreparedStatement query = conn.prepareStatement(getDefaultLocaleStmt);
            ResultSet results = query.executeQuery();
            while (results.next()) {
                defaultLocale = results.getString("config_value");
            }
        }
        catch (Exception e) {
            throw new MigrationException("Problem running update; ", (Throwable)e);
        }
        String[] tokenisedLocale = defaultLocale.split("_");
        Locale locale = new Locale(tokenisedLocale[0], tokenisedLocale[1]);
        MessageSource messageSource = messageService.getMessageSource();
        String i18nMessage = messageSource.getMessage("runsequences.folder.name", new Object[]{""}, locale);
        if (i18nMessage != null && i18nMessage.startsWith("???")) {
            return " Run Sequences";
        }
        return i18nMessage;
    }
}

